<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $_SESSION[QT]['picture']=='0' ) die($L['E_access']);
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include('bin/qt_lib_smtp.php');
include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));
include(Translate($_SESSION[QT]['language'],'qte_lang_reg.inc'));

$s = -1;
if (isset($_GET['s'])) $s = intval($_GET['s']);
if (isset($_POST['s'])) $s = intval($_POST['s']);
if ( $s<0 ) die('Missing parameters');

$strImg = 'picture/s_none.gif';

$oVIP->selfurl = 'qte_adm_section_img.php';
$oVIP->selfname = $L['Change_picture'];
$oVIP->exiturl = 'qte_adm_section.php?s='.$s;
$oVIP->exitname = $L['Section_upd'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['del']) )
{
  // delete picture
  $oDB->Query('UPDATE '.TABSECTION.' SET picture=null WHERE id='.$s);
  if (file_exists($_POST['file'])) unlink($_POST['file']);
  // exit
  $oVIP->EndMessage(NULL,$L['S_delete'],$_SESSION[QT]['skin_dir'],2);
}

if ( isset($_POST['ok']) )
{
  // load picture
  if ( !is_uploaded_file($_FILES['title']['tmp_name']) )
  {
    $qte_error = "You id not upload a file!";
  }
  else
  {
    $lstExt = explode(',',$_SESSION[QT]['picture']);
    foreach ($lstExt as $ext)
    {
    $lstFormat[] = "image/$ext";
    }

    if ( !in_array($_FILES['title']['type'],$lstFormat) )
    {
      $qte_error = 'Format not supported...';
      unlink($_FILES['title']['tmp_name']);
    }
    else
    {
      if ($_FILES['title']['type']=='image/png') $ext = '.png';
      elseif ($_FILES['title']['type']=='image/gif') $ext = '.gif';
      else $ext = '.jpg';

      $size = getimagesize($_FILES['title']['tmp_name']);
      $width = $size[0];
      $height = $size[1];
      if (($width > 202) or ($height > 202))
      {
        $qte_error = '200x200'.S.$L['E_pixels_max'];
        unlink($_FILES['title']['tmp_name']);
      }
      else
      {
        //File has passed all validation, copy it to the final destination and remove the temporary file:
        copy($_FILES['title']['tmp_name'],'picture/s_'.$s.$ext);
        $oDB->Query('UPDATE '.TABSECTION.' SET picture="picture/s_'.$s.$ext.'" WHERE id='.$s);
        unlink($_FILES['title']['tmp_name']);

        // exit
        $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
      }
    }
  }
}

// --------
// HTML START
// --------

if ( $oVIP->role!='A' ) { if ($oVIP->id!=$s) die($L['R_user']); }

include('qte_adm_p_header.php');

$oDB->Query('SELECT picture,title FROM '.TABSECTION.' WHERE id='.$s);
$row = $oDB->Getrow();
if ( !empty($row['picture']) ) $strImg = $row['picture'];

echo '<br/>',N;
echo '<table class="tab_hidden" cellspacing="0">',N;
echo '<tr class="tr_hidden">',N;
echo '<td class="td_hidden" style="width:210px;">',AsImg($strImg),'</td>',N;
echo '<td class="td_hidden" style="width:360px;">',N;

echo '<div class="div_msgboxtitle" style="width: 350px;">',$oVIP->selfname,'</div>',N;
echo '<div class="div_msgbox" style="width:350px;">',N;

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': File")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" enctype="multipart/form-data" onsubmit="return ValidateForm(this);">',N;
if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span>',N;
echo '<p class="small" style="text-align:right">',$L['H_Change_logo'],'</p>',N;
echo '<p style="text-align:right">',N;
echo '<input type="file" id="title" name="title" size="32"/>',N;
echo '<input type="hidden" name="max_file_size" value="10000"/>',N;
echo '<input type="hidden" name="s" value="',$s,'"/>',N;
echo '<input type="submit" name="ok" value="',$L['Save'],'"/></p>',N;
echo '</form><br/>',N;
echo '<form method="post" action="',$oVIP->selfurl,'">',N;
echo '<p style="text-align:right">',N;
echo $L['Delete_picture'],S,N;
echo '<input type="hidden" name="s" value="',$s,'"/>',N;
echo '<input type="hidden" name="file" value="',$row['picture'],'"/>',N;
echo '<input type="submit" name="del" value="',$L['Delete'],'"/></p>',N;
echo '</form>',N;
echo '&laquo;&nbsp;<a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a>',N;
echo '</div>',N;

echo '</td>',N;
echo '<td> </td>',N;
echo '</tr>',N;
echo '</table>',N,'<br/>',N;

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>