<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
include('bin/qte_fn_sort.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$s = -1;
if ( isset($_GET['s']) ) $s = intval($_GET['s']);
if ( $s<0 ) die('missing section id...');

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

$oSEC = new cSection($oDB,$s);
$oUser = new cUser($oDB,1,$qte_fields);

$oVIP->selfurl = 'qte_adm_section_col.php';
$oVIP->exiturl = 'qte_adm_section.php?s='.$s;
$oVIP->exitname = '&laquo;'.S.$L['Section_man'];
$oVIP->selfname = $L['Section_upd'];
$oVIP->exitname = '&laquo;'.S.$L['Section_man'];

// --------
// SUBMITTED
// --------

if ( isset($_GET['a']) )
{  
  switch($_GET['a'])
  {
  case $L['Add']:
    if ( substr($_GET['v'],0,1)!='-' )
    {
    if ( in_array($_GET['v'],$_SESSION['fields']) ) $qte_error = $L['E_already_used'];
    if ( count($_SESSION['fields'])>=10 ) $qte_error = $L['E_max_10'];
    if ( empty($qte_error) )
    {
      $_SESSION['fields'] = Changelist($_SESSION['fields'],'add',$_GET['v']);
      if ( count($_SESSION['fields'])>6 ) $qte_error = $L['E_more_than_5'];
    }
    }
    break;
  case 'del': $_SESSION['fields'] = Changelist($_SESSION['fields'],'del',$_GET['v']); unset($_SESSION['values']); break;
  case 'left': $_SESSION['fields'] = Changelist($_SESSION['fields'],'left',$_GET['v']); break;
  case 'right': $_SESSION['fields'] = Changelist($_SESSION['fields'],'right',$_GET['v']); break;
  case 'default': $_SESSION['fields'] = array('status_i','fullname','phones','emails_i','picture'); break;
  }
}

if ( isset($_GET['ok']) )
{
  $oSEC->forder = implode(';',$_SESSION['fields']);
  $oDB->Query('UPDATE '.TABSECTION.' SET forder="'.$oSEC->forder.'" WHERE id='.$s);
  unset($_SESSION['fields']);
  // exit
  $oVIP->EndMessage(NULL,$L['S_update'],'admin',2);
}

// --------
// HTML START
// --------

if ( !isset($_SESSION['fields']) || !isset($_GET['a']) )
{
  $_SESSION['fields'] = GetUsableFields($qte_fields,$oSEC->forder,'nid');
}

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

$strChoicelist = QTastags(ChoiceList($qte_fields,$_SESSION['fields']));
$strChoicelist = str_replace('>[X] ','disabled="disabled">',$strChoicelist);
$strChoicelist = str_replace('-">','-" disabled="disabled">',$strChoicelist);

echo '<h2>',$L['Columns'],': ',$oSEC->title,'</h2><br/><br/>';

echo '<form method="get" action="',$oVIP->selfurl,'">';
echo '<select id="v" name="v">',$strChoicelist,'</select>';
echo '<input type="hidden" name="s" value="',$s,'"/>';
echo '&nbsp;<input type="submit" name="a" value="',$L['Add'],'"/>';
echo ' <a href="',$oVIP->selfurl,'?s=',$s,'&amp;a=default">',$L['Default_fields'],'</a>';
echo '<br/ ><br/>';

echo '<table cellspacing="0" class="tab">';

// editor
echo '<tr class="tr">';
foreach ($_SESSION['fields'] as $strField) 
{
echo '<th class="th_o th_o_first" style="text-align:center; min-width:40px">
<a href="',$oVIP->selfurl,'?s=',$s,'&amp;a=left&amp;v=',$strField,'"><img src="admin/sort_left.gif" style="border-width:0" alt="&lt;" title="move left"/></a>
<a href="',$oVIP->selfurl,'?s=',$s,'&amp;a=del&amp;v=',$strField,'"><img src="admin/sort_del.gif" style="border-width:0" alt="x" title="delete"/></a>
<a href="',$oVIP->selfurl,'?s=',$s,'&amp;a=right&amp;v=',$strField,'"><img src="admin/sort_right.gif" style="border-width:0" alt="&gt;" title="move right"/></a>
</th>';
}
echo '</tr>',N;

// head
echo '<tr class="tr">';
foreach ($_SESSION['fields'] as $strField) 
{
  $strLabel = $qte_fields[$strField][0];
  // exception
  if ( $strField=='emails_i' ) $strLabel=$qte_fields['emails'][0];
  if ( $strField=='status_i' ) $strLabel=$qte_fields['status'][0];
  
  echo '<th class="th_o th_o_first" style="text-align:center">',$strLabel,'</th>';
}
echo '</tr>',N;

// value sample
echo '<tr class="tr">';

foreach ($_SESSION['fields'] as $strField) 
{
  switch ($strField)
  {
  case 'status_i':
    echo '<td class="td_s" style="text-align:center">',AsImg($_SESSION[QT]['skin_dir'].'/'.$_SESSION['qte_status_icon'][$oUser->status]),'</td>',N;
    break; 
  case 'status':
    echo '<td class="td_s" style="text-align:center">',$_SESSION['qte_status_name'][$oUser->status],'</td>',N;
    break; 
  case 'picture':
    if ( count($_SESSION['fields'])>6 )
    {
    echo '<td class="td_s" style="text-align:center; width:60px">',AsImg($oUser->picture,null,$oUser->fullname,null,'height:35px;'),'</td>',N;
    }
    else
    {
    echo '<td class="td_s" style="text-align:center; width:120px">',AsImg($oUser->picture,null,$oUser->fullname),'</td>',N;
    }
    break; 
  case 'age':
    echo '<td class="td_s" style="text-align:center">',$oUser->age,'</td>',N;
    break; 
  case 'role':
    echo '<td class="td_s" style="text-align:center">',$L['Userrole'][$oUser->role],'</td>',N;
    break; 
  case 'username': 
    echo '<td class="td_s" style="text-align:center"><a href="qte_usr_p.php?id=1">',$oUser->username,'</a></td>',N;
    break; 
  case 'emails':
    echo '<td class="td_s" style="text-align:center"><a class="small" href="mailto:',$oUser->emails,'">',AsTextList($oUser->emails),'</a></td>',N;
    break;
  case 'emails_i':
    echo '<td class="td_s" style="text-align:center"><a class="small" href="mailto:',$oUser->emails,'">',AsImg($_SESSION[QT]['skin_dir'].'/ico_user_e_1.gif','mail',$oUser->emails),'</a></td>',N;
    break;
  default:
    echo '<td class="td_s" style="text-align:center">',(!empty($oUser->$strField) ? AsTextList($oUser->$strField) : S),'</td>',N;
    break;
  }
}

echo '</tr>',N;

echo '</table>',N,N;

echo '<br/><input type="submit" name="ok" value="',$L['Save'],'"/>';
echo '</form>';

// --------
// HTML END
// --------

echo '<p><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a></p>';

include('qte_adm_p_footer.php');

?>