<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
Unset($_SESSION['qteDomain']);
Unset($_SESSION['qteGoto']);

require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$s = -1;
if ( isset($_GET['s']) ) $s = intval($_GET['s']);
if ( isset($_POST['s']) ) $s = intval($_POST['s']);
if ( $s<0 ) die('Missing parameters');

require_once('bin/qte_class_section.php');
include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));
include(Translate($_SESSION[QT]['language'],'qte_lang_reg.inc'));

$oVIP->selfurl  = 'qte_adm_section.php';
$oVIP->selfname = $L['Section_upd'];
$oVIP->exiturl  = 'qte_adm_sections.php';
$oVIP->exitname = '&laquo;'.S.$L['Section_man'];

$arrStaff = GetUsers($oDB,'M');
$oSEC = new cSection($oDB,$s);

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // CHECK MANDATORY VALUE

  $str = trim(strip_tags($_POST['title'])); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QThtmlquote($str,true,true,QTE_CONVERT_AMP);
  if ( empty($str) ) $qte_error = $L['Title'].S.$L['E_invalid'];

  if ( empty($qte_error) )
  {
    $oSEC->id = $s;
    $oSEC->domainid = $_POST['domainid'];
    $oSEC->title = $str;
    $str = trim($_POST['descr']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $oSEC->descr = QThtmlquote($str,true,true,QTE_CONVERT_AMP);
    $oSEC->type = intval($_POST['type']);
    $oSEC->status = intval($_POST['status']);
    if ( isset($_POST['modname']) )
    {
      if ( $_POST['modname']!=$_POST['modnameold'] )
      {
      $oSEC->modname = $_POST['modname'];
      $oSEC->modid = array_search($_POST['modname'],$arrStaff);
      if ( $oSEC->modid==FALSE || empty($oSEC->modid) ) { $oSEC->modid=1; $oSEC->modname=$arrStaff[1]; $qte_warning=$L['Userrole_MF'].S.$L['E_invalid']; }
      }
    }
    if ( isset($_POST['modid']) )
    {
      if ( $_POST['modid']!=$_POST['modidold'] )
      {
        $oSEC->modname = $arrStaff[$_POST['modid']];
        $oSEC->modid = $_POST['modid'];
      }
    }
  }

  // SAVE

  if ( empty($qte_error) )
  {
    // update
    $oDB->Query('UPDATE '.TABSECTION.' SET domainid='.$oSEC->domainid.', title="'.$oSEC->title.'", descr="'.$oSEC->descr.'", type="'.$oSEC->type.'", status="'.$oSEC->status.'", modid='.$oSEC->modid.', modname="'.$oSEC->modname.'" WHERE id='.$oSEC->id);
    // exit
    $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

$bAjax=true;
include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

$arrDest = $_SESSION['qteDomains'];
Unset($arrDest[$oSEC->domainid]);

// FORM

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Title'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table class="tab" cellspacing="0">
<tr class="tr">
<th class="th_o th_o_all" colspan="2"><b>',$L['Classification'],'</b></th>
</tr>
';
echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px; text-align:right"><span class="texthead">',$L['Domain'],'</span></th>';
echo '<td class="td_o"><select name="domainid">';
echo '<option value="',$oSEC->domainid,'"',QSEL,'>',$_SESSION['qteDomains'][$oSEC->domainid],'</option>',N;
echo QTastags($arrDest,$L['Move_to'].': %s');
echo '</select></td>';
echo '</tr>',N;

echo '<tr class="tr">';
echo '<th class="th_o th_o_all" colspan="2"><b>',$L['Definition'],'</b></th>';
echo '</tr>',N;

echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px"><span class="texthead">Id</span></th>';
echo '<td class="td_o">',$oSEC->id,'</td>';
echo '</tr>',N;
echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px"><span class="texthead"><label for="type">',$L['Type'],'</label></span></th>';
echo '<td class="td_o">';
echo '<select id="type" name="type">';
echo '<option value="0"',($oSEC->type=='0' ? QSEL : ''),'>',$L['Section_type'][0],'</option>';
echo '<option value="1"',($oSEC->type=='1' ? QSEL : ''),'>',$L['Section_type'][1],'</option>';
echo '</select>';
echo S,$L['Status'],' <select id="status" name="status">';
echo '<option value="0"',($oSEC->status=='0' ? QSEL : ''),'>',$L['Section_status'][0],'</option>';
echo '<option value="1"',($oSEC->status=='1' ? QSEL : ''),'>',$L['Section_status'][1],'</option>';
echo '</select>';
echo '</tr>',N;
echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px"><span class="texthead"><label for="title">',$L['Title'],'</label></span></th>';
echo '<td class="td_o"><input type="text" id="title" name="title" size="55" maxlength="64" value="',$oSEC->title,'" style="background-color:#FFFF99;"/></td>';
echo '</tr>',N;
echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Description'],'</span></th>';
echo '<td class="td_o"><textarea name="descr" rows="3" cols="55">',$oSEC->descr,'</textarea></td>';
echo '</tr>',N;
echo '<tr class="tr">';
echo '<th class="th_o th_o_all" colspan="2"><b>',$L['Options'],'</b></th>';
echo '</tr>',N;
if ( count($arrStaff)>15 )
{
echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Section_moderator'],'</span></th>';
echo '<td class="td_o"><input type="hidden" name="modnameold" value="',$oSEC->modname,'"/>';
echo '<input type="text" name="modname" id="modname" value="',$oSEC->modname,'" size="24" maxlength="32"/>';
echo '</td>';
echo '</tr>',N;
}
else
{
echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Section_moderator'],'</span></th>';
echo '<td class="td_o"><input type="hidden" name="modidold" value="',$oSEC->modname,'"/>';
echo '<select name="modid" id="modid"/>',QTastags($arrStaff,null,$oSEC->modid,null,$oSEC->modid,'bold'),'</select>';
echo '</td>';
echo '</tr>',N;
}
echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Picture'],'</span></th>';
echo '<td class="td_o">',( !empty($oSEC->picture) ? AsImg($oSEC->picture) : '' ),' <a href="qte_adm_section_img.php?s=',$oSEC->id,'">',$L['Change_picture'],'</a></td>';
echo '</tr>',N;
echo '<tr class="tr">';
echo '<th class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Columns'],'</span></th>';
echo '<td class="td_o">',GetUsableFields($qte_fields,$oSEC->forder,'name',', '),' &middot; <a href="qte_adm_section_col.php?s=',$oSEC->id,'">',$L['Edit'],'</a></td>';
echo '</tr>',N;
echo '<tr class="tr">';
echo '<th class="th_o" colspan="2" style="padding:6px; text-align:center"><input type="hidden" name="s" value="',$oSEC->id,'"/><input type="submit" name="ok" value="',$L['Save'],'"/></th>';
echo '</tr>',N;

echo '</table></form>',N;


// --------
// HTML END
// --------

echo '<br/><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a><br/>',N;

if ( isset($bAjax) )
{
echo '<script type="text/javascript">
<!--
var options_xml = {script: function (input) { return "qte_j_name.php?r=M&username="+document.getElementById("modname").value; },varname:"input"};var as_xml = new bsn.AutoSuggest("modname", options_xml);
-->
</script>';
}

include('qte_adm_p_footer.php');

?>