<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

$strAction = 'add';
if ( isset($_GET['a']) ) $strAction = $_GET['a'];

// ---------
// INITIALISE
// ---------

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

$oVIP->selfurl = 'qte_adm_module.php';
$oVIP->selfname = $L['Adm_modules'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  $strAction = 'add';
  if ( isset($_POST['action']) ) $strAction = $_POST['action'];

  // check form
  $strName = strtolower(strip_tags(trim($_POST['name']))); if ( get_magic_quotes_gpc() ) $strName = stripslashes($strName);
  $strName = str_replace(' ','_',$strName);
  $strFile = 'qtem_'.$strName.'_'.($strAction=='rem' ? 'un' : '').'install.php';

  if ( file_exists($strFile) )
  {
  // exit
  $oVIP->exiturl = $strFile;
  $oVIP->exitname = $L['Module_'.$strAction];
    $oVIP->EndMessage(NULL,$L['Module_name'].': '.$strName,'admin',0);
  }
  else
  {
  $qte_error = 'Module not found... ('.$strFile.')<br/><br/>Possible cause: components of this module are not uploaded.';
  }
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

// FORM

echo '<form method="post" action="',$oVIP->selfurl,'">
<table class="tab" cellspacing="0">
';
echo '<tr class="tr">
<th class="th_o th_o_first" style="width:200px;"><label for="name">',$L['Module_'.$strAction],'</label></th>
<td class="td_o"><input id="name" name="name" size="12" maxlength="24" value="" onKeyUp="handle_keypress(event,\'ok\')"/>&nbsp;<span class="help">',$L['Module_name'],'</span></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_first">&nbsp;</th>
<td class="td_o"><input type="hidden" name="action" value="',$strAction,'"/><input type="submit" id="ok" name="ok" value="',$L['Search'],'"/></td>
</tr>
';
echo '</table></form><br/>
';

// --------
// HTML END
// --------

echo '<script type="text/javascript">document.getElementById(\'name\').focus();</script>',N;

include('qte_adm_p_footer.php');

?>
