<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
require_once('bin/qte_fn_sort.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

  $strEditLang = substr($_SESSION[QT]['language'],9);

  // when several languages are allowed, admin can edit several language
  if ($_SESSION[QT]['userlang']=='1' )
  {
    if ( isset($_GET['editlang']) ) $strEditLang = $_GET['editlang'];
    if ( isset($_POST['editlang']) ) $strEditLang = $_POST['editlang'];
    if ( $strEditLang!=substr($_SESSION[QT]['language'],9) )
    {
      $qte_fields = array();
      include($qte_root.'bin/config_'.$strEditLang.'.php');
    }
    // Read directory in language
    $intHandle = opendir('language');
    $arrLangs = array();
    while ( false!==($strFile = readdir($intHandle)) )
    {
    if ( $strFile!='.' && $strFile!='..' ) $arrLangs[$strFile] = ucfirst($strFile);
    }
    closedir($intHandle);
    asort($arrLangs);
  }

$oVIP->selfurl = 'qte_adm_fields.php';
$oVIP->exiturl = 'qte_adm_fields.php';
$oVIP->selfname = $L['Field_man'];
$oVIP->exitname = $L['Field_man'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // about allowed dates (default is '2')
  // '0' = dates in the future area allowed,
  // '1' = reject dates in the future
  // '2' = reject dates in the future (except this year)

  // default settings (translation, format, is checked
  $arrFnewnames = array(
  'id'        => array('id','%s',true),
  'status'    => array('Status','%s',true),
  'status_i'  => array('Status icon','%s',true),
  'username'  => array('Username','%s',true),
  'pwd'       => array('Password','%s',true),
  'role'      => array('Role','%s',true),
  'picture'   => array('Picture','%s',false),
  'address'   => array('Address','%s',false),
  'phones'    => array('Phone','%s',false),
  'emails'    => array('E-mail','%s',false),
  'emails_i'  => array('E-mail icon','%s',false),
  'www'       => array('Web site','%s',false),
  'children'  => array('Child','%s',false),
  'title'     => array('Title','%s',false),
  'firstname' => array('Firstname','%s',false),
  'midname'   => array('Middlename','%s',false),
  'lastname'  => array('Lastname','%s',false),
  'alias'     => array('Nickname','%s',false),
  'birthdate' => array('Birthdate','2',false),
  'nationality'=>array('Nationality','%s',false),
  'sexe'      => array('Sexe','M ; V',false),
  'firstdate' => array('Registration','%s',false),
  'age'       => array('Age','%s',false),
  'fullname'  => array('Full name','%s',false),
  'teamid1'   => array('Club id','%s',false),
  'teamid2'   => array('National id','%s',false),
  'teamrole1' => array('Function','%s',false),
  'teamrole2' => array('Level','%s',false),
  'teamdate1' => array('Join date','2',false),
  'teamdate2' => array('Medical date','2',false),
  'teamvalue1'=> array('Percent','%s',false),
  'teamvalue2'=> array('Hits','%s',false),
  'teamflag1' => array('Restriction','Ja ; Nee',false),
  'teamflag2' => array('Rescue','Ja ; Nee',false),
  'descr'     => array('Comment','%s',false));
  $arrFrenames = array(); // used to check duplicate names

  // read submitted values
  foreach ($arrFnewnames as $strKey => $arrValues)
  {
    if ( isset($_POST["R_$strKey"]) )
    {
      $str = trim($_POST["R_$strKey"]); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
      $str = QTformattitle($str,32,true); if ( empty($str) ) $str = $strKey;
      $arrFnewnames[$strKey][0]=$str;
      $arrFrenames[]=$str;
    }
    if ( isset($_POST["F_$strKey"]) )
    {
      $str = trim($_POST["F_$strKey"]); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
      if ( empty($str) ) $str='%s';
      $arrFnewnames[$strKey][1]=$str;
    }
    if ( isset($_POST[$strKey]) )
    {
      $arrFnewnames[$strKey][2]=true;
    }
  }

  // Check duplicates (strict)
  $str = FindDuplicates($arrFrenames);
  if ( $str ) $qte_error = $L['Duplicate_fieldname'].' '.$str;
  if ( empty($qte_error) )
  {
    // Check duplicate (case insensitive)
    $str = FindDuplicates($arrFrenames,false);
    if ( $str ) $qte_warning = $L['Duplicate_fieldname_possible'].' '.$str;
  }

  // exception for email_icon
  $arrFnewnames['emails_i'][0]=$arrFnewnames['emails'][0].S.strtolower($L['Icon']);
  $arrFnewnames['emails_i'][2]=$arrFnewnames['emails'][2];

  // Save File
  if ( empty($qte_error) )
  {
    $strFilename = 'bin/config_'.$strEditLang.'.php';
    $str  = '<?php '."\r\n";
    foreach ($arrFnewnames as $strFnewname=>$arrFnewname)
    {
      $s1 = '"'.QThtmlquote($arrFnewname[0]).'"'; $s1 = str_replace(' ',S,$s1);
      $s2 = '"'.$arrFnewname[1].'"';
      if ( $arrFnewname[2] ) { $s3 = 'true';} else { $s3 = 'false'; }
      $str .= '$qte_fields["'.$strFnewname.'"] = array('.$s1.','.$s2.','.$s3.');'."\r\n";
      $qte_fields[$strFnewname] = $arrFnewname;
    }
    $str .= '?>';
    if (!is_writable($strFilename)) $qte_error="Impossible to write into the file [$strFilename].";
    if ( empty($qte_error) )
    {
    if (!$handle = fopen($strFilename, 'w')) $qte_error="Impossible to open the file [$strFilename].";
    }
    if ( empty($qte_error) )
    {
    if ( fwrite($handle, $str)===FALSE ) $qte_error="Impossible to write into the file [$strFilename].";
    fclose($handle);
    }
  }

  if ( empty($qte_error) ) $strInfo = $L['S_save'];

}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

echo '
<script type="text/javascript">
function SetField(str)
{
  if ( document.getElementById(str).checked==true )
  {
  document.getElementById("I_"+str).className="small";
  document.getElementById("C_"+str).className="";
  document.getElementById("R_"+str).style.visibility="visible";
  document.getElementById("F_"+str).style.visibility="visible";
  }
  else
  {
  document.getElementById("I_"+str).className="disabled small";
  document.getElementById("C_"+str).className="disabled";
  document.getElementById("R_"+str).style.visibility="hidden";
  document.getElementById("F_"+str).style.visibility="hidden";
  }
}
</script>
';

echo '
<form method="post" action="',$oVIP->selfurl,'">
';

echo '<table cellspacing="0" class="tab">
<colgroup span="6"><col width="30"></col><col width="90"></col><col width="140"></col><col width="130"></col><col width="130"></col><col></col></colgroup>
<tr class="tr">
<th class="th_o" style="text-align:left">&nbsp;</th>
<th class="th_o" style="text-align:left">',$L['Fields'],'</th>
<th class="th_o" style="text-align:left">',$L['Name'],'</th>
<th class="th_o" style="text-align:left">',$L['Rename'],'</th>
<th class="th_o" style="text-align:left">',$L['Format'],'</th>
<th class="th_o" style="text-align:left">&nbsp;</th>
</tr>',N;

// Personnal content
echo '<td class="td_o td_o_all" colspan="6">',$L['Fields_personal'],'</td>',N;
$arr = array('username','status');
foreach ($arr as $strFname)
{
  $strFcaption = $qte_fields[$strFname][0]; if ( empty($strFcaption) ) $strFcaption=$strFname;
  $strFformat  = $qte_fields[$strFname][1]; if ( $strFformat=='%s' ) $strFformat=' ';
  echo '<tr onmouseover="this.style.backgroundColor=\'#eeeeee\';" onmouseout="this.style.backgroundColor=\'#ffffff\';">',N;
  echo '<td class="td_o"><input type="checkbox" ',QCHE,' disabled="disabled"/><input type="hidden" id="',$strFname,'" name="',$strFname,'" value="1"/></td>',N;
  echo '<td class="td_o" style="background-color:#EEEEEE"><span id="I_',$strFname,'" class="small">'.$strFname,'</span></td>',N;
  echo '<td class="td_o"><span id="C_',$strFname,'">'.$strFcaption,'</span></td>',N;
  echo '<td class="td_o"><input type="input" id="R_',$strFname,'" name="R_',$strFname,'" value="',$strFcaption,'" size="20" maxlength="32" class="small"/></td>',N;
  echo '<td class="td_o"><input type="input" id="F_',$strFname,'" name="F_',$strFname,'" value="',$strFformat,'" size="30" maxlength="32" class="small"/></td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>',N;
}
$arr = array('title','firstname','midname','lastname','alias','address','phones','emails','www','birthdate','nationality','sexe','picture');
foreach ($arr as $strFname)
{
  $strFcaption = $qte_fields[$strFname][0]; if ( empty($strFcaption) ) $strFcaption=$strFname;
  $strFformat  = $qte_fields[$strFname][1]; if ( $strFformat=='%s' ) $strFformat=' ';
  echo '<tr onmouseover="this.style.backgroundColor=\'#eeeeee\';" onmouseout="this.style.backgroundColor=\'#ffffff\';">',N;
  echo '<td class="td_o"><input type="checkbox" id="',$strFname,'" name="',$strFname,'"',(!$qte_fields[$strFname][2] ? '' : QCHE),' onclick="SetField(this.id)"/></td>',N;
  echo '<td class="td_o" style="background-color:#EEEEEE"><span id="I_',$strFname,'" class="',( !$qte_fields[$strFname][2] ? 'disabled' : 'small'),'">'.$strFname,'</span></td>',N;
  echo '<td class="td_o"><span id="C_',$strFname,'" class="',( !$qte_fields[$strFname][2] ? 'disabled' : ''),'">'.$strFcaption,'</span></td>',N;
  echo '<td class="td_o"><input type="input" id="R_',$strFname,'" name="R_',$strFname,'" value="',$strFcaption,'" size="20" maxlength="32" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'/></td>',N;
  if ( $strFname=='birthdate' )
  {
  echo '<td class="td_o"><select id="F_',$strFname,'" name="F_',$strFname,'" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'>',QTastags($L['No_future'],null,$strFformat,null,null,null,'small'),'</select></td>',N;
  }
  else
  {
  echo '<td class="td_o"><input type="input" id="F_',$strFname,'" name="F_',$strFname,'" value="',$strFformat,'" size="30" maxlength="32" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'/></td>',N;
  }
  echo '<td class="td_o small">';
  if ( in_array($strFname,array('title','nationality','sexe')) ) echo $L['List_allowed'];
  if ( $strFname=='picture' && $qte_fields[$strFname][2] && $_SESSION[QT]['picture']=='0' ) echo '<span class="warning">',$L['Field_no_photo'],'</span>';
  echo '&nbsp;</td>',N;
  echo '</tr>',N;
}

// Computed field
echo '<td class="td_o td_o_all" colspan="6">',$L['Fields_computed'],'</td>',N;
$arr = array('fullname','age','children','firstdate');
foreach ($arr as $strFname)
{
  $strFcaption = $qte_fields[$strFname][0]; if ( empty($strFcaption) ) $strFcaption=$strFname;
  $strFformat  = $qte_fields[$strFname][1]; if ( $strFformat=='%s' ) $strFformat=' ';
  echo '<tr onmouseover="this.style.backgroundColor=\'#eeeeee\';" onmouseout="this.style.backgroundColor=\'#ffffff\';">',N;
  echo '<td class="td_o"><input type="checkbox" id="',$strFname,'" name="',$strFname,'"',(!$qte_fields[$strFname][2] ? '' : QCHE),' onclick="SetField(this.id)"/></td>',N;
  echo '<td class="td_o" style="background-color:#EEEEEE"><span id="I_',$strFname,'" class="',( !$qte_fields[$strFname][2] ? 'disabled' : 'small'),'">'.$strFname,'</span></td>',N;
  echo '<td class="td_o"><span id="C_',$strFname,'" class="',( !$qte_fields[$strFname][2] ? 'disabled' : ''),'">'.$strFcaption,'</span></td>',N;
  echo '<td class="td_o"><input type="input" id="R_',$strFname,'" name="R_',$strFname,'" value="',$strFcaption,'" size="20" maxlength="32" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'/></td>',N;
  if ( $strFname=='firstdate' )
  {
  echo '<td class="td_o"><select id="F_',$strFname,'" name="F_',$strFname,'" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'>',QTastags($L['No_future'],null,$strFformat,null,null,null,'small'),'</select></td>',N;
  }
  else
  {
  echo '<td class="td_o"><input type="input" id="F_',$strFname,'" name="F_',$strFname,'" value="',$strFformat,'" size="30" maxlength="32" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'/></td>',N;
  }
  echo '<td class="td_o small">&nbsp;</td>',N;
  echo '</tr>',N;
}

// Team content
echo '<td class="td_o td_o_all" colspan="6">',$L['Fields_team'],'</td>',N;
$arr = array('teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr');
foreach ($arr as $strFname)
{
  $strFcaption = $qte_fields[$strFname][0]; if ( empty($strFcaption) ) $strFcaption=$strFname;
  $strFformat  = $qte_fields[$strFname][1];
  if ( $strFformat=='%s' ) $strFformat=' ';
  echo '<tr onmouseover="this.style.backgroundColor=\'#eeeeee\';" onmouseout="this.style.backgroundColor=\'#ffffff\';">',N;
  echo '<td class="td_o"><input type="checkbox" id="',$strFname,'" name="',$strFname,'"',(!$qte_fields[$strFname][2] ? '' : QCHE),' onclick="SetField(this.id)"/></td>',N;
  echo '<td class="td_o" style="background-color:#EEEEEE"><span id="I_',$strFname,'" class="',( !$qte_fields[$strFname][2] ? 'disabled' : 'small'),'">'.$strFname,'</span></td>',N;
  echo '<td class="td_o"><span id="C_',$strFname,'" class="',( !$qte_fields[$strFname][2] ? 'disabled' : ''),'">'.$strFcaption,'</span></td>',N;
  echo '<td class="td_o"><input type="input" id="R_',$strFname,'" name="R_',$strFname,'" value="',$strFcaption,'" size="20" maxlength="32" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'/></td>',N;
  if ( $strFname=='teamdate1' || $strFname=='teamdate2' )
  {
  echo '<td class="td_o"><select id="F_',$strFname,'" name="F_',$strFname,'" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'>',QTastags($L['No_future'],null,$strFformat,null,null,null,'small'),'</select></td>',N;
  }
  else
  {
  echo '<td class="td_o"><input type="input" id="F_',$strFname,'" name="F_',$strFname,'" value="',$strFformat,'" size="30" maxlength="32" class="small"',( !$qte_fields[$strFname][2] ? ' style="visibility:hidden"' : ''),'/></td>',N;
  }
  echo '<td class="td_o small">',(in_array($strFname,array('teamrole1','teamrole2','teamvalue1','teamvalue2','teamflag1','teamflag2')) ? $L['List_allowed'] : ''),'&nbsp;</td>',N;
  echo '</tr>',N;
}

echo '<tr class="tr">
<th class="th_o" colspan="6" style="padding:6px; text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></th>
</tr>
';

// when several languages are allowed, admin can edit several language
if ($_SESSION[QT]['userlang']=='1' )
{
  $arrStr = array();
  foreach ($arrLangs as $strLang=>$strLangname) 
  {
    if ( $strLang==$strEditLang ) { $arrStr[] = $strLangname; } else { $arrStr[] = '<a href="'.$oVIP->selfurl.'?editlang='.$strLang.'">'.$strLangname.'</a> '; }
  }
  echo '<tr class="tr">
  <th class="th_o" colspan="6" style="padding:6px; text-align:center">',implode(' | ',$arrStr),'<input type="hidden" name="editlang" value="',$strEditLang,'"></th>
  </tr>
  ';
}

echo '
</table>
</form>
';

echo '<p class="small">',$L['H_semicolon_format'],'</p>';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>