<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080618
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$id = -1;
if ( isset($_GET['d']) ) $id = intval($_GET['d']);
if ( isset($_POST['d']) ) $id = intval($_POST['d']);
if ( $id<0 ) die('Missing argument d');

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

$oVIP->selfurl = 'qte_adm_domain.php';
$oVIP->selfname = $L['Domain_upd'];
$oVIP->exiturl = 'qte_adm_sections.php';
$oVIP->exitname = '&laquo;'.S.$L['Section_man'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{

  $str = trim($_POST['title']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = htmlspecialchars($str);
  if ( $str=='' ) $qte_error = $L['Title'].S.$L['E_invalid'];

  // save
  if ( empty($qte_error) )
  {
    $oDB->Query('UPDATE '.TABDOMAIN.' SET title="'.$str.'" WHERE id='.$id);
    // exit
    Unset($_SESSION['qteGoto']);
    Unset($_SESSION['qteDomains']);
    $oVIP->EndMessage(NULL,$L['S_update'],'admin',2);
  }
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

$oDB->Query('SELECT title FROM '.TABDOMAIN.' WHERE id='.$id);
$row = $oDB->Getrow();

// FORM

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Title'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table class="tab" width="500" cellspacing="0">
';
echo '<tr class="tr">
<th class="th_o th_o_first" style="width:100px;"><label for="title">',$L['Title'],'</label></th>
<td class="td_o"><input type="text" id="title" name="title" size="32" maxlength="64" value="',$row['title'],'" onKeyUp="handle_keypress(event,\'ok\')"/></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_first">&nbsp;</th>
<td class="td_o"><input type="submit" id="ok" name="ok" value="',$L['Save'],'"/><input type="hidden" name="d" value="',$id,'"/></td>
</tr>
';
echo '</table>
</form>
<p><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a></p>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>