<?php

// QuickTeam 1.8 build:20080614

session_start();

if ( !isset($_SESSION['qte_setup_lang']) ) $_SESSION['qte_setup_lang']='en';

include('qte_lang_'.$_SESSION['qte_setup_lang'].'.php');
include('../bin/config.php');
include('../bin/qt_lib_db.php');

$strAppl     = 'QuickTeam 1.8';
$strPrevUrl  = 'qte_setup_2.php';
$strNextUrl  = '../qte_usr_login.php?dfltname=Admin';
$strPrevLabel= $L['Back'];
$strNextLabel= $L['Finish'];

// CHECK DB VERSION (in case of update)

$oDB = new cDB($qte_dbsystem,$qte_host,$qte_database,$qte_user,$qte_pwd,$qte_port,$qte_dsn);
if ( !empty($oDB->error) ) die ('<p><font color="red">Connection with database failed.<br/>Please contact the webmaster for further information.</font></p><p>The webmaster must check that server is up and running, and that the settings in the config file are correct for the database.</p>');

$oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="version"');
$row=$oDB->Getrow();
if ( $row['setting']!='1.6' && $row['setting']!='1.7' && $row['setting']!='1.8' )
{
  $oDB->Query('UPDATE '.$qte_prefix.'qtesetting SET setting="1.6" WHERE param="version"');
  $row['setting']='1.6';
  switch($oDB->type)
  {
  case 'mysql':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u CHANGE uid userid int NOT NULL default 0');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex CHANGE uid userid int NOT NULL default 0');
    break;
  case 'mssql':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u ADD userid int NOT NULL default 0');
    $oDB->Query('UPDATE '.$qte_prefix.'qtes2u SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u DROP COLUMN uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex ADD userid int NOT NULL default 0');
    $oDB->Query('UPDATE '.$qte_prefix.'qteindex SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex DROP COLUMN uid');
    break;
  case 'pg':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u RENAME uid TO userid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex RENAME uid TO userid');
    break;
  case 'sqlite':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u ADD userid integer NOT NULL default 0');
    $oDB->Query('UPDATE '.$qte_prefix.'qtes2u SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex ADD userid integer NOT NULL default 0');
    $oDB->Query('UPDATE '.$qte_prefix.'qteindex SET userid=uid');
    break;
  case 'ibase':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u ALTER COLUMN uid TO userid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex ALTER COLUMN uid TO userid');
    break;
  case 'access':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u ADD userid int');
    $oDB->Query('UPDATE '.$qte_prefix.'qtes2u SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u DROP uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex ADD userid int');
    $oDB->Query('UPDATE '.$qte_prefix.'qteindex SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex DROP uid');
    break;
  case 'ifx':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u ADD userid integer default 0 NOT NULL');
    $oDB->Query('UPDATE '.$qte_prefix.'qtes2u SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u DROP uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex ADD userid integer default 0 NOT NULL');
    $oDB->Query('UPDATE '.$qte_prefix.'qteindex SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex DROP uid');
    break;
  case 'db2':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u ADD userid integer NOT NULL default 0');
    $oDB->Query('UPDATE '.$qte_prefix.'qtes2u SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qtes2u DROP uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex ADD userid integer NOT NULL default 0');
    $oDB->Query('UPDATE '.$qte_prefix.'qteindex SET userid=uid');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteindex DROP uid');
    break;
  default:
    die('unknown database type');
    break;
  }
  $oDB->Query('INSERT INTO '.$qte_prefix.'qtesetting VALUES ("show_stats", "M")'); // new in version 1.6
}
if ( $row['setting']=='1.6' ) 
{
  $oDB->Query('UPDATE '.$qte_prefix.'qtesetting SET setting="1.7" WHERE param="version"');
  if ( isset($qte_install) ) { define('QT','qte'.substr($qte_install,-1)); } else { define('QT','qte'); }
  if ( isset($_SESSION[QT]['version']) ) $_SESSION[QT]['version']='1.7';

  switch ($oDB->type)
  {
  case 'mysql':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY firstname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY midname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY lastname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY alias varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY x decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY y decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY z decimal(13,2)');
    break;
  case 'mssql':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN firstname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN midname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN lastname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN alias varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN x decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN y decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN z decimal(13,2)');
    break;
  case 'pg':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN firstname TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN midname TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN lastname TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN alias TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN x TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN y TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN z TYPE decimal(13,2)');
    break;
  case 'access':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN firstname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN midname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN lastname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN alias varchar(32)');
    // already float
    break;
  case 'sqlite':
    // already text
    // already real
    break;
  case 'ibase':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN firstname TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN midname TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN lastname TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN alias TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN x TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN y TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN z TYPE decimal(13,2)');
    break;
  case 'db2':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN firstname SET DATA TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN midname SET DATA TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN lastname SET DATA TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN alias SET DATA TYPE varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN x SET DATA TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN y SET DATA TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser ALTER COLUMN z SET DATA TYPE decimal(13,2)');
    break;
  case 'ifx':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY (firstname varchar(32))');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY (midname varchar(32))');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY (lastname varchar(32))');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY (alias varchar(32))');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY (x decimal(13,10))');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY (y decimal(13,10))');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY (z decimal(13,2))');
    break;
  case 'oci':
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY firstname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY midname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY lastname varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY alias varchar(32)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY x decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY y decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qte_prefix.'qteuser MODIFY z decimal(13,2)');
    break;
  }
  
}
if ( $row['setting']=='1.7' ) 
{
  $oDB->Query('UPDATE '.$qte_prefix.'qtesetting SET setting="1.8" WHERE param="version"');
  $oDB->Query('INSERT INTO '.$qte_prefix.'qtesetting VALUES ("upload", "1")');
  $oDB->Query('INSERT INTO '.$qte_prefix.'qtesetting VALUES ("uploadsize", "1000")');
  if ( isset($qte_install) ) { define('QT','qte'.substr($qte_install,-1)); } else { define('QT','qte'); }
  if ( isset($_SESSION[QT]['version']) ) $_SESSION[QT]['version']='1.8';
}

// --------
// HTML START
// --------

include('qte_setup_hd.php');

if ( isset($_SESSION['qteInstalled']) )
{
echo '<p>Database 1.8 in place.</p>';
echo '<p>',$L['S_install_exit'],'</p>';
echo '<div style="width:350px; padding:10px; border-style:solid; border-color:#FF0000; border-width:1px; background-color:#EEEEEE">',$L['End_message'],'<br/>',$L['User'],': <b>Admin</b><br/>',$L['Password'],': <b>Admin</b><br/></div><br/>';
}
else
{
echo $L['N_install'];
}

echo '<p><a href="../check_install.php">',$L['Check_install'],'</a></p>';

// --------
// HTML END
// --------

include('qte_setup_ft.php');

?>