<?php

// QuickTeam 1.8 build:20080613

// --------
// HTML start
// --------
echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="en" lang="en">

<head>
<title>QuickTeam installation checker</title>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1"/>
<link rel="stylesheet" href="admin/qte_main.css"/>
</head>

<body>

<!-- PAGE CONTROL -->
<div class="div_qte_page">
<table class="tab_qte_page" width="550" cellspacing="0" style="margin:5px">
<tr class="tr_qte_page">
<td class="td_qte_page">
<!-- PAGE CONTROL -->

<!-- HEADER BANNER -->
<div class="div_banner">
<div class="div_banner_in">
<img src="admin/qte_logo.gif" width="175" height="50" style="border-width:0" alt="QuickTeam" title="QuickTeam"/>
</div>
</div>
<!-- END HEADER BANNER -->

<!-- BODY MAIN -->
<table width="100%" cellspacing="0" style="border:1px solid #AAAAAA;">
<tr>
<td style="padding:5px 10px 5px 10px;">
<!-- BODY MAIN -->
';

// --------
// 1 CONFIG
// --------

echo '<h1>Checking your configuration</h1>';

$strError = '';

// 1 file exist

  echo 'Checking installed files...<br/>';

  if ( !file_exists('bin/config.php') )          $strError .= 'File <b>config.php</b> is not in the <b>bin</b> directory. Communication with database is impossible.<br/>';
  if ( !file_exists('bin/config_english.php') )  $strError .= 'File <b>config_english.php</b> is not in the <b>bin</b> directory.<br/>';
  if ( !file_exists('bin/qte_init.php') )        $strError .= 'File <b>qte_init.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qt_lib_db.php') )       $strError .= 'File <b>qt_lib_db.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qt_lib_txt.php') )      $strError .= 'File <b>qt_lib_txt.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qt_lib_smtp.php') )     $strError .= 'File <b>qt_lib_smtp.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qt_lib_url.php') )      $strError .= 'File <b>qt_lib_url.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qte_fn_common.php') )   $strError .= 'File <b>qte_fn_common.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qte_fn_limitsql.php') ) $strError .= 'File <b>qte_fn_limitsql.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qte_fn_sort.php') )     $strError .= 'File <b>qte_fn_sort.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qte_class_section.php') ) $strError .= 'File <b>qte_class_section.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qte_class_user.php') )  $strError .= 'File <b>qte_class_user.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';
  if ( !file_exists('bin/qte_class_vip.php') )   $strError .= 'File <b>qte_class_vip.php</b> is not in the <b>bin</b> directory. Application cannot start.<br/>';

  if ( !empty($strError) ) die('<font color="red">'.$strError.'</font>');

  echo 'Main files found.<br/><br/>';

// 2 config is correct

  echo 'Checking config.php...<br/>';

  include('bin/config.php');
  include('bin/qte_fn_common.php');

  if ( !isset($qte_dbsystem) ) $strError .= 'Variable <b>$qte_dbsystem</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qte_host) )     $strError .= 'Variable <b>$qte_host</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qte_database) ) $strError .= 'Variable <b>$qte_database</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qte_prefix) )   $strError .= 'Variable <b>$qte_prefix</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qte_user) )     $strError .= 'Variable <b>$qte_user</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qte_pwd) )      $strError .= 'Variable <b>$qte_pwd</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qte_port) )     $strError .= 'Variable <b>$qte_port</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( !isset($qte_dsn) )      $strError .= 'Variable <b>$qte_dsn</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';

  if ( !empty($strError) )  die('<font color="red">'.$strError.'</font>');

  // check db type
  if ( !in_array($qte_dbsystem,array('mysql','mssql','pg','ibase','sqlite','db2','access','ifx','oci')) ) die('Unknown db type '.$qte_dbsystem);
  // check other values
  if ( empty($qte_host) )      $strError .= 'Variable <b>$qte_host</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';
  if ( empty($qte_database) )  $strError .= 'Variable <b>$qte_database</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.<br/>';

  if ( !empty($strError) )  die('<font color="red">'.$strError.'</font>');

  echo 'Done.<br/><br/>';

// 3 test db connection

  echo 'Connecting to database...<br/>';

  include('bin/qt_lib_db.php');

  $oDB = new cDB($qte_dbsystem,$qte_host,$qte_database,$qte_user,$qte_pwd,$qte_port,$qte_dsn);
  if ( !empty($oDB->error) ) die ('<p style="color:red">Connection with database failed.<br/>Check that server is up and running.<br/>Check that the settings in the file <b>bin/config.php</b> are correct for your database.</p>');

  echo 'Done.<br/><br/>';

echo '--> Configuration tests completed successfully.';

// --------
// 2 DATABASE
// --------

$strError = '';

echo '<h1>Checking your database design</h1>';

// 1 setting table

  echo 'Checking setting table...<br/>';
   
  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="version"');
  if ( !empty($oDB->error) ) die('<br/><font color="red">Problem with table '.$qte_prefix.'qtesetting</font>');
  $row = $oDB->Getrow();
  $strVersion = $row['setting'];
  echo 'Table [',$qte_prefix,'qtesetting] exists. Version is ',$strVersion,'.<br/><br/>';
  if ( !in_array(substr($strVersion,0,3),array('1.6','1.7','1.8')) ) die('<br/><font color="red">But data in this table refers to an incompatible version (must be version 1.6 or 1.7 or 1.8).</font>');

// 2 domain table

  echo 'Checking domain table...<br/>';
  
  $oDB->Query('SELECT count(*) as countid FROM '.$qte_prefix.'qtedomain');
  if ( !empty($oDB->error) ) die('<br/><font color="red">Problem with table '.$qte_prefix.'qtedomain</font>');
  $row = $oDB->Getrow();
  $intCount = $row['countid'];
  echo 'Table [',$qte_prefix,'qtedomain] exists. ',$intCount,' domain(s) found.<br/><br/>';

// 3 team table

  echo 'Checking team table...<br/>';
  
  $oDB->Query('SELECT count(*) as countid FROM '.$qte_prefix.'qtesection');
  if ( !empty($oDB->error) ) die('<br/><font color="red">Problem with table '.$qte_prefix.'qtesection</font>');
  $row = $oDB->Getrow();
  $intCount = $row['countid'];
  echo 'Table [',$qte_prefix,'qtesection] exists. ',$intCount,' team(s) found.<br/><br/>';

// 4 user table

  echo "Checking user table...<br/>";
  
  $oDB->Query('SELECT count(*) as countid FROM '.$qte_prefix.'qteuser');
  if ( !empty($oDB->error) ) die('<br/><font color="red">Problem with table '.$qte_prefix.'qteuser</font>');
  $row = $oDB->Getrow();
  $intCount = $row['countid'];
  echo 'Table [',$qte_prefix,'qteuser] exists. ',$intCount,' user(s) found.<br/><br/>';

echo '--> Database tests completed successfully.';

// --------
// 3 LANGUAGE AND SKIN
// --------

$strError = '';

echo '<h1>Checking language and skin options</h1>';

  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="language"');
  $row = $oDB->Getrow();
  $str = $row['setting'];
  if ( empty($str) ) $strError .= 'Setting <b>language</b> is not defined in the setting table. Application can only work with english.<br/>';  
  if ( !file_exists("language/$str/qte_lang_main.inc") ) $strError .= "File <b>qte_lang_main.inc</b> is not in the <b>language/xxxx</b> directory.<br/>";
  if ( !file_exists("language/$str/qte_lang_adm.inc") )  $strError .= "File <b>qte_lang_adm.inc</b> is not in the <b>language/xxxx</b> directory.<br/>";
  if ( !file_exists("language/$str/qte_lang_reg.inc") )  $strError .= "File <b>qte_lang_reg.inc</b> is not in the <b>language/xxxx</b> directory.<br/>";
  if ( !file_exists("language/$str/qte_lang_zone.inc") ) $strError .= "File <b>qte_lang_zone.inc</b> is not in the <b>language/xxxx</b> directory.<br/>";
  if ( $str!='english' )
  {
  if ( !file_exists("language/english/qte_lang_main.inc") ) $strError .= "File <b>qte_lang_main.inc</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>";
  if ( !file_exists("language/english/qte_lang_adm.inc") )  $strError .= "File <b>qte_lang_adm.inc</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>";
  if ( !file_exists("language/english/qte_lang_reg.inc") )  $strError .= "File <b>qte_lang_reg.inc</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>";
  if ( !file_exists("language/english/qte_lang_zone.inc") ) $strError .= "File <b>qte_lang_zone.inc</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>";
  }
  
  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="skin_dir"');
  $row = $oDB->Getrow();
  $str = $row['setting'];
  if ( empty($str) ) $strError .= 'Setting <b>skin</b> is not defined in the setting table. Application will not display correctly.<br/>';  
  if ( !file_exists("skin/$str/qte_main.css") ) $strError .= "File <b>qte_main.css</b> is not in the <b>skin/xxxx</b> directory.<br/>";
  if ( !file_exists("skin/default/qte_main.css") ) $strError .= "File <b>qte_main.css</b> is not in the <b>skin/default</b> directory. Default skin is mandatory.<br/>";
  
  if ( !empty($strError) ) echo '<font color="red">',$strError,'</font>';
  $strError = '';

echo '--> Language and skin files tested.';

// --------
// 4 ADMINISTRATION TIPS
// --------

$strError = '';

echo '<h1>Administration tips</h1>';

// 1 admin email

  echo 'Email setting...<br/>';

  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="admin_email"');
  $row = $oDB->Getrow();
  $strMail = $row['setting'];
  if ( empty($strMail) )
  {
  $strError .= 'Administrator e-mail is not yet defined. It\'s mandatory to define it !<br/>';
  }
  else
  {
  if ( !ereg("^.+@.+\..+$",$strMail) )  $strError .= 'Administrator e-mail format seams incorrect. Please check it<br/>';
  }

  if ( !empty($strError) ) echo $strError;
  echo 'Done.<br/><br/>';
  $strError = '';

// 2 admin password

  echo 'Security check...<br/>';

  $oDB->Query('SELECT pwd FROM '.$qte_prefix.'qteuser WHERE id=1');
  $row = $oDB->Getrow();
  $strPwd = $row['pwd'];
  If ( $strPwd==sha1('Admin') ) $strError .= 'Administrator password is still the initial password. It\'s recommended to change it !<br/>';

  if ( !empty($strError) ) echo '<font color="red">',$strError,'</font>';
  echo 'Done.<br/><br/>';
  $strError = '';

// 3 site url

  echo 'Site url...<br/>';

  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="site_url"');
  $row = $oDB->Getrow();
  $strText = trim($row['setting']);
  if ( substr($strText,0,7)!='http://' && substr($strText,0,8)!='https://' )
  {
    $strError .= 'Site url is not yet defined (or not starting by http://). It\'s mandatory to define it !<br/>';
  }
  else
  {
    $strURL = ( empty($_SERVER['SERVER_HTTPS']) ? 'http://' : 'https://' ).$_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
    $strURL = substr($strURL,0,-18);
    if ( $strURL!=$strText ) $strError .= 'Site url seams to be different that the current url. Please check it<br/>';
  }   

  if ( !empty($strError) ) echo '<font color="red">',$strError,'</font>';
  echo 'Done.<br/><br/>';
  $strError = '';

// 4 picture folder permission

  echo 'Folder permissions...<br/>';
  
  if ( !is_dir('picture') )
  { 
    $strError .= 'Directory <b>picture</b> not found.<br/>Please create this directory and make it writeable (chmod 777) if you want to allow pictures.<br/>';
  }
  else
  {
    if ( !is_readable('picture') ) $strError .= '<font color="red">Directory <b>picture</b> is not readable.</font><br/>Change permissions (chmod 777) if you want to allow pictures.<br/>';
    if ( !is_writable('picture') ) $strError .= '<font color="red">Directory <b>picture</b> is not writable.</font><br/>Change permissions (chmod 777) if you want to allow pictures.<br/>';
  }

  if ( !empty($strError) ) echo '<font color="red">',$strError,'</font>';
  echo 'Done.<br/><br/>';
  $strError = '';

echo '--> Administration tips completed.';

// --------
// 5 END
// --------

echo '<h1>Result</h1>';
echo 'The checker did not found blocking issues in your configuration.<br/>';

  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="board_offline"');
  $row = $oDB->Getrow();
  $strOff = $row['setting'];
  if ( $strOff=='1' ) echo 'Your board seams well installed, but is currently <font color="red">off-line</font>.<br/>Log as Administrator and go to the Administration panel to turn your board on-line.<br/>';

echo '<br/><br/><a href="qte_index.php">Go to QuickTeam</a>';

// --------
// HTML END
// --------

echo '
<!-- END BODY MAIN -->
</td>
</tr>
</table>
<!-- END BODY MAIN -->

<div class="div_footer_copy">
<span class="p_footer_copy">powered by <a href="http://www.qt-cute.org" class="a_footer_copy">QT-cute</a></span>
</div>

<!-- END PAGE CONTROL -->
</td>
</tr>
</table>
</div>
<!-- END PAGE CONTROL -->

</body>

</html>';

?>
