<?php

// QuickTeam 1.8 build:20080620

if ( !isset($qte_root) ) $qte_root='';

// ---------------
// Connection config
// ---------------
require_once($qte_root.'bin/config.php');
if ( isset($qte_install) ) { define('QT','qte'.substr($qte_install,-1)); } else { define('QT','qte'); }

// ---------------
// System constants (CANNOT be changed by webmasters)
// ---------------
define('TABDOMAIN', $qte_prefix.'qtedomain');
define('TABSECTION', $qte_prefix.'qtesection');
define('TABUSER', $qte_prefix.'qteuser');
define('TABS2U', $qte_prefix.'qtes2u');
define('TABSTATUS', $qte_prefix.'qtestatus');
define('TABSETTING', $qte_prefix.'qtesetting');
define('TABCHILD', $qte_prefix.'qtechild');
define('TABINDEX', $qte_prefix.'qteindex');
define('TABDOC', $qte_prefix.'qtedoc');
define('QTEVERSION', '1.8 build:20080620');
define('QSEL', ' selected="selected"');
define('QCHE', ' checked="checked"');
define('QDIS', ' disabled="disabled"');
define('N', "\n");
define('S', '&nbsp;');

// ---------------
// Interface constants (can be changed by webmasters)
// ---------------
define('QTE_CHANGE_USERNAME', true);  // allow users to change their username (login). False = only administrators can change the username.
define('QTE_DFLT_VIEWMODE', 'N');     // default view mode: N=normal view, C=compact view
define('QTE_SHOW_VIEWMODE', true);    // allow user to change view mode
define('QTE_SHOW_PRINT',    true);    // allow user to get a print style
define('QTE_SHOW_TIME',     true);    // show time in the bottom bar
define('QTE_SHOW_MODERATOR',true);    // show moderator in the bottom bar
define('QTE_SHOW_GOTOLIST', true);    // show gotolist in the bottom bar
define('QTE_SHOW_DOMAIN',   false);   // show domain + team name in the crumbtrail bar and gotolist
define('QTE_CRUMBTRAIL', ' &middot; ');    // crumbtrail separator (dont forget spaces)
define('QTE_MENUSEPARATOR', ' &middot; '); // bottom menu separator (dont forget spaces)
define('QTE_CONVERT_AMP',   false);   // save &amp; instead of &. Use TRUE to make &#0000; symbols NOT working.
define('QTE_DIR_DOC','document/');    // directory of the document (with final /)

// ---------------
// Class and function definition
// ---------------
require_once($qte_root.'bin/qt_lib_txt.php');
require_once($qte_root.'bin/qt_lib_db.php');
require_once($qte_root.'bin/qt_lib_url.php');
require_once($qte_root.'bin/qte_class_vip.php');
require_once($qte_root.'bin/qte_class_section.php');
require_once($qte_root.'bin/qte_class_user.php');

// ---------------
// Fonction definition
// ---------------
require_once($qte_root.'bin/qte_fn_common.php');
require_once($qte_root.'bin/qte_fn_html.php');

// ---------------
//  Installation wizard (if file exists)
// ---------------
if ( !isset($qte_install) ) $qte_install='';
if ( empty($qte_install) )
{
  if ( file_exists('install/index.php') )
  {
  echo 'QuickTeam ',QTEVERSION,' <a href="install/index.php">starting installation</a>...';
  header('Refresh: 0; URL=install/index.php');
  exit;
  }
  else
  {
  die('QuickTeam cannot find the /install/ folder. Database setup will be impossible...');
  }  
}

// --------------
// Initialise Classes
// --------------
$oDB  = new cDB($qte_dbsystem,$qte_host,$qte_database,$qte_user,$qte_pwd,$qte_port,$qte_dsn);
if ( !empty($oDB->error) ) die ('<p><font color="red">Connection with database failed.<br/>Please contact the webmaster for further information.</font></p><p>The webmaster must check that server is up and running, and that the settings in the config file are correct for the database.</p>');
$oVIP = new cVIP($oDB);

// --------------
// Load team parameters
// --------------
if ( !isset($_SESSION[QT]) ) GetParam($oDB,true);

  // check major parameters
  if ( !isset($_SESSION[QT]['skin_dir']) ) $_SESSION[QT]['skin_dir']='skin/default';
  if ( !isset($_SESSION[QT]['language']) ) $_SESSION[QT]['language']='language/english';
  if ( empty($_SESSION[QT]['skin_dir']) ) $_SESSION[QT]['skin_dir']='skin/default';
  if ( empty($_SESSION[QT]['language']) ) $_SESSION[QT]['language']='language/english';
  if ( substr($_SESSION[QT]['skin_dir'],0,5)!='skin/' ) $_SESSION[QT]['skin_dir'] = 'skin/'.$_SESSION[QT]['skin_dir'];
  if ( substr($_SESSION[QT]['language'],0,9)!='language/' ) $_SESSION[QT]['language'] = 'language/'.$_SESSION[QT]['language'];

if ( !isset($_SESSION['qteDomains']) ) GetDomains($oDB);
if ( !isset($_SESSION['qteGoto']) ) $_SESSION['qteGoto'] = GetSectionTitles($oDB,$oVIP->role,null,-1,'',QTE_SHOW_DOMAIN);

// --------------
// Initialise variable
// --------------
$qte_error = ''; // Required when server uses register_global_on
$qte_warning = ''; // Required when server uses register_global_on
if ( isset($_GET['lx']) )
{
  // check that lx is valid in $arrLang (to prevent injection)
  require_once($qte_root.'bin/qte_lang.inc');
  if ( array_key_exists($_GET['lx'],$arrLang) )
  {
  $_SESSION[QT]['lx'] = $arrLang[$_GET['lx']][2];
  }
  else
  {
  $qte_error = 'Wrong iso code language';
  }
}
if ( isset($_SESSION[QT]['lx']) ) $_SESSION[QT]['language'] = 'language/'.$_SESSION[QT]['lx'];
if ( !isset($_SESSION[QT]['viewmode']) ) $_SESSION[QT]['viewmode'] = QTE_DFLT_VIEWMODE;
if ( !isset($_SESSION[QT]['javamail']) ) $_SESSION[QT]['javamail'] = '0';
if ( !isset($_SESSION[QT]['sys_members']) || !isset($_SESSION[QT]['sys_members_in']) || !isset($_SESSION[QT]['sys_members_out']) )  SysStats($oDB);
 
// --------------
// Load dictionary
// --------------
include($qte_root.$_SESSION[QT]['language'].'/qte_lang_main.inc');
$arrQTdate = array('n','date',$_SESSION[QT]['formatdate'],$_SESSION[QT]['formattime'],$L['dateSQL']);

// --------------
// Fields dictionary
// --------------
$qte_fields = array();
include($qte_root.'bin/config_'.substr($_SESSION[QT]['language'],9).'.php');
if ( count($qte_fields)<2 ) 
{
echo 'Problem with the file bin/config_'.$_SESSION[QT]['language'].'.php. The application switch to the backup file';
include($qte_root.'bin/qte_fields_bck.php');
}

// --------------
// Load status/type (use uppercase for ID)
// --------------
if ( !isset($_SESSION['qte_status_name']) )
{
   $_SESSION['qte_status_name'] = array();
   $_SESSION['qte_status_descr'] = array();
   $_SESSION['qte_status_icon'] = array();
   $oDB->Query('SELECT id,name,descr,icon,color FROM '.TABSTATUS.' ORDER BY id');
   while ( $row=$oDB->Getrow() )
   {
     $_SESSION['qte_status_name'][$row['id']] = $row['name'];
     $_SESSION['qte_status_descr'][$row['id']] = $row['descr'];
     $_SESSION['qte_status_icon'][$row['id']] = $row['icon'];
   }
}

?>