<?php

// QuickTeam 1.8 build:20080620

// --------

function LimitSQL($dbtype,$strState,$strOrder,$intStart=0,$intLength=50,$intCount=50)
{
  $strOrder = trim($strOrder); if ( substr($strOrder,-3,3)!='ASC' && substr($strOrder,-4,4)!='DESC' ) $strOrder .= ' ASC';
  switch ($dbtype)
  {
  case 'mysql':
    return "SELECT $strState ORDER BY $strOrder LIMIT $intStart,$intLength";
    break;
  case 'mssql':
    if ($intStart==0)
    {
      $query = "SELECT TOP $intLength $strState ORDER BY $strOrder";
    }
    elseif ( ($intLength+$intStart)>$intCount )
    {
      $strInvor = $strOrder;
      if ( substr($strOrder,-4,4)==' ASC' ) $strInvor=str_replace(' ASC',' DESC',$strOrder);
      if ( substr($strOrder,-4,4)=='DESC' ) $strInvor=str_replace(' DESC',' ASC',$strOrder);
      $intLast = $intCount-$intStart;
      $query = "SELECT TOP $intLast $strState ORDER BY $strInvor";
      $strOrder = str_replace('s.','',$strOrder); // to support s1,s2
      $strInvor = str_replace('s.','',$strInvor); // to support s1,s2
      $query = "SELECT * FROM ($query) As t1 ORDER BY $strOrder";
    }
    else
    {
      $strInvor = $strOrder;
      if ( substr($strOrder,-4,4)==' ASC' ) $strInvor=str_replace(' ASC',' DESC',$strOrder);
      if ( substr($strOrder,-4,4)=='DESC' ) $strInvor=str_replace(' DESC',' ASC',$strOrder);
      $invlength = $intLength+$intStart;
      $query = "SELECT TOP $invlength $strState ORDER BY $strOrder";
      $strOrder = str_replace('s.','',$strOrder); // to support t1,t2
      $strInvor = str_replace('s.','',$strInvor); // to support t1,t2
      $query = "SELECT * FROM (SELECT TOP $intLength * FROM ($query) As s1 ORDER BY $strInvor) As s2 ORDER BY $strOrder";
    }
    return $query;
    break;
  case 'pg':
    return "SELECT $strState ORDER BY $strOrder LIMIT $intLength OFFSET $intStart";
    break;
  case 'ibase':
    return "SELECT FIRST $intLength SKIP $intStart $strState ORDER BY $strOrder";
    break;
  case 'sqlite':
    return "SELECT $strState ORDER BY $strOrder LIMIT $intLength OFFSET $intStart";
    break;
  case 'ifx':
    return "SELECT SKIP $intStart FIRST $intLength $strState ORDER BY $strOrder";
    break;
  case 'db2':
    if ($intStart==0)
    {
      return "SELECT $strState ORDER BY $strOrder FETCH FIRST $intLength ROWS ONLY";
    }
    else
    {
      return "SELECT * FROM (SELECT ROW_NUMBER() OVER() AS RN, $strState) AS cols WHERE RN BETWEEN ($intStart+1) AND ($intStart+1+$intLength)";
    }
    break;
  case 'access':
    if ($intStart==0)
    {
      $query = "SELECT TOP $intLength $strState ORDER BY $strOrder";
    }
    elseif ( ($intLength+$intStart)>$intCount )
    {
      $strInvor = $strOrder;
      if ( substr($strOrder,-4,4)==' ASC' ) $strInvor=str_replace(' ASC',' DESC',$strOrder);
      if ( substr($strOrder,-4,4)=='DESC' ) $strInvor=str_replace(' DESC',' ASC',$strOrder);
      $invlength = $intLength+$intStart;
      $finaltop = $intCount-$intLength;
      $query = "SELECT TOP $invlength $strState ORDER BY $strOrder";
      $strOrder = str_replace('s.','',$strOrder); // to support s1,s2
      $strInvor = str_replace('s.','',$strInvor); // to support s1,s2
      $query = "SELECT * FROM (SELECT TOP $finaltop * FROM ($query) As s1 ORDER BY $strInvor) As s2 ORDER BY $strOrder";
    }
    else
    {
      $strInvor = $strOrder;
      if ( substr($strOrder,-4,4)==' ASC' ) $strInvor=str_replace(' ASC',' DESC',$strOrder);
      if ( substr($strOrder,-4,4)=='DESC' ) $strInvor=str_replace(' DESC',' ASC',$strOrder);
      $invlength = $intLength+$intStart;
      $query = "SELECT TOP $invlength $strState ORDER BY $strOrder";
      $strOrder = str_replace('s.','',$strOrder); // to support s1,s2
      $strInvor = str_replace('s.','',$strInvor); // to support s1,s2
      $query = "SELECT * FROM (SELECT TOP $intLength * FROM ($query) As s1 ORDER BY $strInvor) As s2 ORDER BY $strOrder";
    }
    return $query;
    break;
  case 'oci':
    if ($intStart==0)
    {
      return "SELECT * FROM (SELECT $strState ORDER BY $strOrder) WHERE ROWNUM<$intLength";
    }
    else
    {
      return "SELECT * FROM (SELECT a.*, rownum RN FROM (SELECT $strState ORDER BY $strOrder) a WHERE rownum<$intStart+1+$intLength) WHERE rn>=$intStart";
    }
    break;
  default: die('Unknown db type '.$dbtype);
  }
}

// --------

function FirstCharCase($oDB,$strField,$strCase='u')
{
  Switch ($oDB->type)
  {
  case 'mysql':
    if ( $strCase=='u' ) return "UPPER(LEFT($strField,1))";
    if ( $strCase=='l' ) return "LOWER(LEFT($strField,1))";
    if ( $strCase=='a-z' ) return "UPPER($strField) NOT REGEXP '^[A-Z]'";
    break;
  case 'mssql':
    if ( $strCase=='u' ) return "UPPER(LEFT($strField,1))";
    if ( $strCase=='l' ) return "LOWER(LEFT($strField,1))";
    if ( $strCase=='a-z' ) return "(ASCII(UPPER(LEFT($strField,1)))<65 OR ASCII(UPPER(LEFT($strField,1)))>90)";
    break;
  case 'pg':
    if ( $strCase=='u' ) return "UPPER(SUBSTRING($strField,1,1))";
    if ( $strCase=='l' ) return "LOWER(SUBSTRING($strField,1,1))";
    if ( $strCase=='a-z' ) return "UPPER($strField) !~ '^[A-Z]'";
    break;
  case 'ibase':
    if ( $strCase=='u' ) return "UPPER(SUBSTRING($strField FROM 1 FOR 1))";
    if ( $strCase=='l' ) return "LOWER(SUBSTRING($strField FROM 1 FOR 1))";
    if ( $strCase=='a-z' ) return "(UPPER(SUBSTRING($strField FROM 1 FOR 1))<'A' OR UPPER(SUBSTRING($strField FROM 1 FOR 1))>'Z')";
    break;
  case 'sqlite':
    if ( $strCase=='u' ) return "UPPER(SUBSTR($strField,1,1))";
    if ( $strCase=='l' ) return "LOWER(SUBSTR($strField,1,1))";
    if ( $strCase=='a-z' ) return "(UPPER(SUBSTR($strField,1,1))<'A' OR UPPER(SUBSTR($strField,1,1))>'Z')";
    break;
  case 'access':
    if ( $strCase=='u' ) return "UCASE(LEFT($strField,1))";
    if ( $strCase=='l' ) return "LCASE(LEFT($strField,1))";
    if ( $strCase=='a-z' ) return "(ASC(UCASE(LEFT($strField,1)))<65 OR ASC(UCASE(LEFT($strField,1)))>90)";
    break;
  case 'db2':
    if ( $strCase=='u' ) return "UPPER(SUBSTR($strField,1,1))";
    if ( $strCase=='l' ) return "LOWER(SUBSTR($strField,1,1))";
    if ( $strCase=='a-z' ) return "(ASCII(UPPER(SUBSTR($strField,1,1)))<65 OR ASCII(UPPER(SUBSTR($strField,1,1)))>90)";
    break;
  case 'ifx':
    if ( $strCase=='u' ) return "UPPER(SUBSTR($strField,1,1))";
    if ( $strCase=='l' ) return "LOWER(SUBSTR($strField,1,1))";
    if ( $strCase=='a-z' ) return "UPPER(SUBSTR($strField,1,1)) NOT MATCHES '^[A-Z]'";
    break;
  case 'oci':
    if ( $strCase=='u' ) return "UPPER(SUBSTR($strField,1,1))";
    if ( $strCase=='l' ) return "LOWER(SUBSTR($strField,1,1))";
    if ( $strCase=='a-z' ) return "(ASCII(UPPER(SUBSTR($strField,1,1)))<65 OR ASCII(UPPER(SUBSTR($strField,1,1)))>90)";
    break;
  default:
    die('Unknown db type '.$oDB->type);
  }
}

?>