<?php

// QuickTeam 1.8 build:20080620

function AsEmails($strEmails,$strId,$strSection='0',$strRender='txt',$bFirst=false,$strSkin='skin/default',$strNojava='Java protected email',$strEmpty='&nbsp;',$strSeparator='; ')
{
  if ( !is_string($strEmails) ) return $strEmpty;
  if ( empty($strEmails) || $strEmails==' ' || $strEmails=='&nbsp;' ) return $strEmpty;
  
  // strip private tags
  $strTag1 = '';
  $strTag2 = '';
  if ( substr($strEmails,0,22)=='<span class="private">' )
  {
    $strEmails = strip_tags($strEmails);
    $strTag1 = '<span class="private">';
    $strTag2 = '</span>';    
  }
  
  // format the list of Emails
  $strEmails = str_replace(array(' ; ',' ;','; ',' , ',' ,',', ',',',' '),';',$strEmails);
  $strEmails = str_replace(';;',';',$strEmails);
  if ( substr($strEmails,-1,1)==';' ) $strEmails=substr($strEmails,0,-1);
  if ( strstr($strEmails,';') )
  {
    $arrEmails = explode(';',$strEmails);
  }
  else
  {
    $arrEmails = array($strEmails);
  }
  
  // if only one email
  if ( $bFirst ) $strEmails = $arrEmails[0];
  
  // initialise values
  $strEmails = implode(';',$arrEmails);
  $strEtexts = implode($strSeparator,$arrEmails);

  // render the emails
  switch ($strRender)
  {
  case 'txt':
    Return $strTag1.'<a id="href'.$strId.'s'.$strSection.'" class="small" href="mailto:'.$strEmails.'">'.$strEtexts.'</a>'.$strTag2;
    break;
  case 'img':
    $strTitle = $arrEmails[0];
    Return $strTag1.'<a id="href'.$strId.'s'.$strSection.'" class="small" href="mailto:'.$strEmails.'"><img id="img'.$strId.'s'.$strSection.'" src="'.$strSkin.'/ico_user_e_1.gif" alt="email" title="'.$strTitle.'"/></a>'.$strTag2;
    break;
  case 'txtjava':
    $str = '<script type="text/javascript">';
    foreach ($arrEmails as $strEmail)
    {
    $arr = explode('@',$strEmail);
    $str .= 'writemailto("'.$arr[0].'","'.$arr[1].'","'.$strSeparator.'");';
    }
    $str .= '</script><noscript class="small">'.$strNojava.'</noscript>';
    Return $strTag1.$str.$strTag2;
    break;
  case 'imgjava':
    $strEmails = str_replace(array('@','.'),array('-at-','-dot-'),$strEmails);
    $strTitle = str_replace(array('@','.'),array('-at-','-dot-'),$arrEmails[0]);    
    Return $strTag1.'<a id="href'.$strId.'s'.$strSection.'" onmouseover="vmail(\''.$strId.'s'.$strSection.'\');" onmouseout="hmail(\''.$strId.'s'.$strSection.'\');" class="small" href="javamail:'.$strEmails.'"><img id="img'.$strId.'s'.$strSection.'" src="'.$strSkin.'/ico_user_e_1.gif" alt="email" title="'.$strTitle.'"/></a>'.$strTag2;
    break;
  }

  return $strEmpty;
}

// AsFormat
// Apply php sprintf
// Note: argument #2 can be an array (like those in from $qte_fields)

function AsFormat($str='',$strFormat='%s',$strEmpty='&nbsp;')
{
  if ( empty($str) ) return $strEmpty;
  if ( $strFormat=='%s' ) return $str;
  if ( is_array($strFormat) ) 
  { 
    if ( !isset($strFormat[1]) )  return $str;
    $strFormat = $strFormat[1];
    if ( empty($strFormat) ) return $str;
  }
  if ( strstr($strFormat,' ; ') ) return $str;
  return sprintf($strFormat,$str);
}

// AsImg

function AsImg($strSrc,$strAlt='',$strTitle='',$strClass='',$strStyle='',$strHref='',$strEmpty='&nbsp;')
{
  if ( !isset($strSrc) ) return $strEmpty;
  if ( !is_string($strSrc) || empty($strSrc) ) return $strEmpty;
  Return ( !empty($strHref) ? '<a href="'.$strHref.'">' : '' ).'<img src="'.$strSrc.'" alt="'.$strAlt.'" title="'.$strTitle.'"'.(!empty($strClass) ? ' class="'.$strClass.'"' : '').(!empty($strStyle) ? ' style="'.$strStyle.'"' : '').'/>'.( !empty($strHref) ? '</a>' : '' );
}

// AsImgBox
// $oCaption can be a user (cUser) or a string

function AsImgBox($strImg,$strClass,$strStyle,$oCaption)
{
  if ( !is_string($strImg) ) die('AsImgBox: Missing image');
  $strCaption = $oCaption;
  if ( isset($oCaption) ) {
  if ( strtolower(get_class($oCaption))=='cuser' ) {
    $strCaption = htmlentities(trim($oCaption->firstname),ENT_QUOTES).'<br/>'.htmlentities($oCaption->lastname,ENT_QUOTES);
    if ( substr($strCaption,0,5)=='<br/>' ) $strCaption = htmlentities($oCaption->lastname,ENT_QUOTES);
    if ( isset($_SESSION['qte_status_name'][$oCaption->status]) ) $strCaption .= '<br/>('.htmlentities($_SESSION['qte_status_name'][$oCaption->status],ENT_QUOTES).')';
  }}
  if ( strstr($strCaption,'&amp;') ) $strCaption = str_replace('&amp;','&',$strCaption);
  return '<div'.(isset($strClass) ? ' class="'.$strClass.'"' : '').(isset($strStyle) ? ' style="'.$strStyle.'"' : '').'>'.$strImg.(isset($strCaption) ? '<span class="small"><br/>'.$strCaption.'<br/></span>' : '').'</div>';
}

// AsPopupList
// explode a string using a separator and trim
// add a first empty entry
// remove duplicates

function AsPopupList($str='',$strSeparator=' ; ')
{
  $arr = explode($strSeparator,$str);
  $arrResult = array();
  $arrResult[' '] = ' ';
  foreach ($arr as $strValue)
  {
    $str = trim($strValue);
    $arrResult[$str] = $str;
  }
  return array_unique($arrResult);
}

// AsTextList

function AsTextList($strText='',$strSep=' ; ',$bReplace=true)
{
  if ( $strText=='' || $strText==' ' || $strText=='&nbsp;' ) return '&nbsp;';
  if ( $bReplace ) 
  {
  return str_replace($strSep,'<br/>',$strText);
  }
  else
  {
  return str_replace($strSep,' ',$strText);
  }
}

// CanPerform
// the $strParam can be 'upload', 'show_stats' or 'show_calendar' (defined in the settings table)

function CanPerform($strParam='',$strRole='V')
{
  if ( empty($strParam) ) die('Missing argument');
  if ( !isset($_SESSION[QT][$strParam]) ) { echo 'undefined CanPerform()'; return false; }
  if ( $_SESSION[QT][$strParam]=='A' && $strRole=='A' ) return true;
  if ( $_SESSION[QT][$strParam]=='M' && ($strRole=='A' || $strRole=='M') ) return true;
  if ( $_SESSION[QT][$strParam]=='U' && $strRole!='V' ) return true;
  if ( $_SESSION[QT][$strParam]=='V' ) return true;
  return false;
}

/**
 *
 * GetDomains
 *
 * Register and Returns an array of [key] id, [value] title (and store in a session variable)
 *
 **/
function GetDomains($oDB)
{
  $_SESSION['qteDomains'] = array();
  $oDB->Query( 'SELECT id,title FROM '.TABDOMAIN.' ORDER BY vorder' );
  while ( $row = $oDB->Getrow() )
  {
    $_SESSION['qteDomains'][$row['id']] = $row['title'];
  }
  return $_SESSION['qteDomains'];
}

/**
 *
 * GetSectionTitles
 *
 * Returns an array of [key] team.id, [value] team.title
 *
 **/
 function GetSectionTitles($oDB,$strRole='V',$strFilterdom='-',$intReject=-1,$strExtra='',$bAddDomain=false)
 {
   if ( is_numeric($strFilterdom) ) { $strWhere = 's.domainid='.$strFilterdom; } else { $strWhere = 's.domainid>=0'; }
   if ( $strRole=='V' || $strRole=='U' ) $strWhere .= ' AND s.type<>"1"';
   if ( !empty($strExtra) ) $strWhere .= ' AND '.$strExtra;
 
   $arrSections = array();
   if ( $bAddDomain )
   {
     $oDB->Query( 'SELECT s.id,s.title,d.title as domtitle FROM '.TABSECTION.' s INNER JOIN '.TABDOMAIN.' d ON s.domainid=d.id WHERE '.$strWhere.' ORDER BY d.vorder,v.vorder' );
     while ( $row = $oDB->Getrow() )
     {
       $arrSections[intval($row['id'])] = stripslashes($row['domtitle']).': '.stripslashes($row['title']);
     }
   }
   else
   {
     $oDB->Query( 'SELECT s.id,s.title FROM '.TABSECTION.' s WHERE '.$strWhere.' ORDER BY s.vorder' );
     while ( $row = $oDB->Getrow() )
     {
       $arrSections[intval($row['id'])] = stripslashes($row['title']);
     }
   }
 
   // reject
   if ( $intReject>=0 ) unset($arrSections[$intReject]);
 
   return $arrSections;
 }

/**
 *
 * GetSections
 *
 * Returns an array of [key] team.id, array of [values] team.*
 *
 **/
function GetSections($oDB,$strRole='V',$filterdomain='-',$intReject=-1,$strExtra='')
{
  if ( is_numeric($filterdomain) ) { $strWhere = 's.domainid='.$filterdomain; } else { $strWhere = 's.domainid>=0'; }
  if ( $strRole=='V' || $strRole=='U' ) $strWhere .= ' AND s.type<>"1"';
  if ( !empty($strExtra) ) $strWhere .= ' AND '.$strExtra;

  $arrTeams = array();
  $oDB->Query( 'SELECT s.* FROM '.TABSECTION.' s WHERE '.$strWhere.' ORDER BY s.vorder' );
  while ( $arr = $oDB->Getrow() )
  {
    $arrTeams[$arr['id']] = $arr;
  }

  // reject
  if ( $intReject>=0 ) unset($arrTeams[$intReject]);

  return $arrTeams;
}

// GetParam

function GetParam($oDB,$bRegister=false,$strWhere='')
{
  $arrParam = array();
  $oDB->Query('SELECT param,setting FROM '.TABSETTING.(empty($strWhere) ? '' : ' WHERE '.$strWhere));  
  while ($row = $oDB->Getrow())
  {
  $arrParam[$row['param']]=$row['setting'];
  if ( $bRegister ) $_SESSION[QT][$row['param']]=$row['setting'];
  }
  Return $arrParam;
}

/**
 *
 * GetUsers
 *
 * Return an array of (maximum 200) users id/lastname+firstname
 * number = returns 1 user [id][name]
 * 'all' = returns all users (default)
 * 'A'   = returns administrators
 * 'M'   = returns staff members (+Admin)
 * 'M-'  = returns staff members (-Admin)
 * 'U'   = returns users (-Admins -moderators)
 * $bInvert = use true to return firstname+lastname
 **/
function GetUsers($oDB,$strRole='all',$intSection=-1,$bInvert=false)
{
   $intX = 200;
   if ( $intSection<0 )
   {
   $strQ = 'SELECT u.id,u.username,u.firstname,u.lastname FROM '.TABUSER.' u ';
   if ( $strRole=='all' ) $strQ .= 'WHERE u.id>0';
   if ( $strRole=='A' )   $strQ .= 'WHERE u.role="A"';
   if ( $strRole=='U' )   $strQ .= 'WHERE u.role="U"';
   if ( $strRole=='M' )   $strQ .= 'WHERE u.role="A" OR u.role="M"';
   if ( $strRole=='M-' )  $strQ .= 'WHERE u.role="M"';
   if ( $strRole=='lost' ) $strQ .= 'LEFT JOIN '.TABS2U.' l ON l.userid=u.id WHERE u.id>0 AND l.userid IS NULL';
   }
   else
   {
   $strQ = 'SELECT u.id,u.username,u.firstname,u.lastname FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id ';
   if ( $strRole=='all' ) $strQ .= 'WHERE l.sid='.$intSection;
   if ( $strRole=='A' )   $strQ .= 'WHERE l.sid='.$intSection.' AND u.role="A"';
   if ( $strRole=='U' )   $strQ .= 'WHERE l.sid='.$intSection.' AND u.role="U"';
   if ( $strRole=='M' )   $strQ .= 'WHERE l.sid='.$intSection.' AND (u.role="M" OR u.role="A")';
   if ( $strRole=='M-' )  $strQ .= 'WHERE l.sid='.$intSection.' AND u.role="M"';
   }
   $oDB->Query( $strQ.' ORDER BY u.lastname, u.firstname' );

   $arrUsers = array();
   $i=1;
   while ($row=$oDB->Getrow())
   {
      if ( $bInvert )
      {
      $arrUsers[$row['id']] = substr($row['firstname'].' '.$row['lastname'],0,32);
      }
      else
      {
      $arrUsers[$row['id']] = substr($row['lastname'].' '.$row['firstname'],0,32);
      }
      if ( $arrUsers[$row['id']]==' ' ) $arrUsers[$row['id']]=$row['username'];
      $i++;
      if ( $i>$intX ) break;
   }
   return $arrUsers;
}

// --------
function GetFields($str='all')
{
  switch ($str)
  {
  case 'all':       return array('id','username','status_i','role','status','picture','address','phones','emails','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe','fullname','age','children','teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr'); break;
  case 'personnal': return array('id','username','status_i','role','status','picture','address','phones','emails','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe','fullname','age','children'); break;
  case 'useredit':  return array('status','address','phones','emails','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe'); break;
  case 'team':      return array('teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr'); break;
  case 'computed':  return array('fullname','age','children'); break;
  case 'index_p':   return array('username','address','phones','emails','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe','age'); break;
  case 'index_t':   return array('teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr'); break;
  default:          die("GetFields: Wrong argument $str");
  }
}

// --------
// From a list of fields returns the 'usable' ones
// @$arrUsables the $qte_fields
// @$arrFields a list of fields.
//    If empty array, returns usable fields from the full list
//    It can be a string (with semi-colon as separator)
// @$strInfo the desired information: id, nid, name, format (nid is numerical indexed list)
// @$strSep when a separator string is provided, returns a imploded string instead of an array

function GetUsableFields($arrUsables,$arrFields=array(),$strInfo='id',$strSep=FALSE)
{
  if ( !is_array($arrUsables) ) die('GetUsableFields: Arg #1 must be an array');
  if ( is_string($arrFields) ) $arrFields = explode(';',$arrFields);
  if ( !is_array($arrFields) ) die('GetUsableFields: Arg #2 must be an array');  
  if ( !is_string($strInfo) ) die('GetUsableFields: Arg #3 must be a string');
  if ( count($arrFields)==0 ) $arrFields = GetFields(); 
  
  $arr = array();
  foreach ($arrFields as $strField)
  {
    if ( array_key_exists($strField,$arrUsables) ) {
    if ( $arrUsables[$strField][2] ) {
      switch ($strInfo)
      {
      case 'name':  $arr[$strField]=$arrUsables[$strField][0]; break;
      case 'format':$arr[$strField]=$arrUsables[$strField][1]; break;
      case 'id':    $arr[$strField]=$strField; break;
      case 'nid':   $arr[]=$strField; break;
      default:      die('Wrong argument: GetUsableFields returns only id,name or format');
      }
    }}
  }
  if ( $strSep ) return implode($strSep,$arr);
  return $arr;
}

// LangS
// Returns the plural.
// - Returns the orignial word if $intVal<2, or if plural word is not existing.
// - If the last argument is true, returns the number + space + the word 
// - The variable $strVar can be composed of 2 strings (comma separated)
// ex: LangS['userrole,A',25] returns $L['Userroles']['A']

function LangS($strVar,$intVar,$L,$bInclude=true)
{
  if ( !strstr($strVar,',') )
  {
    if ( $intVar>1 && isset($L[$strVar.'s']) )
    {
      Return ($bInclude ? $intVar.' ' : '').$L[$strVar.'s']; 
    }
    else
    {
      Return ($bInclude ? $intVar.' ' : '').$L[$strVar];
    }
  }
  else
  {
    $lstVar = explode(',',$strVar);
    if ( $intVar>1 && isset($L[$lstVar[0].'s'][$lstVar[1]]) )
    {
      Return ($bInclude ? $intVar.' ' : '').$L[$lstVar[0].'s'][$lstVar[1]]; 
    }
    else
    {
      Return ($bInclude ? $intVar.' ' : '').$L[$lstVar[0]][$lstVar[1]];
    }
  }
}

// MakePager
// Return FALSE if pager not needed

function MakePager($uri, $count, $intPagesize=50, $currentpage=1, $L)
{
   if ( $intPagesize<1 ) die('Invalid pagesize: ['.$intPagesize.']');
   $arrUri = parse_url($uri);
   $uri = $arrUri['path'];
   $arg = $arrUri['query'];
   $arg = str_replace('&amp;','&',$arg);
   $arrArg = explode('&',$arg);
   $arrNew = array();
   foreach ($arrArg as $strValue)
   {
      if ( substr($strValue,0,4)=='page' ) continue;
      $arrNew[]=$strValue;
   }
   $arg = implode('&amp;',$arrNew);
   
   $strPager = false;  
   if ( $count>($intPagesize*5) )
   {
      // firstpage
      if ( $currentpage==1 )
      {
        $firstpage = ' &laquo;';
      }
      else
      {
        $firstpage = ' <a href="'.$uri.'?'.$arg.'&amp;page=1" title="'.$L['First'].'">&laquo;</a>';
      }
      // lastpage
      $il = ceil($count/$intPagesize);
      if ( $currentpage==$il )
      {
        $lastpage = ' &raquo;';
      }
      else
      {
        $lastpage = ' <a href="'.$uri.'?'.$arg.'&amp;page='.$il.'" title="'.$L['Last'].': '.$il.'">&raquo;</a>';
      }
      // 3 pages
      if ( $currentpage==1 )
      {
         $thesepages = ' <b>'.$currentpage.'</b> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+1).'" title="'.$L['Next'].'">'.($currentpage+1).'</a> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+2).'" title="'.$L['Next'].'">'.($currentpage+2).'</a>';
      }
      elseif ( $currentpage==$il )
      {
         $thesepages = ' <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-2).'" title="'.$L['Previous'].'">'.($currentpage-2).'</a> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-1).'" title="'.$L['Previous'].'">'.($currentpage-1).'</a> <b>'.$currentpage.'</b> ';
      }
      else
      {
         $thesepages = ' <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-1).'" title="'.$L['Previous'].'">'.($currentpage-1).'</a> <b>$currentpage</b> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+1).'" title="'.$L['Next'].'">'.($currentpage+1).'</a>';
      }
      // finish
      $strPager .= $firstpage.$thesepages.$lastpage;
   }
   elseif ($count>$intPagesize)
   {
      for ($i=0; $i<$count; $i+=$intPagesize)
      {
        $page = $i/$intPagesize+1;
        if ( $currentpage==$page )
        {
          $strPager .= ' <b>'.$page.'</b>';
        }
        else
        {
          $strPager .= ' <a href="'.$uri.'?'.$arg.'&amp;page='.$page.'">'.$page.'</a>';
        }
      }
   }
   return $strPager;
}

// SQLdate

function SQLdate($oDB,$str='')
{
  if ( $str=='' ) $str = date('Y-m-d H:i:s');
  Switch ($oDB->type)
  {
  Case 'pg':   Return "to_timestamp('$str','YYYY-MM-DD HH24:MI:SS')"; Break;
  Case 'mssql':Return 'CONVERT(datetime,"'.$str.'",120)'; Break;
  Case 'oci':  Return 'TO_CHAR(TO_DATE("'.$str.'","YYYY-MM-DD HH24:MI:SS"),"YYYYMMDDHH24MISS")'; Break;
  Default: Return '"'.$str.'"';
  }
}

// SysStats

function SysStats($oDB)
{
  // all
  $oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE id>0');
  $row = $oDB->Getrow();
  $_SESSION[QT]['sys_members'] = $row['countid'];

  // in section (but not in garbage collector)
  $oDB->Query('SELECT count(*) as countid  FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid>0');
  $row = $oDB->Getrow();
  $_SESSION[QT]['sys_members_in'] = $row['countid'];

  // out section (users in garbage collector)
  $oDB->Query('SELECT count(*) as countid  FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid=0');
  $row = $oDB->Getrow();
  $_SESSION[QT]['sys_members_out'] = $row['countid'];
}

/**
 *
 * TableHeader
 *
 * @arrField array('sort','text','class','style')
 * @intCount number of row (if <=2, columns are not sortable)
 * @strOrder initial order field
 * @strDirec initial order direction
 * @strUrl   sorting url (without order nor dir arguments)
 * 
 **/
function TableHeader($arrFields,$intCount=0,$strUrl='',$strOrder='username',$strDir='')
{
  $img['ASC'] = ' <img class="ico_sort" src="'.$_SESSION[QT]['skin_dir'].'/sort_asc.gif" alt="+"/>';
  $img['DESC']= ' <img class="ico_sort" src="'.$_SESSION[QT]['skin_dir'].'/sort_desc.gif" alt="-"/>';
  
  Foreach ($arrFields as $strField => $arrField)
  {
    // change the text to hyperlink+image when necessary
    if ( $arrField['sort'] && $intCount>2 )
    {
      if ( $strField==$strOrder )
      {
      $str = '<a href="'.$strUrl.'&amp;order='.$arrField['sort'].'&amp;dir='.QTinvert($strDir).'" class="a_cnt_head">'.$arrField['text'].'</a>'.$img[$strDir];
      }
      else
      {
      $str = '<a href="'.$strUrl.'&amp;order='.$arrField['sort'].'&amp;dir='.$arrField['dir'].'" class="a_cnt_head">'.$arrField['text'].'</a>';
      }
    }
    else
    {
    $str = $arrField['text'];
    }
    // show the column text
    echo '<th',(empty($arrField['class']) ? '' : ' class="'.$arrField['class'].'"'),(empty($arrField['style']) ? '' : ' style="'.$arrField['style'].'"'),'>',$str,'</th>',N;
  }
}

// Translate

function Translate($strPath,$strFile)
{
  if ( file_exists($strPath.'/'.$strFile) ) Return $strPath.'/'.$strFile;
  Return 'language/english/'.$strFile;
}

// UseModule

function UseModule($strName=null,$onerror=null)
{
  if ( !is_string($strName) ) { if ( isset($onerror) ) return $onerror; die('UseModule: arg #1 must be an string'); }
  if ( isset($_SESSION[QT]['module_'.$strName]) ) return TRUE;
  return FALSE;  
}

?>