<?php

// QuickTeam 1.8 build:20080620

// CONSTRAINT:
// users can be outside section (i.e. new user not yet in section)
// users without section are stored in the garbage collector (section 0)

/*
 * CLASS cSection
 *
 * constructor cSection: argument can be null, a section id, a section arr, a cSection object
 * function MakeFromArray: used by the constructor
 * function MakeNew
 * function MoveContent (=DeleteContent)
 * function UpdateStats
 *
 */

class cSection
{

// --------

var $id = -1;
var $domainid = -1;
var $title = 'untitled';
var $descr;
var $type = 0;  // '0'=visible, '1'=hidden, '2'=hidden by user
var $status = 0;  // '0'=actif, '1'=closed
var $picture;
var $vorder = 255;
var $forder;
var $modid = 1;
var $modname = 'Administrator';
var $members = 0;
var $allowpic = 'Y';    // allow image [Y/N] (only N means no; unset means Y)
// not used (version 14)
var $template='T';      // 'T'=table, 'P'=preview, 'C'=compactlist;
var $ontop='0';   // status members to be on top (0=none)

// --------

function cSection($oDB=null,$aSection=null)
{
  if ( isset($aSection) )
  {
    if ( is_int($aSection) )
    {
      if ( $aSection<0 ) die('Wrong id in cSection');
      $oDB->Query('SELECT * FROM '.TABSECTION.' WHERE id='.$aSection);
      $row = $oDB->Getrow();
      if ( $row===False ) die('No section '.$aSection);
      $this->MakeFromArray($row);
    }
    elseif ( is_array($aSection) )
    {
      $this->MakeFromArray($aSection);
    }
    elseif ( strtolower(get_class($aSection))=='csection' )
    {
      $this->id       = $aSection->id;
      $this->domainid = $aSection->domainid;
      $this->title    = $aSection->title;
      $this->descr    = $aSection->descr;
      $this->type     = $aSection->type;
      $this->status   = $aSection->status;
      $this->picture  = $aSection->picture;
      $this->vorder   = $aSection->vorder;
      $this->forder   = $aSection->forder;
      $this->modid    = $aSection->modid;
      $this->modname  = $aSection->modname;
      $this->members  = $aSection->members;
      $this->allowpic = $aSection->allowpic;
      $this->template = $aSection->template;
      $this->ontop    = $aSection->ontop;
    }
    else
    {
      die('Invalid constructor parametre #1 for the class cSection');
    }
  }
}

// --------

function MakeFromArray($arr)
{
  if ( !is_array($arr) ) die('Invalid argument for cSection->MakeFromArray');
  foreach ($arr as $strKey => $oValue)
  {
    switch ($strKey)
    {
    case 'id':       $this->id       = intval($oValue); break;
    case 'domainid': $this->domainid = intval($oValue); break;
    case 'title':    $this->title    = $oValue; break;
    case 'descr':    $this->descr    = $oValue; break;
    case 'type':     $this->type     = intval($oValue); break;
    case 'status':   $this->status   = intval($oValue); break;
    case 'picture':  $this->picture  = $oValue; break;
    case 'vorder':   $this->vorder   = intval($oValue); break;
    case 'forder':   $this->forder   = $oValue; if ( empty($this->forder) ) $this->forder = 'status_i;fullname;phones;emails;picture'; break;
    case 'modid':    $this->modid    = intval($oValue); break;
    case 'modname':  $this->modname  = $oValue; break;
    case 'members':  $this->members  = intval($oValue); break;
    case 'allowpic':  if ( $oValue=='N' ) $this->allowpic='N'; break;
    // not used (version 14)
    case 'template': $this->template = $oValue; break;
    case 'ontop':    $this->ontop    = $oValue; break;
    }
  }
}

// --------

function MakeNew($oDB)
{
  $this->id = QTnextid($oDB,TABSECTION);
  if ( $this->id<0 ) die('Wrong id in section->MakeNew');

  $oDB->Query(
  'INSERT INTO '.TABSECTION.'
  (id,domainid,title,descr,type,status,vorder,forder,modid,modname,allowpic,template,ontop,members)
  VALUES (
  '.(isset($this->id)       ?     $this->id          : 'null' ).',
  '.(isset($this->domainid) ?     $this->domainid    : 'null' ).',
  '.(isset($this->title)    ? '"'.$this->title.'"'   : 'null' ).',
  '.(isset($this->descr)    ? '"'.$this->descr.'"'   : 'null' ).',
  '.(isset($this->type)     ? '"'.$this->type.'"'    : 'null' ).',
  '.(isset($this->status)   ? '"'.$this->status.'"'  : 'null' ).',
  '.(isset($this->vorder)   ?     $this->vorder      : 'null' ).',
  '.(isset($this->forder)   ? '"'.$this->forder.'"'  : 'null' ).',
  '.(isset($this->modid)    ?     $this->modid       : 'null' ).',
  '.(isset($this->modname)  ? '"'.$this->modname.'"' : 'null' ).',
  '.(isset($this->allowpic) ? '"'.$this->allowpic.'"': 'null' ).',
  '.(isset($this->template) ? '"'.$this->template.'"': 'null' ).',
  '.(isset($this->ontop)    ? '"'.$this->ontop.'"'   : 'null' ).',0)'
  );   
}

// --------
// instanciate is allowed

function MoveContent($oDB,$intSrc=null,$intDest=0,$bStats=true)
{
  if ( !isset($intSrc) ) $intSrc = $this->id;
  if ( $intSrc<0 || $intDest<0 ) die('Wrong idSrc in section->MoveContent');
  if ( $intSrc == $intDest )     die('Wrong idDest in section->MoveContent');

  // Move members
  $oDB->Query('UPDATE '.TABS2U." SET sid=$intDest WHERE sid=$intSrc");

  // Update stats
  $this->UpdateStats($oDB,$intSrc);
  $this->UpdateStats($oDB,$intDest);
}

// --------
// instanciate is allowed
// use id "all" to update all

function UpdateStats($oDB,$id=null)
{
  if ( !isset($id) ) $id = $this->id;
  if ( $id=='all' )
  {
    foreach ($_SESSION['qteGoto'] as $s => $str)
    {
    $oDB->Query('SELECT count(*) as countid FROM '.TABS2U.' WHERE sid='.$s);
    $row = $oDB->Getrow();
    $oDB->Query( 'UPDATE '.TABSECTION.' SET members='.$row['countid'].' WHERE id='.$s );
    }
  }
  else
  {
    if ( $id<0 ) die('Wrong id in section->UpdateStats');
    $oDB->Query('SELECT count(*) as countid FROM '.TABS2U.' WHERE sid='.$id);
    $row = $oDB->Getrow();
    $oDB->Query( 'UPDATE '.TABSECTION.' SET members='.$row['countid'].' WHERE id='.$id );  
  }
}

// --------

function ShowInfo($strClassMain,$strClassName,$strClassDescr,$strClassPicture,$strAlign='right',$strPictureUrl=null,$qte_root='')
{
  echo '<!-- Section description -->',N;
  echo '<table class="',$strClassMain,'">',N;
  echo '<tr class="tr_hidden">';
  if ( $strAlign=='left' )
  {
    if ( !is_null($strClassPicture) && !empty($this->picture) )
    {
      echo '<td class="td_hidden" style="width:120px">';
      echo AsImg($qte_root.$this->picture,'logo',$this->title,$strClassPicture,null,$strPictureUrl);
      echo '</td>';
    }
    echo '<td class="td_hidden">';
    if ( !is_null($strClassName) ) echo '<p class="',$strClassName,'">',$this->title,'</p>';
    if ( !is_null($strClassDescr) ) echo '<p class="',$strClassDescr,'">',$this->descr,'</p>';
    echo '</td>';
  }
  else
  {
    echo '<td class="td_hidden">';
    if ( !is_null($strClassName) ) echo '<p class="',$strClassName,'">',$this->title,'</p>';
    if ( !is_null($strClassDescr) ) echo '<p class="',$strClassDescr,'">',$this->descr,'</p>';
    echo '</td>';
    if ( !is_null($strClassPicture) && !empty($this->picture) )
    {
      echo '<td class="td_hidden" style="width:120px">';
      echo AsImg($qte_root.$this->picture,'logo',$this->title,$strClassPicture,null,$strPictureUrl);
      echo '</td>';
    }
  }
  echo '</tr>',N;
  echo '</table>',N;
  echo '<!-- end section description -->',N;
}

// --------

}

?>