<?php

/*
  Jaxolotl Design
  
  PHP Text Reducer 3.0
  PHP programming: Javier Valderrama
  
  Developed for Jaxolotl Design - www.jaxolotl-design.com
  
  This Simple function allows you to reduce a long text to an smaller one,
  for example when you use articles text previews.
  The cool feature is that it doesn't cuts the words, if you use " " as boundary, but it does if you want to by using the proper character
  The Strip_tags() is used to prevent tables or any other tag to be chopped unproperly.
  
  Enjoy :)
  
  Please don't remove this lines, I think it's a very low price and a way to say TNX if it's usefull for you ;)
*/

//SWITCH IT TO error_reporting(0) when publishing
  error_reporting(E_ALL);
  
#############################################
###       TEXT REDUCE
#
  //  $string             -> (string)   This is the input string to be reduced
  //  $limit              -> (int)      An integer limit of max characters to output, default is 100
  //  $replacement        -> (string)   The string to add at the end of a replaced text
  //  $boundary           -> (string)   The boundary to find to chop the text after the limit
  //                                    you may use a character if needed, for exp.the letter "a" the script will finde the next "a" after limit to chop the text
  //  $force_replacement  -> (bool)     If text is shorter than limit set this to true if you need to add the replacement anyway after the text

  function extract_text($string ="", $limit = 1000, $replacement ="", $boundary = " ", $force_replacement = false){
    $string = (!trim($string) ? " " : $string);
    $string = strip_tags($string);
    $string_length = strlen($string);
    $limit = (int)$limit;
    $force_replacement = (bool)$force_replacement;
    
    //Search the end of a word after [, int offset] and set the result as limit
    if(($limit > $string_length)&&($force_replacement)){
      $limit = @strpos($string, $boundary,$string_length - 1);
      if(!$limit){
        $limit = $string_length;
      }
    }
    else{
      $limit = @strpos($string, $boundary ,$limit);
    }
  
    if($limit){
      //Use $limit to replace width ...Text
      return substr_replace($string, $replacement,$limit);
    }
    else{
      return $string;
    }
  }
  
#############################################
###       EXAMPLES
#
  
 $testo ="Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque vel nisi ac justo suscipit fringilla. Lorem ipsum dolor sit amet, consectetuer adipiscing elit."; 
 
 // Exaple 1
 // text is smaller than limit, but no need to add the replacement ... to be added
 echo "<br><br><u>Ex 1 text is <strong>smaller than limit</strong>, but NO NEED the replacement to be added</u><br>"
 .extract_text($testo, 800, $replacement ="...", $boundary = " ", $force_replacement = false);
 
 // Exaple 2
 // text is smaller than limit, but NEED to add the replacement to be added
 echo "<br><br><u>Ex 2 text is <strong>smaller than limit</strong>, but NEED the replacement to be added</u><br>"
 .  extract_text($testo, 800, $replacement ="... continue", $boundary = " ", $force_replacement = true);
 
 // Exaple 3
 // Using default parameters
 echo "<br><br><u>Ex 3 Using default parameters</u><br>"
 .  extract_text($testo);
 
 // Exaple 4
 // Adding link to a text smaller than limit, but NEED to add the replacement to be added
 echo "<br><br><u>Ex 4 Adding link to a text <strong>smaller than limit</strong>, but NEED the replacement to be added</u><br>"
 .  extract_text($testo, 800, $replacement ="... <a href=\"#\"><em>read more</em></a>", $boundary = " ", $force_replacement = true);
 
 // Exaple 5
 // Adding link to a text smaller than limit, but no need to add the replacement ... to be added
 // in this example the link wont be added
 echo "<br><br><u>Ex 5 Adding link to a text <strong>smaller than limit</strong>, but NO NEED the replacement to be added</u><br>"
 .  extract_text($testo, 800, $replacement ="... <a href=\"#\"><em>read more</em></a>", $boundary = " ", $force_replacement = false);
 
 // Exaple 6
 // Adding link to a text bigger than limit
 // in this example the link will be added anyway even if force_replacement is false
 echo "<br><br><u>Ex 6 Adding link to a text <strong>bigger than limit</strong></u><br>"
 .  extract_text($testo, 20, $replacement ="... <a href=\"#\"><em>read more</em></a>", $boundary = " ", $force_replacement = false);

 // Exaple 7
 // Using an empty input
 echo "<br><br><u>Ex 7 Using an <strong>empty</strong> input</u><br>"
 .  extract_text("", 20, $replacement ="Hello World", $boundary = " ", $force_replacement = true);

?>