<?php
/*
 * code2html - Convert your code 2 html with syntax highlighting
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Send your comments and bug reports to me@nashruddin.com
 *
 * @author 	  Nashruddin Amin <me@nashruddin.com>
 * @copyright Nashruddin Amin 2008
 * @license	  GNU General Public License 3.0
 * @version   1.1
 * @website   http://www.nashruddin.com
 */

session_start();

include_once "code2html.inc.php";

$_SESSION['html'] = "";

if ($_SERVER['REQUEST_METHOD']=="POST") {
	$ori_code = stripslashes($_POST['ori_code']);
	
	if (is_uploaded_file($_FILES['source_file']['tmp_name'])) {
		$ori_code = file_get_contents($_FILES['source_file']['tmp_name']);
	}	
	$html = code2html($ori_code);
	$_SESSION['html'] = $html;
}
?>
<html>
<head>
<title>Code2HTML with syntax highlighting</title>
<style type="text/css">
 body, form, div, p, pre { padding: 0; margin: 0; }
 body { padding: 1em; margin-bottom: 2em; font-family: verdana;	font-size: 0.75em; }
 h1 { font-size: 1.5em; }
 p { padding-top: 1em; padding-bottom: 0.5em; }
 textarea { width: 100%; border: #aaa 1px solid; }
 #title { text-align: center; }
 #form, #result { width: 750px; margin-left: auto; margin-right: auto; }
</style>
</head>
<body>

<div id="title">
 <h1>Code2HTML with syntax highlighting</h1>
</div>

<div id="form">
 <form id="fcode" action="<?=basename(__FILE__)?>" method="post" enctype="multipart/form-data">
  <p><strong>Enter your code:</strong></p>
  <textarea name="ori_code" rows="15" cols="50"><?=htmlentities($ori_code)?></textarea><br />
  <p><strong>Or upload from file:</strong></p>
  <input type="file" name="source_file" />
  <input type="submit" value="Convert to HTML" />
 </form>
</div>

<div id="result">
 <p><strong>Result:</strong><br />
    [<a href="javascript:blockResult()">Select all</a>] 
	[<a href="javascript:preview()">Preview code</a>]</p>
 <textarea id="txtResult" name="txtResult" rows="15" cols="50"><?=htmlentities($html)?></textarea>

  <?php
  if (!empty($html)) {
  ?>
  <div id="note">
   <p><strong>Note:</strong> Copy and paste the result above inside the &lt;pre&gt;&lt;/pre&gt; tag of your page.
      Then add CSS styles similar to these to your stylesheet:</p>
   <pre style="border: 0;">
pre {
  font-family: monospace;
  font-size: 1.1em;
}
pre .d { color: #000000; } /* default */
pre .f { color: #0000bb; } /* functions */
pre .k { color: #007700; } /* keywords */
pre .c { color: #ff8000; } /* comments */
pre .s { color: #dd0000; } /* strings */
  </pre>
 </div>
 <?php
 }
 ?>
</div>

<script language="javascript" type="text/javascript">
function blockResult()
{
	document.getElementById("txtResult").focus();
	document.getElementById("txtResult").select();
}
function preview()
{
	var preview = window.open("preview.php", "Code preview", "toolbar=no,width=420,height=300,resizable=yes,scrollbars=yes");
}
</script>
</body>
</html>
