<?php
/*
 * code2html - Convert your code 2 html with syntax highlighting
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Send your comments and bug reports to me@nashruddin.com
 *
 * @author 	  Nashruddin Amin <me@nashruddin.com>
 * @copyright Nashruddin Amin 2008
 * @license	  GNU General Public License 3.0
 * @version   1.1
 * @website   http://www.nashruddin.com 
 */
function code2html($code)
{
	$is_php = true;
	
    /* add <?php and ?> to the code */
	if (strpos($code, '<?') !== 0) {
		$code = "<?php" . $code . "?>";
		$is_php = false;
	}
	
	$code = highlight_string($code, true);

    // Remove the first "<code>" tag from "$code" (if any)
    if(substr($code, 0, 6) == '<code>') {
       $code = substr($code, 6, (strlen($code) - 13));
    }
	
    // Replacement-map to replace deprecated "<font>" tag with "<span>"
    $xhtml_convmap = array(
		'<font color="#000000"'   		=> '<span class="d"',
		'<font color="#0000BB"'   		=> '<span class="f"',
		'<font color="#007700"'   		=> '<span class="k"',
		'<font color="#FF8000"'   		=> '<span class="c"',
		'<font color="#DD0000"'   		=> '<span class="s"',
		'<span style="color: #000000"'	=> '<span class="d"',
		'<span style="color: #0000BB"' 	=> '<span class="f"',
		'<span style="color: #007700"'	=> '<span class="k"',
		'<span style="color: #FF8000"'	=> '<span class="c"',
		'<span style="color: #DD0000"'	=> '<span class="s"',
		'</font>' 						=> '</span>',
		'</span>' 						=> '</span>',
		'<br />'  						=> '',
		'<br/>'   						=> '',
		'&nbsp;'  						=> ' '
	);

    // Replace "<font>" tags with "<span>" tags
    $code = strtr($code, $xhtml_convmap);

	/* remove first <span> and last </span> */
	$code = preg_replace("/^<[^>]+>/", "", $code);
	$code = preg_replace("/<\/span>\$/", "", $code);
	
	/* remove '<?php' and '?>' if code is not PHP */
	if (!$is_php) {
		$code = preg_replace("/&lt;\?php/", "", $code, 1);
		$code = preg_replace("/\?&gt;/", "", $code, 1);
		$code = preg_replace("/<span[^>]*><\/span>/", "", $code);
	}
	
	return($code);
}
