<?php
session_start();
?>
<html>
<head>
<title>Form Processor Demo</title>
</head>
<body>
<?php
require_once('formprocessor.php');

function functionname1($val) {
	//Take the user input ($val) and perform some checks on it. Return true if it ok or false if it isn't
	return true;
}

function functionname2($val) {
	//Take the user input ($val) and perform some checks on it. Return true if it ok or false if it isn't
	return true;
}

function myform() {
$form = <<<EOD
<form id="myForm" action="testform.php" method="post">

<errorlist>
<ul>
	<erroritem>
		<li><error/></li>
	</erroritem>
</ul>
</errorlist>

<label for="field1">Field 1:</label>
<element id="field1">
	<input type="text" size="30" class="inputo" value="@" />
	<validate test="alpha" message="Field 1 must only contain letters" />
	<error><strong class="error">!</strong></error>
</element>

<br /><br />

<label for="field2">Field 2:</label>
<element id="field2">
	<input type="text" size="20" />
	<error><strong class="error">!</strong></error>
	<compulsory message="Field 2 is compulsory" />
	<regexp test="|^[a-zA-Z]*$|" message="Field 2 must only contain letters" />
	
	<match element="field1" message="Field1 must match Field2" />
	<callback function="functionname1" message="callback 1 failed for field2" />
	<callback function="functionname2" message="callback 2 failed for field2" />
</element>

<br /><br />

<label for="dropdown">Dropdown:</label>
<element id="dropdown">
	<select style="width:100px" />
	<option value="1" text="one" />
	<option value="2" text="two" />
	<option value="3" text="three" />
	<default value="3" />
	<error><strong class="error">!</strong></error>
	<callback function="functionname1" message="callback 1 failed for dropdown" />
</element>

<br /><br />

<label for="check">Check:</label>
<element id="check">
	<input type="checkbox" class="inputo" value="yay" />
	<checked value="true" />
	<error><strong class="error">!</strong></error>
	<callback function="functionname1" message="callback 1 failed for check" />
</element>

<br /><br />

<label for="radio">Radio:</label>
<element id="radio">
	<input type="radio" class="inputo" value="yay" name="groupname" />
	<checked value="true" />
	<error><strong class="error">!</strong></error>
	<callback function="functionname1" message="callback 1 failed for radio" />
</element>

<label for="radio2">Radio2:</label>
<element id="radio2">
	<input type="radio" class="inputo" value="yay2" name="groupname" />
	<checked value="false" />
	<error><strong class="error">!</strong></error>
</element>

<br /><br />

<label for="textarea">Textarea:</label>
<element id="textarea">
	<textarea />
	<value>yum yum yum"</value>
	<error><strong class="error">!</strong></error>
	<compulsory message="textarea is compulsory" />
	<regexp test="|^[a-zA-Z0-9 ]*$|" message="textarea doesn't match the regexp" />
</element>

<br /><br />

<element id="submitForm">
	<input type="submit" value="Go!" />
</element>

</form>

EOD;
return $form;
}

$processor =& new FormProcessor(myform());
if(isset($_POST["submitForm"])) {
	if ($processor->validate()) { //Change this to $processor->validate(false) to turn off CSRF protection
		echo '<pre>';
		print_r($_POST);
		echo '</pre>';
	}
	else
    	$processor->display();
}
else
	$processor->display();
?>
</body>
</html>