<?php
/******************************************************************************
* settings.php                                                                *
* Settings File                                                               *
* See readme.txt for additional information                                   *
*******************************************************************************
* phpCheckZ - The Easy Checklist Maker                                        *
* Open-Source Project By Ryan Christenson (The RSWR Network)                  *
* =========================================================================== *
* Software Version:           phpCheckZ 1.0.2                                 *
* Software by:                The RSWR Network (http://www.rswr.net)          *
* Copyright 2008 by:          Ryan Christenson (http://www.rswr.net)          *
* Support, News, Updates at:  http://www.phpcheckz.com/                       *
*******************************************************************************
* This program is free software; you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by        *
* the Free Software Foundation; either version 2 of the License, or           *
* (at your option) any later version.                                         *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* if not, write to the:                                                       *
* Free Software Foundation, Inc.                                              *
* 51 Franklin St - Fifth Floor, Boston, MA 02110-1301, USA                    *
******************************************************************************/
session_start();
ob_start();
?>
<?php include "constants.php" ?>
<?php include "db.php" ?>
<?php include "security.php" ?>
<?php include "functions.php" ?>
<?php include "language.php" ?>
<?php
if (!ckz_IsLoggedIn() && (@$_COOKIE[CookieAutoLogin] == "autologin" && @$_COOKIE[CookiePassword] <> "")) {
	ob_end_clean();
	header("Location: login.php");
	exit();
}
ckz_LoadUserLevel();
$ckz_CurSec = (ckz_IsLoggedIn())? ckz_CurrentUserLevelPriv("settings") : ckz_GetAnonymousPriv("settings");	
if (($ckz_CurSec & ckz_Edit_Perms) <> ckz_Edit_Perms) {
	ob_end_clean();
	header("Location: login.php");
	exit();
}
?>
<?php
// Load key from QueryString
$x_id = "1";

// Get action
$sAction = @$_POST["a_edit"];
if ($sAction == "") {
	$sAction = "I";	// Display record	
} else {

	// Get fields from form
	$x_id = @$_POST["x_id"];
	$x_graphs_toggle = @$_POST["x_graphs_toggle"];
	$x_lang = @$_POST["x_lang"];
	$x_reg_page = @$_POST["x_reg_page"];
	$x_bridges = @$_POST["x_bridges"];
	$x_bridge_path = @$_POST["x_bridge_path"];
	$x_bridge_login = @$_POST["x_bridge_login"];
	$x_bridge_group = @$_POST["x_bridge_group"];
}

$conn = ckz_db_connect(HOST, USER, PASS, DB, PORT);
switch ($sAction) {
	case "I": // Display record
		if (!LoadData($conn)) { // Load record
			$_SESSION[ckzSessMessage] = $Translation["set_01"];
			ckz_db_close($conn);
			ob_end_clean();
		}
		break;
	case "U": // Update
		if (EditData($conn)) { // Update record
			$_SESSION[ckzSessMessage] = $Translation["set_02"];
			ckz_db_close($conn);
			ob_end_clean();
			header("Location: admin.php");
			exit();
		}
		break;
}
?>
<?php include "header.php" ?>
<form name="fsettings" id="fsettings" action="settings.php" method="post">
<p>
	<input type="hidden" name="a_edit" value="U">
<?php
if (@$_SESSION[ckzSessMessage] <> "") {
	echo '<p><div class="red">' . $_SESSION[ckzSessMessage] . '</div></p>';
	$_SESSION[ckzSessMessage] = "";
}
?>
	<table class="table2Header bold"><tr><td><?php echo $Translation["set_03"]; ?></td></tr></table>
	<table class="table2">
		<input type="hidden" id="x_id" name="x_id" value="<?php echo @$x_id; ?>">
		<tr>
			<td><a href="#" onclick="$.prompt('Chart Toggle<br /><br />Checked = Charts On')"><img src="images/info.png" width="24" height="24" border="0" alt="Help Tip" /></a></td>
			<td><?php echo $Translation["set_04"]; ?></td>
			<td><input type="checkbox" name="x_graphs_toggle" <?php if (@$x_graphs_toggle == "1") { ?> checked<?php } ?> value="1" /></td>
		</tr>
		<tr>
			<td><a href="#" onclick="$.prompt('Default Language<br /><br />Pick the language you would like phpCheckZ translated to.<br /><br /><span class=\'red\'>At this time only English is available. Plans to support other languages in the future.</span>')"><img src="images/info.png" width="24" height="24" border="0" alt="Help Tip" /></a></td>
			<td><?php echo $Translation["set_05"]; ?></td>
			<td>
<?php
$x_langList = "<select id='x_lang' name='x_lang'>";
	// English
	$x_langList .= "<option value=\"eng\"";
	if (@$x_lang == "eng") {
		$x_langList .= " selected";
	}
	$x_langList .= ">" . "English" . "</option>";
	// For Future Language Support
	/*
	$x_langList .= "<option value=\"lan\"";
	if (@$x_lang == "lan") {
		$x_langList .= " selected";
	}
	$x_langList .= ">" . "Language #2" . "</option>";
	*/
$x_langList .= "</select>";
echo $x_langList;
?>
			</td>
		</tr>
		<tr>
			<td><a href="#" onclick="$.prompt('Register Include Page (URL)<p>Enter the URL to the page that contains the register include.')"><img src="images/info.png" width="24" height="24" border="0" alt="Help Tip" /></a></td>
			<td><?php echo $Translation["set_06"]; ?></td>
			<td><input type="text" name="x_reg_page" id="x_reg_page" size="50" maxlength="255" value="<?php echo htmlspecialchars(@$x_reg_page) ?>"  class="text" /></td>
		</tr>
	</table>
	<br /><br />
	<table class="table2Header bold"><tr><td><?php echo $Translation["set_07"]; ?></td></tr></table>
	<table class="table2">
		<tr>
			<td><a href="#" onclick="$.prompt('Login Bridges<p>Choose if you would like to use a bridge to login rather than the default login page.</p><span class=\'red\'><br />BETA Feature<br />The bridge settings are currently in the beta phase and may have some bugs. Please report any bugs you find.</span>')"><img src="images/info.png" width="24" height="24" border="0" alt="Help Tip" /></a></td>
			<td><?php echo $Translation["set_08"]; ?></td>
			<td>
<?php
$x_bridgesList = "<select id='x_bridges' name='x_bridges'>";
$x_bridgesList .= "<option value=''>Use Default Login</option>";
	// Option A
	$x_bridgesList .= "<option value=\"A\"";
	if (@$x_bridges == "A") {
		$x_bridgesList .= " selected";
	}
	$x_bridgesList .= ">" . "SMF 1.1.4" . "</option>";
	// Option B
	$x_bridgesList .= "<option value=\"B\"";
	if (@$x_bridges == "B") {
		$x_bridgesList .= " selected";
	}
	$x_bridgesList .= ">" . "phpBB --- Not Available Yet" . "</option>";
	// Option C
	$x_bridgesList .= "<option value=\"C\"";
	if (@$x_bridges == "C") {
		$x_bridgesList .= " selected";
	}
	$x_bridgesList .= ">" . "Mambo --- Not Available Yet" . "</option>";
	// Option D
	$x_bridgesList .= "<option value=\"D\"";
	if (@$x_bridges == "C") {
		$x_bridgesList .= " selected";
	}
	$x_bridgesList .= ">" . "Joomla --- Not Available Yet" . "</option>";
$x_bridgesList .= "</select>";
echo $x_bridgesList;
?>
		</td>
		</tr>
		<tr>
			<td><a href="#" onclick="$.prompt('Bridge Path<p>Path to the bridge\'s folder.</p>Example #1: Path to phpCheckZ<br /><span class=\'red\'><?php echo addslashes(ckz_RootRel()) ?></span><br /><br />Example #2: Path to a Forum<br /><span class=\'red\'><?php echo addslashes(ckz_RootRel()) . "forum\\\\" ?></span>')"><img src="images/info.png" width="24" height="24" border="0" alt="Help Tip" /></a></td>
			<td><?php echo $Translation["set_09"]; ?></td>
			<td><input type="text" name="x_bridge_path" id="x_bridge_path" size="50" maxlength="255" value="<?php echo htmlspecialchars(@$x_bridge_path) ?>"  class="text" /></td>
		</tr>
		<tr>
			<td><a href="#" onclick="$.prompt('Bridge Login (URL)<p>Set the URL to the bridge\'s login page.</p>This is the page you want visitors to be redirected to for login.')"><img src="images/info.png" width="24" height="24" border="0" alt="Help Tip" /></a></td>
			<td><?php echo $Translation["set_10"]; ?></td>
			<td><input type="text" name="x_bridge_login" id="x_bridge_login" size="50" maxlength="255" value="<?php echo htmlspecialchars(@$x_bridge_login) ?>"  class="text" /></td>
		</tr>
		<tr>
			<td><a href="#" onclick="$.prompt('Bridge Group - <span class=\'red\'>SMF Only</span><p>Input the Number of the group setup for people that are given permission to moderate.</p>')"><img src="images/info.png" width="24" height="24" border="0" alt="Help Tip" /></a></td>
			<td><?php echo $Translation["set_11"]; ?> - <span class="red"><?php echo $Translation["set_12"]; ?></span></td>
			<td><input type="text" name="x_bridge_group" id="x_bridge_group" size="50" maxlength="3" value="<?php echo $x_bridge_group ?>"  class="text" /></td>
		</tr>
	</table>
	<p>
	<input type="submit" name="btnAction" id="btnAction" value="<?php echo $Translation["set_13"]; ?>" class="button" />
</form>
<?php include "footer.php" ?>
<?php

//-------------------------------------------------------------------------------
// Function LoadData
// - Variables setup: field variables

function LoadData($conn)
{
	global $x_id;
	$sFilter = Settings_KeyWhere;
	if (!is_numeric($x_id)) return false;
	$x_id =  (get_magic_quotes_gpc()) ? stripslashes($x_id) : $x_id;
	$sFilter = str_replace("@id", AdjustSql($x_id), $sFilter); // Replace key value
	$sSql = ckz_BuildSql(Settings_Select, Settings_Where, Settings_GroupBy, Settings_Having, Settings_OrderBy, $sFilter, "");
	$rs = ckz_query($sSql,$conn) or die("Failed to execute query at line " . __LINE__ . ": " . ckz_error($conn) . '<br>SQL: ' . $sSql);
	if (ckz_num_rows($rs) == 0) {
		$bLoadData = false;
	} else {
		$bLoadData = true;
		$row = ckz_fetch_array($rs);

		// Get the field contents
		$GLOBALS["x_id"] = $row["id"];
		$GLOBALS["x_graphs_toggle"] = $row["graphs_toggle"];
		$GLOBALS["x_lang"] = $row["lang"];
		$GLOBALS["x_reg_page"] = $row["reg_page"];
		$GLOBALS["x_bridges"] = $row["bridges"];
		$GLOBALS["x_bridge_path"] = $row["bridge_path"];
		$GLOBALS["x_bridge_login"] = $row["bridge_login"];
		$GLOBALS["x_bridge_group"] = $row["bridge_group"];
	}
	ckz_free_result($rs);
	return $bLoadData;
}
?>
<?php

//-------------------------------------------------------------------------------
// Function EditData
// - Variables used: field variables

function EditData($conn)
{
	global $x_id;
	$sFilter = Settings_KeyWhere;
	if (!is_numeric($x_id)) return false;
	$sTmp =  (get_magic_quotes_gpc()) ? stripslashes($x_id) : $x_id;
	$sFilter = str_replace("@id", AdjustSql($sTmp), $sFilter); // Replace key value
	$sSql = ckz_BuildSql(Settings_Select, Settings_Where, Settings_GroupBy, Settings_Having, Settings_OrderBy, $sFilter, "");
	$rs = ckz_query($sSql,$conn) or die("Failed to execute query at line " . __LINE__ . ": " . ckz_error($conn) . '<br>SQL: ' . $sSql);

	// Get old recordset
	$oldrs = ckz_fetch_array($rs);
	if (ckz_num_rows($rs) == 0) {
		return false; // Update Failed
	} else {
		$x_id = @$_POST["x_id"];
		$x_bridge_login = @$_POST["x_bridge_login"];
		$x_graphs_toggle = @$_POST["x_graphs_toggle"];
		$x_lang = @$_POST["x_lang"];
		$x_reg_page = @$_POST["x_reg_page"];
		$x_bridges = @$_POST["x_bridges"];
		$x_bridge_path = @$_POST["x_bridge_path"];
		$x_bridge_login = @$_POST["x_bridge_login"];
		$x_bridge_group = @$_POST["x_bridge_group"];
		$theValue = (!get_magic_quotes_gpc()) ? addslashes($GLOBALS["x_graphs_toggle"]) : $GLOBALS["x_graphs_toggle"]; 
		$theValue = ($theValue != "") ? " '" . $theValue . "'" : "NULL";
		$fieldList["`graphs_toggle`"] = $theValue;
		$theValue = (!get_magic_quotes_gpc()) ? addslashes($GLOBALS["x_lang"]) : $GLOBALS["x_lang"]; 
		$theValue = ($theValue != "") ? " '" . $theValue . "'" : "NULL";
		$fieldList["`lang`"] = $theValue;
		$theValue = (!get_magic_quotes_gpc()) ? addslashes($GLOBALS["x_reg_page"]) : $GLOBALS["x_reg_page"]; 
		$theValue = ($theValue != "") ? " '" . $theValue . "'" : "NULL";
		$fieldList["`reg_page`"] = $theValue;
		$theValue = (!get_magic_quotes_gpc()) ? addslashes($GLOBALS["x_bridges"]) : $GLOBALS["x_bridges"]; 
		$theValue = ($theValue != "") ? " '" . $theValue . "'" : "1";
		$fieldList["`bridges`"] = $theValue;
		$theValue = (!get_magic_quotes_gpc()) ? addslashes($GLOBALS["x_bridge_path"]) : $GLOBALS["x_bridge_path"]; 
		$theValue = ($theValue != "") ? " '" . $theValue . "'" : "NULL";
		$fieldList["`bridge_path`"] = $theValue;
		$theValue = (!get_magic_quotes_gpc()) ? addslashes($GLOBALS["x_bridge_login"]) : $GLOBALS["x_bridge_login"]; 
		$theValue = ($theValue != "") ? " '" . $theValue . "'" : "NULL";
		$fieldList["`bridge_login`"] = $theValue;
		$theValue = (!get_magic_quotes_gpc()) ? addslashes($GLOBALS["x_bridge_group"]) : $GLOBALS["x_bridge_group"]; 
		$theValue = ($theValue != "") ? " '" . $theValue . "'" : "1";
		$fieldList["`bridge_group`"] = $theValue;

		// Updating event
		if (Recordset_Updating($fieldList, $oldrs)) {

			// Update
			$sSql = "UPDATE `settings` SET ";
			foreach ($fieldList as $key=>$temp) {
				$sSql .= "$key = $temp, ";
			}
			if (substr($sSql, -2) == ", ") {
				$sSql = substr($sSql, 0, strlen($sSql)-2);
			}
			$sSql .= " WHERE " . $sFilter;
			ckz_query($sSql,$conn) or die("Failed to execute query at line " . __LINE__ . ": " . ckz_error($conn) . '<br>SQL: ' . $sSql);
			$result = (ckz_affected_rows($conn) >= 0);

			// Updated event
			if ($result) Recordset_Updated($fieldList, $oldrs);
		} else {
			$result = false; // Update Failed
		}
	}
	return $result;
}
// Updating Event
function Recordset_Updating(&$newrs, $oldrs) {return true;}
// Updated event
function Recordset_Updated($newrs, $oldrs) {$table = "settings";}
?>
