<?php
/******************************************************************************
* security.php                                                                *
* Security/Permissions File                                                   *
* See readme.txt for additional information                                   *
*******************************************************************************
* phpCheckZ - The Easy Checklist Maker                                        *
* Open-Source Project By Ryan Christenson (The RSWR Network)                  *
* =========================================================================== *
* Software Version:           phpCheckZ 1.0.2                                 *
* Software by:                The RSWR Network (http://www.rswr.net)          *
* Copyright 2008 by:          Ryan Christenson (http://www.rswr.net)          *
* Support, News, Updates at:  http://www.phpcheckz.com/                       *
*******************************************************************************
* This program is free software; you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by        *
* the Free Software Foundation; either version 2 of the License, or           *
* (at your option) any later version.                                         *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* if not, write to the:                                                       *
* Free Software Foundation, Inc.                                              *
* 51 Franklin St - Fifth Floor, Boston, MA 02110-1301, USA                    *
******************************************************************************/

// User levels

define("ckz_Add_Perms", 1, true);
define("ckz_Del_Perms", 2, true);
define("ckz_Edit_Perms", 4, true);
define("ckz_View_Perms", 8, true);
define("ckz_Allow", 8, true);
define("ckz_Admin_Perms", 16, true);
$ckz_vUserLevel = NULL;
$ckz_vUserLevelPriv = NULL;

// Static user level security
// ----------------------------------------------------------------------------------------------

function ckz_SetUpUserLevel()
{
	global $ckz_vUserLevel;
	global $ckz_vUserLevelPriv;

	// User Level definitions
	$ckz_vUserLevel = NULL;
	$ckz_vUserLevel[] = array(0=>"0", 1=>"Anonymous");
	$ckz_vUserLevel[] = array(0=>"1", 1=>"Registered");
	$ckz_vUserLevel[] = array(0=>"2", 1=>"Moderator");
	$ckz_vUserLevelPriv = NULL;
	$ckz_vUserLevelPriv[] = array(0=>"listcreate",1=>0,2=>0);
	$ckz_vUserLevelPriv[] = array(0=>"listcreate",1=>1,2=>0);
	$ckz_vUserLevelPriv[] = array(0=>"listcreate",1=>2,2=>13);
	$ckz_vUserLevelPriv[] = array(0=>"listdata",1=>0,2=>0);
	$ckz_vUserLevelPriv[] = array(0=>"listdata",1=>1,2=>13);
	$ckz_vUserLevelPriv[] = array(0=>"listdata",1=>2,2=>13);
	$ckz_vUserLevelPriv[] = array(0=>"users",1=>0,2=>0);
	$ckz_vUserLevelPriv[] = array(0=>"users",1=>1,2=>0);
	$ckz_vUserLevelPriv[] = array(0=>"users",1=>2,2=>0);
	$ckz_vUserLevelPriv[] = array(0=>"settings",1=>0,2=>0);
	$ckz_vUserLevelPriv[] = array(0=>"settings",1=>1,2=>0);
	$ckz_vUserLevelPriv[] = array(0=>"settings",1=>2,2=>0);

	// Save the user level to session variable
	ckz_SaveUserLevel();
}

// Get current user privilege
function ckz_CurrentUserLevelPriv($TableName)
{
	return ckz_GetUserLevelPrivEx($TableName, ckz_CurrentUserLevel());
}

// Get anonymous user privilege
function ckz_GetAnonymousPriv($TableName)
{
	return ckz_GetUserLevelPrivEx($TableName, 0);
}

// Get user privilege based on table name and user level
function ckz_GetUserLevelPrivEx($TableName, $UserLevel)
{
	global $ckz_vUserLevelPriv;
	$userLevelPrivEx = 0;
	if (strval($UserLevel) == "-1") {
		return 31;
	} elseif ($UserLevel >=0) {
		if (is_array($ckz_vUserLevelPriv)) {
			foreach ($ckz_vUserLevelPriv as $row) {
				if ((strtolower($row[0]) == strtolower($TableName)) And (strval($row[1]) == strval($UserLevel))) {
					$userLevelPrivEx = $row[2];
				if ((is_null($userLevelPrivEx))) $userLevelPrivEx = 0;
				if (!is_numeric($userLevelPrivEx)) $userLevelPrivEx = 0;
				return (int)($userLevelPrivEx);
				}
			}
		}
	}	
}

// Get current user level name
function ckz_CurrentUserLevelName()
{
	return ckz_GetUserLevelName(ckz_CurrentUserLevel());
}

// Get user level name based on user level
function ckz_GetUserLevelName($UserLevel)
{
	global $ckz_vUserLevel;
	if (strval($UserLevel) == "-1") {
		return "Administrator";
	} elseif ($UserLevel >= 0) {
		if (is_array($ckz_vUserLevel)) {
			foreach ($ckz_vUserLevel as $row) {
				if (strval($row[0]) == strval($UserLevel)) {
					return $row[1];
				}
			}
		}
	}
}

// Function to check privilege for List page (for menu items)
function ckz_Allow($TableName)
{
	return (ckz_CurrentUserLevelPriv($TableName) & ckz_Allow);
}

// Get current user name from session
function ckz_CurrentUserName()
{
	return @$_SESSION[ckzSessUserName];
}

// Get current user id from session
function ckz_CurrentUserID()
{
	return @$_SESSION[ckzSessUserID];
}

// Get current parent user id from session
function ckz_CurrentParentUserID()
{
	return @$_SESSION[ckzSessParentUserID];
}

// Get current user level from session
function ckz_CurrentUserLevel()
{
	if (ckz_IsLoggedIn()) {
		return @$_SESSION[ckzSessUserLevel];
	} else {
		return 0; //Anonymous if not logged in
	}
}

// Check if user is logged in
function ckz_IsLoggedIn()
{
	return (@$_SESSION[ckzSessStatus] == "login");
}

// Check if user is system administrator
function ckz_Admin()
{
	return (@$_SESSION[ckzSessUserLevel] == -1);
}

// Save user level to session
function ckz_SaveUserLevel()
{
	$_SESSION[ckzSessckz_vUserLevel] = $GLOBALS["ckz_vUserLevel"];
	$_SESSION[ckzSessckz_vUserLevelPriv] = $GLOBALS["ckz_vUserLevelPriv"];
}

// Load user level from session
function ckz_LoadUserLevel()
{
	if (!is_array(@$_SESSION[ckzSessckz_vUserLevel])) {
		ckz_SetUpUserLevel();
		ckz_SaveUserLevel();
	}
	$GLOBALS["ckz_vUserLevel"] = @$_SESSION[ckzSessckz_vUserLevel];
	$GLOBALS["ckz_vUserLevelPriv"] = @$_SESSION[ckzSessckz_vUserLevelPriv];
}
?>
