<?php 
session_start();
ob_start();
?>
<?php include "constants.php" ?>
<?php include "db.php" ?>
<?php include "security.php" ?>
<?php include "functions.php" ?>
<?php include "language.php" ?>
<?php
ckz_LoadUserLevel(); // Load user level
if (@$_POST["submit"] <> "") {
	$bValidPwd = false;

	// Setup variables
	$sUsername = @$_POST["username"];
	$sPassword = @$_POST["password"];
	if (ValidateUser($sUsername, $sPassword)) {

		// Write cookies
		$sLoginType = strtolower($_POST["rememberme"]);
		$expirytime = time() + 365*24*60*60; // change cookie expiry time here
		if ($sLoginType == "a") {
			setCookie(CookieAutoLogin, "autologin", $expirytime);
			setCookie(CookieUserName, $sUsername, $expirytime);
			setCookie(CookiePassword, ckz_TEAencrypt($sPassword, phpcheckz_Ran_Key), $expirytime);
		} else {
			setCookie(CookieAutoLogin, "", $expirytime);
		}
		$_SESSION[ckzSessStatus] = "login";
		ob_end_clean();
		header("Location: index.php");
		exit();
	} else {
		$_SESSION[ckzSessMessage] = $Translation["login_01"];
	}
} else {
	if (ckz_IsLoggedIn()) {
		if ($_SESSION[ckzSessMessage] == "") {
			ob_end_clean();
			header("Location: index.php");
			exit();
		}
	} else { // Check auto login
		if (@$_COOKIE[CookieAutoLogin] == "autologin") {
			$sUsername = @$_COOKIE[CookieUserName] ;
			$sPassword = ckz_TEAdecrypt(@$_COOKIE[CookiePassword] , phpcheckz_Ran_Key);
			if (ValidateUser($sUsername, $sPassword)) {
				ob_end_clean();
				header("Location: index.php");
				exit();
			}
		}
	}
}
?>
<?php include "header.php" ?>
<script type="text/javascript">
<!--
function CheckMyForm(This) {
	if (!Field_hasValue(This.username, "TEXT" )) {
		$.prompt('<?php echo $Translation["login_09"]; ?>');
			return false;
	}
	if (!Field_hasValue(This.password, "PASSWORD" )) {
		$.prompt('<?php echo $Translation["login_10"]; ?>');
			return false;
	}
	return true;
}

//-->
</script>
<p><?php echo $Translation["login_02"]; ?></p>
<?php
if (@$_SESSION[ckzSessMessage] <> "") {
	echo '<p><div class="red">' . $_SESSION[ckzSessMessage] . '</div></p>';
	$_SESSION[ckzSessMessage] = "";
}
?>
<form action="login.php" method="post" onSubmit="return CheckMyForm(this);">
<table class="table2">
	<tr>
		<td><?php echo $Translation["login_03"]; ?></td>
		<td><input type="text" name="username" size="20" value="<?php echo @$_COOKIE[CookieUserName]; ?>" class="text" /></td>
	</tr>
	<tr>
		<td><?php echo $Translation["login_04"]; ?></td>
		<td><input type="password" name="password" size="20" class="text" /></td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
		<?php if (@$_COOKIE[CookieAutoLogin] == "autologin") { ?>
		<input type="checkbox" name="rememberme" value="a" checked /><?php echo $Translation["login_05"]; ?>
		<?php } else { ?>
		<input type="checkbox" name="rememberme" value="a" /><?php echo $Translation["login_05"]; ?>
		<?php } ?>
		</td>
	</tr>
</table>
<input type="submit" name="submit" value="<?php echo $Translation["login_06"]; ?>" class="button" />
</form>
<br />
<p>
<a href="forget.php"><?php echo $Translation["login_07"]; ?></a>&nbsp;&nbsp;&nbsp;&nbsp;
<a href="register.php"><?php echo $Translation["login_08"]; ?></a>&nbsp;&nbsp;&nbsp;&nbsp;
</p>
<?php

// Function to validate user
function ValidateUser($Username,$Password)
{
	$ValidateUser = false;
	$CaseSensitive = true; // Modify case sensitivity here

	// Check other users
	if (!$ValidateUser)	{
	$conn = ckz_db_connect(HOST, USER, PASS, DB, PORT);
	$Username = (!get_magic_quotes_gpc()) ? addslashes($Username) : $Username;
	$sFilter = "(`user` = '" . AdjustSql($Username) . "')";
	$sSql = ckz_BuildSql(Users_Select, Users_Where, Users_GroupBy, Users_Having, Users_OrderBy, $sFilter, "");
	$query = ckz_query($sSql,$conn) or die("Failed to execute query at line " . __LINE__ . ": " . ckz_error($conn) . '<br />SQL: ' . $sSql);
	if (ckz_num_rows($query) > 0) {
		$rs = ckz_fetch_array($query);
			$ValidateUser=($rs["pass"] == ckz_enc_pass($Password));
    if ($ValidateUser) {
			$_SESSION[ckzSessStatus] = "login";
			$_SESSION[ckzSessUserName] = $rs["user"];
			$_SESSION[ckzSessSysAdmin] = 0; // Non system admin
			$_SESSION[ckzSessUserID] = $rs["user"]; // User ID
			$_SESSION[ckzSessUserLevel] = $rs["UserLevel"]; // User Level
			if ($_SESSION[ckzSessUserLevel] == -1) { // System admin
				$_SESSION[ckzSessUserID] = -1;
			}
		ckz_SetUpUserLevel();
    }
	}
	ckz_free_result($query);
	ckz_db_close($conn);
	}
	return $ValidateUser;
}
?>
<?php include "footer.php" ?>
