<?php
/******************************************************************************
* functions.php                                                               *
* Main Program Functions File                                                 *
* See readme.txt for additional information                                   *
*******************************************************************************
* phpCheckZ - The Easy Checklist Maker                                        *
* Open-Source Project By Ryan Christenson (The RSWR Network)                  *
* =========================================================================== *
* Software Version:           phpCheckZ 1.0.2                                 *
* Software by:                The RSWR Network (http://www.rswr.net)          *
* Copyright 2008 by:          Ryan Christenson (http://www.rswr.net)          *
* Support, News, Updates at:  http://www.phpcheckz.com/                       *
*******************************************************************************
* This program is free software; you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by        *
* the Free Software Foundation; either version 2 of the License, or           *
* (at your option) any later version.                                         *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* if not, write to the:                                                       *
* Free Software Foundation, Inc.                                              *
* 51 Franklin St - Fifth Floor, Boston, MA 02110-1301, USA                    *
******************************************************************************/
define("SMTP", "localhost", true);
define("SMTP_PORT", "25", true);
define("SMTP_USERNAME", "", true);
define("SMTP_PASSWORD", "", true);
define("ckz_RootRelativePath", ".", true);
define("phpcheckz_Ran_Key", "0imGbZIyp720w5ie", true);
define("Encoding", "ISO-8859-1", true);// Encoding

$PathDelimiter = (strtolower(substr(PHP_OS, 0, 3)) === 'win') ? "\\" : "/";

// Functions to Convert from UTF-8 or to UTF-8
function ConvertToUtf8($str) {return Convert(Encoding, "UTF-8", $str);}
function ConvertFromUtf8($str) {return Convert("UTF-8", Encoding, $str);}
function Convert($from, $to, $str)
{
	if ($from != "" && $to != "" && $from != $to) {
		if (function_exists("iconv")) {
			return iconv($from, $to, $str);
		} elseif (function_exists("mb_convert_encoding")) {
			return mb_convert_encoding($str, $to, $from);
		} else {
			return $str;
		}
	} else {
	return $str;
	}
}

// Function to get Relative Path
function ckz_RootRel() {

	global $PathDelimiter;
	
	// Use root relative path
	if (ckz_RootRelativePath != "") {
		$Path = realpath(ckz_RootRelativePath);
		$Path = str_replace("\\\\", $PathDelimiter, $Path);
	}
	return ckz_TrailingSlash($Path, true);
}

// Function to include the last Trailing Slash for the path
function ckz_TrailingSlash($Path, $PhyPath) {
	global $PathDelimiter;
	if ($PhyPath) {
		if (substr($Path, -1) <> $PathDelimiter) $Path .= $PathDelimiter;
	} else {
		if (substr($Path, -1) <> "/") $Path .= "/";
	}
	return $Path;
}

// Function to Load Email Content from input file name
function ckz_LoadEmail($fn)
{
	global $sEmailSubject;
	global $sEmailFrom;
	global $sEmailTo;
	global $sEmailCc;
	global $sEmailBcc;
	global $sEmailFormat;
	global $sEmailContent;

	$sWrk = ckz_LoadTxt($fn); // Load text file content
	if ($sWrk <> "") {
		// Locate Header & Mail Content
		if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
			$i = strpos($sWrk, "\r\n\r\n");
		} else {
			$i = strpos($sWrk, "\n\n");
			if ($i === false) $i = strpos($sWrk, "\r\n\r\n");
		}
		if ($i > 0) {
			$sHeader = substr($sWrk, 0, $i);
			$sEmailContent = trim(substr($sWrk, $i, strlen($sWrk)));
			if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
				$arrHeader = split("\r\n",$sHeader);
			} else {
				$arrHeader = split("\n",$sHeader);
			}
			for ($j = 0; $j < count($arrHeader); $j++)
			{
				$i = strpos($arrHeader[$j], ":");
				if ($i > 0) {
					$sName = trim(substr($arrHeader[$j], 0, $i));
					$sValue = trim(substr($arrHeader[$j], $i+1, strlen($arrHeader[$j])));
					switch (strtolower($sName))
					{
						case "subject": $sEmailSubject = $sValue;
												break;
						case "from": $sEmailFrom = $sValue;
												break;
						case "to": $sEmailTo = $sValue;
												break;
						case "cc": $sEmailCc = $sValue;
												break;
						case "bcc": $sEmailBcc = $sValue;
												break;
						case "format": $sEmailFormat = $sValue;
												break;
					}
				}
			}
		}
	}

}

// Function to Load a Text File
function ckz_LoadTxt($fn)
{	global $PathDelimiter;
	
	// Get text file content
	$filepath = realpath(".") . $PathDelimiter . $fn;
	
	$fobj = fopen ($filepath , "r");
	return fread ($fobj, filesize ($filepath));
}

//Function to Send out Email
function ckz_Send_Email($sFrEmail, $sToEmail, $sCcEmail, $sBccEmail, $sSubject, $sMail, $sFormat)
{
	/* for debug only
	echo "sSubject: " . $sSubject . "<br>";
	echo "sFrEmail: " . $sFrEmail . "<br>";
	echo "sToEmail: " . $sToEmail . "<br>";
	echo "sCcEmail: " . $sCcEmail . "<br>"; 
	echo "sSubject: " . $sSubject . "<br>";
	echo "sMail: " . $sMail . "<br>";
	echo "sFormat: " . $sFormat . "<br>";
	exit();
	*/

	/* recipients */
	$to  = $sToEmail;

	/* subject */
	$subject = $sSubject;

	$headers = "";

	if (strtolower($sFormat) == "html") {
		$content_type = "text/html";
	} else {
		$content_type = "text/plain";
	}

	$headers = "Content-type: " . $content_type . "\r\n";

	$message = $sMail;

	/* additional headers */
	$headers .= "From: " . str_replace(";", ",", $sFrEmail) . "\r\n";
	if ($sCcEmail <> "") {
		$headers .= "Cc: " . str_replace(";", ",", $sCcEmail) . "\r\n";
	}
	if ($sBccEmail <>"") {
		$headers .= "Bcc: " . str_replace(";", ",", $sBccEmail) . "\r\n";
	}

	/* and now mail it */
	if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
		ini_set("SMTP",SMTP);
		ini_set("smtp_port",SMTP_PORT);
	}
	ini_set("sendmail_from",$sFrEmail);
	if (!mail($to, $subject, $message, $headers)) {
		echo "There has been a mail error sending to " . $sToEmail . "<br />";
		return false;
	} else {
		return true;
	}

}

// For the below TEA encrypt and decrypt functions
function ckz_long2str($v, $w)
{
	$len = count($v);
	$s = array();
	for ($i = 0; $i < $len; $i++)
	{
		$s[$i] = pack("V", $v[$i]);
	}
	if ($w) {
		return substr(join('', $s), 0, $v[$len - 1]);
	}	else {
		return join('', $s);
	}
}

// For the below TEA encrypt and decrypt functions
function ckz_str2long($s, $w)
{
	$v = unpack("V*", $s. str_repeat("\0", (4 - strlen($s) % 4) & 3));
	$v = array_values($v);
	if ($w) {
		$v[count($v)] = strlen($s);
	}
	return $v;
}

// Function for TEA encrypt (Cookies)
function ckz_TEAencrypt($str, $key)
{
	if ($str == "") {
		return "";
	}
	$v = ckz_str2long($str, true);
	$k = ckz_str2long($key, false);
	if (count($k) < 4)
	{
		for ($i = count($k); $i < 4; $i++) {
			$k[$i] = 0;
		}
	}
	$n = count($v) - 1;
	
	$z = $v[$n];
	$y = $v[0];
	$delta = 0x9E3779B9;
	$q = floor(6 + 52 / ($n + 1));
	$sum = 0;
	while (0 < $q--) {
		$sum = ckz_int32($sum + $delta);
		$e = $sum >> 2 & 3;
		for ($p = 0; $p < $n; $p++) {
			$y = $v[$p + 1];
			$mx = ckz_int32((($z >> 5 & 0x07ffffff) ^ $y << 2) + (($y >> 3 & 0x1fffffff) ^ $z << 4)) ^ ckz_int32(($sum ^ $y) + ($k[$p & 3 ^ $e] ^ $z));
			$z = $v[$p] = ckz_int32($v[$p] + $mx);
		}
		$y = $v[0];
		$mx = ckz_int32((($z >> 5 & 0x07ffffff) ^ $y << 2) + (($y >> 3 & 0x1fffffff) ^ $z << 4)) ^ ckz_int32(($sum ^ $y) + ($k[$p & 3 ^ $e] ^ $z));
		$z = $v[$n] = ckz_int32($v[$n] + $mx);
	}
	return urlencode(ckz_long2str($v, false));
}

// Function for TEA decrypt (Cookies)
function ckz_TEAdecrypt($str, $key)
{
	$str = urldecode($str);
	if ($str == "") {
		return "";
	}
	$v = ckz_str2long($str, false);
	$k = ckz_str2long($key, false);
	if (count($k) < 4)
	{
		for ($i = count($k); $i < 4; $i++) {
			$k[$i] = 0;
		}
	}
	$n = count($v) - 1;
	
	$z = $v[$n];
	$y = $v[0];
	$delta = 0x9E3779B9;
	$q = floor(6 + 52 / ($n + 1));
	$sum = ckz_int32($q * $delta);
	while ($sum != 0) {
		$e = $sum >> 2 & 3;
		for ($p = $n; $p > 0; $p--) {
			$z = $v[$p - 1];
			$mx = ckz_int32((($z >> 5 & 0x07ffffff) ^ $y << 2) + (($y >> 3 & 0x1fffffff) ^ $z << 4)) ^ ckz_int32(($sum ^ $y) + ($k[$p & 3 ^ $e] ^ $z));
			$y = $v[$p] = ckz_int32($v[$p] - $mx);
		}
		$z = $v[$n];
		$mx = ckz_int32((($z >> 5 & 0x07ffffff) ^ $y << 2) + (($y >> 3 & 0x1fffffff) ^ $z << 4)) ^ ckz_int32(($sum ^ $y) + ($k[$p & 3 ^ $e] ^ $z));
		$y = $v[0] = ckz_int32($v[0] - $mx);
		$sum = ckz_int32($sum - $delta);
	}
	return ckz_long2str($v, true);
}

// For the above TEA encrypt and decrypt functions
function ckz_int32($n) {
	while ($n >= 2147483648) $n -= 4294967296;
	while ($n <= -2147483649) $n += 4294967296; 
	return (int)$n;
}

// Password Encryption
function ckz_enc_pass($source){
	$salt[0] = "yabba_dabba_doo";   // Limit this to 16 characters
	$salt[1] = "I-will-b";             // Limit this to 8 characters
	$crypt[0] = crc32($source);
	$crypt[1] = crypt($source, $salt[0]);
	$crypt[2] = md5($source);
	$crypt = implode($salt[1], $crypt);
return sha1($source.$crypt);
}

// Random Pass Generator
function ckz_RanPass() {
    $chars = "abcdefghijkmnopqrstuvwxyz023456789";
    srand((double)microtime()*1000000);
    $i = 0;
    $pass = '' ;
    while ($i <= 7) {
        $num = rand() % 33;
        $tmp = substr($chars, $num, 1);
        $pass = $pass . $tmp;
        $i++; 
    }
    return $pass;
}

// Generate Checklist
function ckz_gen_list($parent) {
	$has_childs = false;
	global $menu_array;

	foreach($menu_array as $key => $value) {
		if ($value['parent'] == $parent) {	
			// If this is the first child print '<ul>'
			if ($has_childs === false) {
				// Prevent '<ul>' being printed multiple times
				$has_childs = true;
				echo '<ul>';
			}
?>
			<li><input type="checkbox" name="x_c<?php echo $value['id'] ?>" value="Y"<?php if ($value['value'] == "Y") { ?> checked<?php } ?> /><?php echo $value['caption'] . "\n";?>
<?php
			// Call function again for subcategories belonging to this category
			ckz_gen_list($key);
			echo '</li>';
		}
	}
	if ($has_childs === true) echo '</ul>';
}
?>
