<?php 
/******************************************************************************
* forget.php                                                               *
* Forget Password File                                                        *
* See readme.txt for additional information                                   *
*******************************************************************************
* phpCheckZ - The Easy Checklist Maker                                        *
* Open-Source Project By Ryan Christenson (The RSWR Network)                  *
* =========================================================================== *
* Software Version:           phpCheckZ 1.0.2                                 *
* Software by:                The RSWR Network (http://www.rswr.net)          *
* Copyright 2008 by:          Ryan Christenson (http://www.rswr.net)          *
* Support, News, Updates at:  http://www.phpcheckz.com/                       *
*******************************************************************************
* This program is free software; you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by        *
* the Free Software Foundation; either version 2 of the License, or           *
* (at your option) any later version.                                         *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* if not, write to the:                                                       *
* Free Software Foundation, Inc.                                              *
* 51 Franklin St - Fifth Floor, Boston, MA 02110-1301, USA                    *
******************************************************************************/
session_start();
ob_start();
?>
<?php include "constants.php" ?>
<?php include "db.php" ?>
<?php include "security.php" ?>
<?php include "functions.php" ?>
<?php include "language.php" ?>
<?php
if (@$_POST["email"] <> "") {
	$bValidEmail = false;

	// Setup variables
	$sEmail = @$_POST["email"];
	$conn = ckz_db_connect(HOST, USER, PASS, DB, PORT);
	$sEmail = (!get_magic_quotes_gpc()) ? addslashes($sEmail) : $sEmail;
	$sFilter = "`email` = '" . AdjustSql($sEmail) . "'";
	$sSql = ckz_BuildSql(Users_Select, Users_Where, Users_GroupBy, Users_Having, Users_OrderBy, $sFilter, "");
	$rs = ckz_query($sSql,$conn) or die("Failed to execute query at line " . __LINE__ . ": " . ckz_error($conn) . '<br />SQL: ' . $sSql);
	if (ckz_num_rows($rs) > 0) {
		$row = ckz_fetch_array($rs);
		$sPassword = $row["pass"];
		$sUsername = $row["user"];
		$bValidEmail = true;
	}
	ckz_free_result($rs);
	ckz_db_close($conn);
	if ($bValidEmail) {
		$ckz_RanPass = ckz_RanPass();
		$newpass = $ckz_RanPass;

		$conn = ckz_db_connect(HOST, USER, PASS, DB, PORT);
		$sFilter = "(`user` = '" . AdjustSql($sUsername) . "')";
		$sSql = ckz_BuildSql(Users_Select, Users_Where, Users_GroupBy, Users_Having, Users_OrderBy, $sFilter, "");
		$rs = ckz_query($sSql, $conn) or die("Failed to execute query at line " . __LINE__ . ": " . ckz_error($conn) . '<br>SQL: ' . $sSql);
		if (ckz_num_rows($rs) > 0) {
			$row = ckz_fetch_array($rs);
				$sSql = "UPDATE `users`";
				$sSql .= " SET `pass` = '" . ckz_enc_pass($newpass) . "'";
				$sSql .= " WHERE `user` = '" . $sUsername . "'";
				ckz_query($sSql,$conn) or die("Failed to execute query at line " . __LINE__ . ": " . ckz_error($conn) . '<br>SQL: ' . $sSql);
				$sEmail = $row["email"];
				$bValidPwd = true;
				$bPwdUpdated = true;
		}
		ckz_free_result($rs);
		ckz_db_close($conn);


		// Load email content
		ckz_LoadEmail("txt/forget.txt");
		$sEmailFrom = str_replace("<!--\$From-->", $Email_Name,$sEmailFrom);
		$sEmailTo = str_replace("<!--\$To-->", $sEmail,$sEmailTo);
		$sEmailContent = str_replace("<!--\$Password-->", $newpass,$sEmailContent);
		$sEmailContent = str_replace("<!--user-->", $sUsername, $sEmailContent);

		// Send email
		ckz_Send_Email($sEmailFrom, $sEmailTo, $sEmailCc, $sEmailBcc, $sEmailSubject, $sEmailContent, $sEmailFormat);
		$_SESSION[ckzSessMessage] = $Translation["forget_01"];
		ob_end_clean();
		header("Location: login.php");
		exit();
	}
} else {
	$bValidEmail = true;
}
?>
<?php include "header.php" ?>
<script type="text/javascript">
<!--
function  CheckMyForm(This) {
if  (!Field_hasValue(This.email, "TEXT" )) {
	$.prompt('<?php echo $Translation["forget_07"]; ?>');
		return false;
}
if  (!Check_Email(This.email.value)) {
	$.prompt('<?php echo $Translation["forget_07"]; ?>');
		return false;
}
return true;
}

//-->
</script>
<p><?php echo $Translation["forget_02"]; ?><br/><br/><span class="red"><?php echo $Translation["forget_03"]; ?></span></p>
<?php if (!$bValidEmail) { ?>
<p><span class="red"><?php echo $Translation["forget_04"]; ?></span></p>
<?php } ?>
<form action="forget.php" method="post" onSubmit="return CheckMyForm(this);">
<table class="table2">
	<tr>
		<td><?php echo $Translation["forget_05"]; ?></td>
		<td><input type="text" name="email" value="<?php echo @$sEmail; ?>" size="30" maxlength="255" class="text" /></td>
	</tr>
</table>
<input type="submit" name="submit" value="<?php echo $Translation["forget_06"]; ?>" class="button" />
</form>
<br />
<?php include "footer.php" ?>
