<?php 
/******************************************************************************
* chart.php - Charts File                                                     *
*******************************************************************************
* phpCheckZ - The Easy Checklist Maker                                        *
* =========================================================================== *
* Software Version:           phpCheckZ 1.0.2                                 *
* Software by:                The RSWR Network (http://www.rswr.net)          *
* Copyright 2008 by:          Ryan Christenson (http://www.rswr.net)          *
* Support, News, Updates at:  http://www.phpcheckz.com/                       *
*******************************************************************************
* This program is free software; you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by        *
* the Free Software Foundation; either version 2 of the License, or           *
* (at your option) any later version.                                         *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* if not, write to the:                                                       *
* Free Software Foundation, Inc.                                              *
* 51 Franklin St - Fifth Floor, Boston, MA 02110-1301, USA                    *
******************************************************************************/
session_start();
ob_start();
?>
<?php include "constants.php" ?>
<?php include "db.php" ?>
<?php include "security.php" ?>
<?php include "functions.php" ?>
<?php include "language.php" ?>
<?php include "header.php" ?>
<?php
if (!ckz_IsLoggedIn() && (@$_COOKIE[CookieAutoLogin] == "autologin" && @$_COOKIE[CookiePassword] <> "")) {
	ob_end_clean();
	header("Location: login.php");
	exit();
}
ckz_LoadUserLevel();
$ckz_CurSec = (ckz_IsLoggedIn())? ckz_CurrentUserLevelPriv("listdata") : ckz_GetAnonymousPriv("listdata");	
if (($ckz_CurSec & ckz_Allow) <> ckz_Allow) {
	ob_end_clean();
	header("Location: login.php");
	exit();
}
if (ckz_IsLoggedIn() && ckz_CurrentUserID() == "") {
	ob_end_clean();
	header("Location: login.php");
	exit();
}
?>
<?php
$mysqli = new mysqli(HOST, USER, PASS, DB, PORT);

// Load key from QueryString
$x_id = @$_GET["id"];

/* Default Chart Amounts */
$a1 = 0;
$a2 = 0;
$a3 = 0;
$a4 = 0;
$a5 = 0;
$a6 = 0;

/* Grab List Info */
$result1 = $mysqli->query("SELECT `total`, `title`, `id` FROM `listcreate` WHERE `id` = '$x_id' ");
	$row1 = $result1->fetch_array(MYSQLI_ASSOC);
		$create_total = $row1["total"];
		$create_title = $row1["title"];

/* Grab Data Info */
$result2 = $mysqli->query("SELECT `percent` FROM `listdata` WHERE `listid` = '$x_id' ");
	while ($row2 = $result2->fetch_array(MYSQLI_ASSOC)) {
		$data_percent = $row2["percent"];
	
		/* Calculate Percentage */
		$count1 = $data_percent / $create_total;
		$count2 = $count1 * 100;
		$count = number_format($count2, 0);
		
		/* Tally up the Results */
		if ($count <= 20) {
			$a1 = $a1+1;
		}
		else if ($count >= 21 && $count <= 40) {
			$a2 = $a2+1;
		}
		else if ($count >= 41 && $count <= 60) {
			$a3 = $a3+1;
		}
		else if ($count >= 61 && $count <= 80) {
			$a4 = $a4+1;
		}
		else if ($count >= 81 && $count <= 99) {
			$a5 = $a5+1;
		}
		else if ($count == 100) {
			$a6 = $a6+1;
		}
}
?>
<?php
	include "scripts/libchart1.2.1/classes/libchart.php";

	$chart = new HorizontalBarChart(450, 350);

	$dataSet = new XYDataSet();
	$dataSet->addPoint(new Point("0%  - 20% " . $Translation["chart_01"], $a1));
	$dataSet->addPoint(new Point("21% - 40% " . $Translation["chart_01"], $a2));
	$dataSet->addPoint(new Point("41% - 60% " . $Translation["chart_01"], $a3));
	$dataSet->addPoint(new Point("61% - 80% " . $Translation["chart_01"], $a4));
	$dataSet->addPoint(new Point("81% - 99% " . $Translation["chart_01"], $a5));
	$dataSet->addPoint(new Point($Translation["chart_02"], $a6));
	$chart->setDataSet($dataSet);
	$chart->getPlot()->setGraphPadding(new Padding(5, 30, 20, 120));
$axis->min = 100;
	$chart->setTitle("$create_title");
	$chart->render("images/charts/$x_id.png");
?>
	<img alt="Horizontal bars chart"  src="images/charts/<?php echo $x_id ?>.png" class="chbo" />
<br /><br />
<?php echo $Translation["chart_03"] . $result2->num_rows . $Translation["chart_04"]; ?>
<?php $result1->close(); ?>
<?php $result2->close(); ?>
<?php include "footer.php" ?>
