<?php 
/******************************************************************************
* MyProfile.php                                                               *
* User Profile Page                                                           *
* See readme.txt for additional information                                   *
*******************************************************************************
* phpCheckZ - The Easy Checklist Maker                                        *
* Open-Source Project By Ryan Christenson (The RSWR Network)                  *
* =========================================================================== *
* Software Version:           phpCheckZ 1.0.2                                 *
* Software by:                The RSWR Network (http://www.rswr.net)          *
* Copyright 2008 by:          Ryan Christenson (http://www.rswr.net)          *
* Support, News, Updates at:  http://www.phpcheckz.com/                       *
*******************************************************************************
* This program is free software; you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by        *
* the Free Software Foundation; either version 2 of the License, or           *
* (at your option) any later version.                                         *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* if not, write to the:                                                       *
* Free Software Foundation, Inc.                                              *
* 51 Franklin St - Fifth Floor, Boston, MA 02110-1301, USA                    *
******************************************************************************/
session_start();
ob_start();
?>
<?php include "constants.php" ?>
<?php include "db.php" ?>
<?php include "security.php" ?>
<?php include "functions.php" ?>
<?php include "language.php" ?>
<?php
if (!ckz_IsLoggedIn() && (@$_COOKIE[CookieAutoLogin] == "autologin" && @$_COOKIE[CookiePassword] <> "")) {
	ob_end_clean();
	header("Location: login.php");
	exit();
}
ckz_LoadUserLevel();
$ckz_CurSec = (ckz_IsLoggedIn())? ckz_CurrentUserLevelPriv("listdata") : ckz_GetAnonymousPriv("listdata");	
if (($ckz_CurSec & ckz_Allow) <> ckz_Allow) {
	ob_end_clean();
	header("Location: login.php");
	exit();
}
if (ckz_IsLoggedIn() && ckz_CurrentUserID() == "") {
	ob_end_clean();
	header("Location: login.php");
	exit();
}
?>
<?php include "header.php" ?>
<?php
if (@$_SESSION[ckzSessMessage] <> "") {
?>
<p><div class="red"><?php echo $_SESSION[ckzSessMessage]; ?></div></p>
<?php
	$_SESSION[ckzSessMessage] = ""; // Clear message
}
?>
<!-- Legend -->
    <div class="legend">
    <span class="bold"><?php echo $Translation["profile_01"]; ?></span>
    <br />
    <br /><img src="images/check_red.gif" alt="Red Check" />&nbsp;<?php echo $Translation["profile_02"]; ?>
    <br /><img src="images/check_blue.gif" alt="Blue Check" />&nbsp;<?php echo $Translation["profile_03"]; ?>
    <br /><img src="images/check_green.gif" alt="Green Check" />&nbsp;<?php echo $Translation["profile_04"]; ?>
    </div>
<!-- Legend -->
<table>
  <tr>
    <td align="center"><div class="ap_menu"><a href="#"><img src="images/profile_checklists.gif" alt="Available Checklists" border="0" /></a></div></td>
    <td align="center"><div class="ap_menu"><a href="#"><img src="images/profile_charts.gif" alt="Charts and Graphs" border="0" /></div></td>
  </tr>
  <tr>
    <td valign="top">
    <br /><br />
<!-- Checklists Start -->
<div class="view">
<table width="100%">
<?php
$mysqli = new mysqli(HOST, USER, PASS, DB, PORT);
$user_name = ckz_CurrentUserName();

/* Grab List Info */
$result1 = $mysqli->query("SELECT `id`, `title`, `total` FROM `listcreate` WHERE `public` = 'Y' ORDER BY `title` ASC");
	while ($row1 = $result1->fetch_array(MYSQLI_ASSOC)) {
		$create_id = $row1["id"];
		$create_title = $row1["title"];
		$create_total = $row1["total"];

		/* Grab Data Info */
		$result2 = $mysqli->query("SELECT `id`, `listid`, `user`, `percent` FROM `listdata` WHERE `user` = '$user_name'  AND `listid` = '$create_id'");
			while ($row2 = $result2->fetch_array(MYSQLI_ASSOC)) {
				$data_id = $row2["id"];
				$data_listid = $row2["listid"];
				$data_user = $row2["user"];
				$data_percent = $row2["percent"];
				
			/* Calculate Percentage */
			$count1 = $data_percent / $create_total;
			$count2 = $count1 * 100;
			$count = number_format($count2, 0);
?>
<?php if ($data_listid == $create_id && $count != 100) { ?>
<tr>
<td class="prof"><a href="listdataedit.php?id=<?php echo $data_id ?>"><?php echo $create_title ?></a></td>
<td class="prof"><img src="images/check_blue.gif" alt="Blue Check" /></td>
</tr>
<?php } ?>
<?php if ($data_listid == $create_id && $count == 100) { ?>
<tr>
<td class="prof"><a href="listdataedit.php?id=<?php echo $data_id ?>"><?php echo $create_title ?></a></td>
<td class="prof"><img src="images/check_green.gif" alt="Green Check" /></td>
</tr>
<?php } ?>
<?php } ?>
<?php if ($data_listid != $create_id) { ?>
<tr>
<td class="prof"><a href="listdataadd.php?id=<?php echo $create_id ?>"><?php echo $create_title ?></a></td>
<td class="prof"><img src="images/check_red.gif" alt="Red Check" /></td>
</tr>
<?php } ?>
<?php } ?>
<?php $result1->close(); ?>
<?php $result2->close(); ?>
</table>
</div>
<!-- Checklists End -->
    </td>
    <td valign="top">
    <br /><br />
<?php
// Graphs/Chart On/Off
$result = $mysqli->query("SELECT * FROM `settings` WHERE `id` = '1' ");
	$row = $result->fetch_array(MYSQLI_ASSOC);

	// Row Data to Display
	$toggle = $row["graphs_toggle"];
?>
<?php if ($toggle == 1) { ?>
<!-- Charts Start -->
<div class="view">
<table width="100%">
<?php
$result = $mysqli->query("SELECT `id`, `title` FROM `listcreate` WHERE `public` = 'Y' ORDER BY `title` ASC");
	while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
?>
<tr>
<td class="prof"><a href="chart.php?id=<?php printf ("%s\n", $row["id"]); ?>">View Chart for <?php printf ("%s\n", $row["title"]); ?></a></td>
<td class="prof">&nbsp;</td>
</tr>
<?php } $result->close(); ?>
</table>
</div>
<!-- Charts End -->
<?php } else { ?>
Charts are currently turned off.
<?php } ?>
    </td>
  </tr>
</table>
<?php include "footer.php" ?>
