<?php
function create_header($config,$lang)
{
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/overall_header.html");
	$page->SetParameter('SITE_TITLE', $config['site_title']);
	$page->SetParameter('TPL_NAME', $config['tpl_name']);
	$page->SetParameter('SITE_URL', $config['site_url']);
	
	if(isset($_SESSION['user']['id']))
	{
		$page->SetParameter('LOGGED_IN', 1);
	}
	else
	{
		$page->SetParameter('LOGGED_IN', 0);
	}
	
	return $page->CreatePageReturn($lang,$config);
}

function create_footer($config,$lang)
{
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/overall_footer.html");
	$page->SetParameter('VERSION',$config['version']);
	return $page->CreatePageReturn($lang,$config);
}

function db_connect($config)
{
    $db_connection = @mysql_connect ($config['db']['host'], $config['db']['user'], $config['db']['pass']) OR error (mysql_error(), __LINE__, __FILE__, 0, '', '');
    $db_select = @mysql_select_db ($config['db']['name']) or error (mysql_error(), __LINE__, __FILE__, 0, '', '');
	
	return $db_connection;
}

function error($msg, $line='', $file='', $formatted=0,$lang=array(),$tpl_name='')
{
	if($formatted == 0)
	{
		echo "Low Level Error: " . $msg;
	}
	else
	{
		$page = new HtmlTemplate ("templates/" . $tpl_name . "/error.html");
		$page->SetParameter ('OVERALL_HEADER', create_header($lang,$tpl_name,'Error'));
		$page->SetParameter ('MESSAGE', $msg);
		$page->SetParameter ('OVERALL_FOOTER', create_footer($lang,$tpl_name));
		$page->CreatePageEcho($lang);
	}
	exit;
}

function logincheck()
{
	if(!isset($_SESSION['user']['id']))
	{
		header("Location: login.php");
		exit;
	}
}

function checkinstall($config)
{
	if(!isset($config['installed']))
	{
		header("Location: install/");
		exit;
	}
}

function getrandnum($length)
{
	$randstr=''; 
	srand((double)microtime()*1000000); 
	$chars = array ( 'a','b','C','D','e','f','G','h','i','J','k','L','m','N','o','P','Q','r','s','t','U','V','W','X','y','z','0','1','2','3','4','5','6','7','8','9'); 
	for ($rand = 0; $rand <= $length; $rand++) 
	{ 
		$random = rand(0, count($chars) -1); 
		$randstr .= $chars[$random]; 
	}
	
	return $randstr;
}

function validate_input($input,$dbcon=true,$content='all',$maxchars=0)
{
	if(get_magic_quotes_gpc()) 
	{
		if(ini_get('magic_quotes_sybase')) 
		{
			$input = str_replace("''", "'", $input);
		} 
		else 
		{
			$input = stripslashes($input);
		}
	}
	
	if($content == 'alnum')
	{
		$input = ereg_replace("[^a-zA-Z0-9]", '', $input);
	}
	elseif($content == 'num')
	{
		$input = ereg_replace("[^0-9]", '', $input);
	}
	elseif($content == 'alpha')
	{
		$input = ereg_replace("[^a-zA-Z]", '', $input);
	}
	
	if($maxchars)
	{
		$input = substr($input,0,$maxchars);
	}

	if($dbcon)
	{
		$input = mysql_real_escape_string($input);
	}
	else
	{
		$input = mysql_escape_string($input);
	}
	
	return $input;
}
?>