<?php

function test ($string, $test)
{
    echo $string . '... ';

    if ($test)
        echo "success.\n";
    else
        echo "fail.\n";
}

$token = "Testing GD!";

// Create image

$pic = ImageCreate (300, 300); 

test ('Creating image', $pic);

$col2 = ImageColorAllocate ($pic, 0, 0, 100); 
$col1 = ImageColorAllocate ($pic, 200, 200, 200); 

// Test PNG/JPG functionality

ob_start();
$res1 = @ImagePNG ($pic);
$res2 = @ImageJPEG ($pic);
ob_clean();

test ('Testing PNG output', $res1);
test ('Testing JPEG output', $res2);

// Test TrueType functionality

$ttfont = trim (`locate -n 1 .ttf`);

test ('Testing FreeType', @ImageTTFText 
    ($pic, 30, 0, 10, 40, $col1, $ttfont, $token));
test ('Testing FreeType2', @ImageFTText 
    ($pic, 30, 0, 10, 40, $col1, $ttfont, $token, array()));

// Test Type1 functionality

$font = @ImagePsLoadFont (trim (`locate -n 1 .pfb`));

if ($font)
    $res = @ImagePsText ($pic, $token, $font, 10, $col1, $col2, 0, 0);

test ('Testing the Type1 library', ($font && $res));

test ('Destroying image', ImageDestroy($pic)); 

?>
