<?
/****************************************************************

gmail-mobile (a.k.a. unofficial Gmail Mobile)
Copyright (c) 2005, 2006
Neerav Modi and others

Version 0.11 (c) 2004
GAN Ying Hung, Rudi Pittman, Gaston Annebicque

Licensed under the GNU GPL. For full terms see the file COPYING.

gmail-mobile (unofficial Gmail Mobile since Sept 2004) provides
access to Gmail accounts with any WAP enabled phone or hand held
(in WML format).

http://gmail-mobile.sourceforge.net

*****************************************************************/

/////////////////////////
//
// Define constants, default variables, 
// and basic repetitive
// tasks of gmail-mobile
//
/////////////////////////

// !!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT ALTER THIS FILE UNLESS YOU
// REALLY KNOW WHAT YOU ARE DOING!!
//
// Even then, there is no reason to edit
// this file ! ;-)
//
// !!!!!!!!!!!!!!!!!!!!!!

// version number
define("GMOB_VER",     "1.3.1");  

/////////////////////////
//
// error handling and logging
//

// turns html format off
ini_set('html_errors', false);		

// log, rather than display errors
ini_set('log_errors', true);		
ini_set('display_errors', false);

// log an error only once per script, rather than every instance
ini_set('ignore_repeated_errors', true);	

// define the error log file
/* error_log(syslog); */

// level of error reporting
error_reporting(E_ALL);

//
// END: error logging
//
/////////////////////////


/////////////////////////
//
// Other required files
// THESE ARE REQUIRED IN THIS ORDER
//

// Functions file
require_once("gmobile_functions.php");

// English language file
include("gmobile_lang.php");

//
// END: Other required files
//
/////////////////////////


/////////////////////////
//
// Define constants
//

if (isset($_SERVER['HTTP_USER_AGENT']) and ($_SERVER['HTTP_USER_AGENT'] != "")) { 
	define('USER_AGENT', $_SERVER['HTTP_USER_AGENT']);
} else { 
	define('USER_AGENT', "");
}

if (dirname($_SERVER['SCRIPT_NAME']) == "/")
{ 
	define('DIR_PATH', "");
} else { 
	define('DIR_PATH', dirname($_SERVER['SCRIPT_NAME']));
}

define('SELF', $_SERVER['SCRIPT_NAME']);
if(isset($_SERVER['HTTP_HOST'])) { 
	define('HOST', $_SERVER['HTTP_HOST']);
} else { 
	define('HOST', "");
}
if(isset($_SERVER['HTTP_ACCEPT'])) { 
	define('ACCEPT', $_SERVER['HTTP_ACCEPT']);
} else { 
	define('ACCEPT', "");
}



// proxy related
// uses the server, user and password defined in config.php
define("P_PROXY",   "$conf_proxy_server");	
define("P_USER",    "$conf_proxy_user");
define("P_PWD",     "$conf_proxy_passwd");

// Random string in urls
define("RANDOM",     "&amp;z=".str_rand(5));

// Shorter phpsession id name
@ini_set("session.name", "gmid");

// wap proxy / external links
define("WAP_PROXY_NONE",			0);
define("WAP_PROXY_DIRECT",			1);
define("WAP_PROXY_IYHY",			2);
define("WAP_PROXY_PHONIFIER_LOCAL",	3);
define("WAP_PROXY_PHONIFIER",		4);
define("WAP_PROXY_SKWEEZER",		5);
define("WAP_PROXY_GOOGLE",			6);
define("WAP_PROXY_GOOGLE_WML",		7);

/** for debugger **/
// debugging data file, should be in PHP for security reasons
$D_FILE = "debug.php"; 

// debugging mode. 0 => off, 1 => on
$D_ON = 0;               

//
// END: Define constants
//
/////////////////////////


/////////////////////////
//
// Define default settings
//

// use php sessions
$session_method = (GM_USE_PHPSESSION | !GM_USE_COOKIE);   

/* Use PIN code signin */
if ( 	(($conf_use_pin === true)
	 or ($conf_use_pin === false)
	 or ($conf_use_pin === 1)
	 or ($conf_use_pin === 0))
	 and !ini_get('safe_mode')
	) {
	$conf['use_pin'] = $conf_use_pin;
} else {
	$conf['use_pin'] = false;
}

// maximum message size before breaking it into parts
// uses $conf_display_msg_length defined in config.php
if ($conf_display_msg_length > 50000) {
	$conf['display_msg_length'] = 50000;
} elseif ($conf_display_msg_length == "") {
	$conf['display_msg_length'] = 2500;
} elseif ($conf_display_msg_length <= 0) {
	$conf['display_msg_length'] = 2500;
} elseif ($conf_display_msg_length < 1000) {
	$conf['display_msg_length'] = 1000;
} else {
	$conf['display_msg_length'] = $conf_display_msg_length;
}


// display x messages at a time in the mailbox
if ($conf_num_msgs > 50) {
	$conf['num_msgs'] = 50;
} elseif ($conf_num_msgs == "") {
	$conf['num_msgs'] = 10;
} elseif ($conf_num_msgs <= 0) {
	$conf['num_msgs'] = 10;
} else {
	$conf['num_msgs'] = $conf_num_msgs;
}

// Enable or disable file upload and attach
if ( 	($conf_enable_up_attach === true)
	 or ($conf_enable_up_attach === false)
	 or ($conf_enable_up_attach === 1)
	 or ($conf_enable_up_attach === 0)
	) {
	$conf['enable_attach'] = $conf_enable_up_attach;
} else {
	$conf['enable_attach'] = true;
}


// Maximum number of uploadable attachments
if ( 	 (is_numeric($conf_up_attach_num_limit))
	 and (is_int($conf_up_attach_num_limit))
	 and ($conf_up_attach_num_limit >= 0)
	 and ($conf_up_attach_num_limit <= 10)	 
	) {
	$conf['attach_up_number'] = $conf_up_attach_num_limit;
} else {
	$conf['attach_up_number'] = 3;
}

// Size limit for attachment upload from KB to bytes
if ( 	 (is_numeric($conf_up_attach_size_limit))
	 and (is_int($conf_up_attach_size_limit))
	 and ($conf_up_attach_size_limit > 0)
	) {
	$conf['attach_up_limit'] = $conf_up_attach_size_limit*1024;
} else {
	$conf['attach_up_limit'] = 10000000;
}

// Display message for a standard box as "Inbox (3)" [false]
// or "Inbox (3/126)" [true]
if ( 	($conf_disp_total_standard === true)
	 or ($conf_disp_total_standard === false)
	 or ($conf_disp_total_standard === 1)
	 or ($conf_disp_total_msgs === 0)
	) {
	$conf['disp_total_standard'] = $conf_disp_total_standard;
} else {
	$conf['disp_total_standard'] = false;
}

// Display message for a label as "MyLabel (3)" [false]
// or "MyLabel (3/126)" [true]
if ( 	($conf_disp_total_msgs === true)
	 or ($conf_disp_total_msgs === false)
	 or ($conf_disp_total_msgs === 1)
	 or ($conf_disp_total_msgs === 0)
	) {
	$conf['disp_total_msgs'] = $conf_disp_total_msgs;
} else {
	$conf['disp_total_msgs'] = false;
}


// sets the default way to display unread messages
// unread_bold is false which means 
// unread messages will display with an asterix (*)
if ( 	($conf_unread_bold === true)
	 or ($conf_unread_bold === false)
	 or ($conf_unread_bold === 1)
	 or ($conf_unread_bold === 0)
	) {
	$conf['unread_bold'] = $conf_unread_bold;
} else {
	$conf['unread_bold'] = false;
}


// set the default for view/download attachments
/* allow view/dl image attach */
if ( 	($conf_view_attach_image === true)
	 or ($conf_view_attach_image === false)
	 or ($conf_view_attach_image === 1)
	 or ($conf_view_attach_image === 0)
	) {
	$conf['view_attach_image'] = $conf_view_attach_image;
} else {
	$conf['view_attach_image'] = true;
}

/* allow dl audio attach */
if ( 	($conf_view_attach_audio === true)
	 or ($conf_view_attach_audio === false)
	 or ($conf_view_attach_audio === 1)
	 or ($conf_view_attach_audio === 0)
	) {
	$conf['view_attach_audio'] = $conf_view_attach_audio;
} else {
	$conf['view_attach_audio'] = true;
}

/* allow view html attach */
if ( 	($conf_view_attach_html === true)
	 or ($conf_view_attach_html === false)
	 or ($conf_view_attach_html === 1)
	 or ($conf_view_attach_html === 0)
	) {
	$conf['view_attach_html'] = $conf_view_attach_html;
} else {
	$conf['view_attach_html'] = true;
}

/* allow dl video attach */
if ( 	($conf_view_attach_video === true)
	 or ($conf_view_attach_video === false)
	 or ($conf_view_attach_video === 1)
	 or ($conf_view_attach_video === 0)
	) {
	$conf['view_attach_video'] = $conf_view_attach_video;
} else {
	$conf['view_attach_video'] = true;
}

/* allow dl theme attach */
if ( 	($conf_view_attach_theme === true)
	 or ($conf_view_attach_theme === false)
	 or ($conf_view_attach_theme === 1)
	 or ($conf_view_attach_theme === 0)
	) {
	$conf['view_attach_theme'] = $conf_view_attach_theme;
} else {
	$conf['view_attach_theme'] = true;
}

/* allow dl zip attach */
if ( 	($conf_view_attach_zip === true)
	 or ($conf_view_attach_zip === false)
	 or ($conf_view_attach_zip === 1)
	 or ($conf_view_attach_zip === 0)
	) {
	$conf['view_attach_zip'] = $conf_view_attach_zip;
} else {
	$conf['view_attach_zip'] = true;
}

/* allow dl sis attach */
if ( 	($conf_view_attach_sis === true)
	 or ($conf_view_attach_sis === false)
	 or ($conf_view_attach_sis === 1)
	 or ($conf_view_attach_sis === 0)
	) {
	$conf['view_attach_sis'] = $conf_view_attach_sis;
} else {
	$conf['view_attach_sis'] = true;
}

/* allow dl other attach */
if ( 	($conf_view_attach_other === true)
	 or ($conf_view_attach_other === false)
	 or ($conf_view_attach_other === 1)
	 or ($conf_view_attach_other === 0)
	) {
	$conf['view_attach_other'] = $conf_view_attach_other;
} else {
	$conf['view_attach_other'] = true;
}

// Size limit for attachments in Kilobytes
if ( 	 (is_numeric($conf_dl_attach_size_limit))
	 and (is_int($conf_dl_attach_size_limit))
	 and ($conf_dl_attach_size_limit >= 0)
	) {
	$conf['attach_size_limit'] = $conf_dl_attach_size_limit;
} else {
	$conf['attach_size_limit'] = 300;
}

// Links display behavior
if ( 	 (is_numeric($conf_links_display))
	 and (is_int($conf_links_display))
	 and ($conf_links_display > 0)
	 and ($conf_links_display <= 3)
	) {
	$conf['links_display'] = $conf_links_display;
} else {
	$conf['links_display'] = 3;
}

// Visibility of password
if ( 	($conf_visible_pass === true)
	 or ($conf_visible_pass === false)
	 or ($conf_visible_pass === 1)
	 or ($conf_visible_pass === 0)
	) {
	$conf['password_visible'] = $conf_visible_pass;
} else {
	$conf['password_visible'] = true;
}

// external links / wap proxy
if ( 	 (is_numeric($conf_external_links))
	 and (is_int($conf_external_links))
	 and ($conf_external_links >= 0)
	) {
	$conf['wap_proxy'] = $conf_external_links;
} else {
	$conf['wap_proxy'] = 0;
}

// Image display with wap proxy
if ( 	($conf_external_links_images === true)
	 or ($conf_external_links_images === false)
	 or ($conf_external_links_images === 1)
	 or ($conf_external_links_images === 0)
	) {
	$conf['wap_proxy_images'] = $conf_external_links_images;
} else {
	$conf['wap_proxy_images'] = false;
}

// autorefresh time for Summary page
if ( 	 (is_numeric($conf_autorefresh))
	 and ($conf_autorefresh >= 0)
	) {
	$conf['autorefresh'] = floor($conf_autorefresh * 60 * 10);
} else {
	$conf['autorefresh'] = 3000; /* 5*60*10 */
}

// Act on multiple messages
if ( 	($conf_act_on_multi === true)
	 or ($conf_act_on_multi === false)
	 or ($conf_act_on_multi === 1)
	 or ($conf_act_on_multi === 0)
	) {
	$conf['act_on_multi'] = $conf_act_on_multi;
} else {
	$conf['act_on_multi'] = true;
}

// temp directory
$GM_TEMP_DIR = "temp";
/* if (realpath($GM_TEMP_DIR)) { */
/* 	$conf['temp_dir'] = realpath($GM_TEMP_DIR); */
/* } elseif (!ini_get('safe_mode')) { */
/* 	if 	   (realpath(".".DIRECTORY_SEPARATOR."temp")) 	$GM_TEMP_DIR = realpath(".".DIRECTORY_SEPARATOR."temp"); */
/* 	elseif (realpath(".".DIRECTORY_SEPARATOR."tmp")) 	$GM_TEMP_DIR = realpath(".".DIRECTORY_SEPARATOR."tmp"); */
/* 	elseif (realpath(DIRECTORY_SEPARATOR."tmp")) 		$GM_TEMP_DIR = realpath(DIRECTORY_SEPARATOR."tmp").DIRECTORY_SEPARATOR."gmobile"; */
/* 	elseif (realpath(DIRECTORY_SEPARATOR."user".DIRECTORY_SEPARATOR."tmp")) 	 */
/* 														$GM_TEMP_DIR = realpath(DIRECTORY_SEPARATOR."user".DIRECTORY_SEPARATOR."tmp").DIRECTORY_SEPARATOR."gmobile"; */
/* 	elseif (realpath("C:\\temp")) 						$GM_TEMP_DIR = realpath("C:\\temp").DIRECTORY_SEPARATOR."gmobile"; */
/* 	else 							 					$GM_TEMP_DIR = "";	 */
/* 	 */
/* 	$conf['temp_dir'] = $GM_TEMP_DIR; */
/* } */

// if the temp dir doesn't exists, create and set restricted access
if (!file_exists($GM_TEMP_DIR)) {
	if (is_writable(".")) {
		$oldumask = umask(0);
		mkdir($GM_TEMP_DIR, 0770);
		umask($oldumask);
		if (!file_exists($GM_TEMP_DIR)) {
			die ("gmail-mobile setup error: Not able to create temporary directory.  Create a directory named '".$GM_TEMP_DIR."' in the '".basename(dirname($_SERVER['SCRIPT_NAME']))."' directory and give it full permissions (0777 - read/write/exec by all)");
		}
	} else {
		die ("gmail-mobile setup error: Temp directory not created due to lack of permissions.  Create a directory named '".$GM_TEMP_DIR."' in the '".basename(dirname($_SERVER['SCRIPT_NAME']))."' directory and give it full permissions (0777 - read/write/exec by all)");
/* 		die ("gmail-mobile setup error: Temp directory not writable.  Give the ".basename(dirname($_SERVER['SCRIPT_NAME'])).DIRECTORY_SEPARATOR.$GM_TEMP_DIR."' directory full permissions (0777 - read/write/exec by all)"); */
	}
}

// path to files in the temp dir
$conf['temp_dir'] = $GM_TEMP_DIR . DIRECTORY_SEPARATOR;

if ($conf['temp_dir'] == "t" or $conf['temp_dir'] == "t".DIRECTORY_SEPARATOR) exit; 

// write a dummy index file to prevent the web server from accessing the temp dir
if (!(file_exists($conf['temp_dir']."index.php"))) {
	if (!($fd = @fopen($conf['temp_dir']."index.php", "w"))) {
		$oldumask = umask(0);
		chmod($GM_TEMP_DIR,0777);
		umask($oldumask);
		die ("gmail-mobile setup error: Safe-mode restriction.  Create a blank index.php file in the '".basename(dirname($_SERVER['SCRIPT_NAME'])).DIRECTORY_SEPARATOR."$GM_TEMP_DIR' directory");
	}
	fopen($conf['temp_dir']."index.php", "w");
	fwrite($fd, "<? echo 'Directory listing is not allowed'; ?".">\n");
	fclose($fd);
}
//debug_print('temp_dir: '.$GM_TEMP_DIR." : ".realpath($GM_TEMP_DIR)." : ".$conf['temp_dir']);

$STANDARD_MAILBOX_NAMES = array("Inbox","Starred","Chats","Sent","Drafts","All","Spam","Trash");


// END: Define default settings
//
/////////////////////////

/////////////////////////
//
// Define more contstants
//

//ini_set('session.gc_maxlifetime', 3600);
//ini_set('session.gc_probability', 10);
//session_save_path($conf['temp_dir']);
//ini_set('url_rewriter.tags', "");	
//set_error_handler('gmobileErrorHandler');

// END: Define more contstants
//
/////////////////////////



// Define an error handler
function gmobileErrorHandler($error_level, $error_message, $error_file, $error_line, $context) {

	$context_copy = $context;

	if (isset($context_copy['gm_lang'])) 			unset($context_copy['gm_lang']);
	if (isset($context_copy['HTTP_SESSION_VARS'])) 	unset($context_copy['HTTP_SESSION_VARS']);
	if (isset($context_copy['HTTP_POST_VARS'])) 	unset($context_copy['HTTP_POST_VARS']);
	if (isset($context_copy['HTTP_GET_VARS'])) 		unset($context_copy['HTTP_GET_VARS']);
	if (isset($context_copy['HTTP_COOKIE_VARS'])) 	unset($context_copy['HTTP_COOKIE_VARS']);
	if (isset($context_copy['HTTP_SERVER_VARS'])) 	unset($context_copy['HTTP_SERVER_VARS']);
	if (isset($context_copy['HTTP_ENV_VARS'])) 		unset($context_copy['HTTP_ENV_VARS']);
	if (isset($context_copy['HTTP_POST_FILES'])) 	unset($context_copy['HTTP_POST_FILES']);

	// timestamp for the error entry
	$date = date("Y-m-d H:i:s O");

	// define array of error strings
	$error_type = array (
		E_WARNING			 => "Warning",
		E_NOTICE			 => "Notice",
		E_USER_ERROR		 => "User Error",
		E_USER_WARNING		 => "User Warning",
		E_USER_NOTICE		 => "User Notice"
	);

	if (error_reporting() == 0) {
		if ($error_message == "session_destroy(): Session object destruction failed") return;
		if (basename($error_file) == "compose.php" and $error_line > 1270) return; 
		//[06-Jan-2006 18:55:58] PHP Warning:  main(gmobile_env.php): failed to open stream: No such file or directory in config.php on line 372
		$date = date("d-M-Y H:i:s O");
/* 		error_log("[".$date."] PHP ".$error_type[$error_level].": \t".$error_message." in ".$error_file." on line ".$error_line."\n", 3, "error_log.system"); */
		error_log("[".$date."] \n\tPHP ".$error_type[$error_level]."\n\t".$error_message."\n\t".basename($error_file).": ".$error_line."\n", 3, "error_log.system");
		return;
	}

	global $displayed_errors;
	
	if (!isset($displayed_errors)) $displayed_errors = array();
	
	$file_line = basename($error_file).": ".$error_line;
	
	if (in_array("$file_line: $error_message",$displayed_errors)) {
		return;
	} else {
		$displayed_errors[] = $file_line.": ".$error_message;
	}
	
/* 	// set of errors for which a var trace will be saved */
/* 	$user_errors = array(E_USER_ERROR, E_USER_WARNING, E_USER_NOTICE); */
	
	$message = "";	
	$message .= $date."\n";
	$message .= "------------------\n";
	$message .= "\t".$error_type[$error_level]."\n";
	$message .= "\t".$file_line."\n";
	$message .= "\t".$error_message."\n";

/* 	if (in_array($error_level, $user_errors)) { */
/* 	   $err .= "\t<vartrace>" . wddx_serialize_value($context, "Variables") . "</vartrace>\n"; */
/* 	} */
/* 	$message .= "</errorentry>\n\n"; */

	if ($error_message == "session_start(): The session id contains invalid characters, valid characters are only a-z, A-Z and 0-9") {
		if (!defined('CONTEXT_DUMPED')) define('CONTEXT_DUMPED', true);
		$message .= "\t_ENV/_SERVER dump: ".print_r($_ENV,true)."\n".print_r($_REQUEST,true)."\n";
		error_reporting(0);
	}

	if (!defined('CONTEXT_DUMPED')) {
		$dump = (isset($context)) ? "\tDump context: ".str_replace("    ", "\t",print_r($context_copy, true))."\n" : "" ;
		$message .= $dump;
		define('CONTEXT_DUMPED', true);
/* 		global $gmailer; */
/* 		global $snapshot; */
/* 		$message = $message.".....................\nRaw data dump: ".print_r($gmailer->dump_raw(),true)."\n"; */
/* 		if (isset($snapshot) and $snapshot != "") { */
/* 			$message = $message.".....................\nSnapshot dump: ".print_r($snapshot,true)."\n"; */
/* 		} */
/* 		$message = $message.".....................\nSession dump: ".print_r($_SESSION,true)."\n"; */
	}
	$message .= "****************************************\n";

	// save to the error log
	error_log($message, 3, "error_log.gmobile");

	switch ($error_level) {
		case E_USER_ERROR:
			exit(1);
			break;
	}

}

?>
