<?PHP
# ========================================================================== #
#           IRSIM - Invisionix Roaming System Instant Messenger              #
# ========================================================================== #
#                                                                            #
#  Copyright (c) 2004 by Invisionix Systems                                  #
#     http://www.invisionix.org                                              #
#                                                                            #
#  This file is part of the IRSIM.                                           #
#  IRSIM is free software; you can redistribute it and/or modify it          #
#     under the terms of the GNU Lesser General Public License as            #
#     published by the Free Software Foundation; Latest version.             #
# IRSIM is distributed in the hope that it will be useful,                   #
#     but WITHOUT ANY WARRANTY; without even the implied                     #
#    warranty of MERCHANTABILITY or FITNESS FOR A                            #
#    PARTICULAR PURPOSE. See the GNU Lesser General Public                   #
#    License for more details.                                               #
#  You should have received a copy of the GNU Lesser General Public          #
#     License along with IRSIM (see license.txt); if not, write to the Free  #
#     Software Foundation Inc,59 Temple Place,Suite 330,Boston,MA 02111,USA  #
#     Copy of full license is in file "license.txt, and on the net at:       #
#            http://www.opensource.org/licenses/lgpl-license.php             #
# ========================================================================== #
#                                                                            #

# #######################################
#
#  This file contains the IRSR site's
#  global PROGRAM initialization values.
#
# #######################################

// ////////////////////////// //
//  Include data needed from  //
//  global system settings.   //
// ////////////////////////// //
//
$globalIncludeFilePath = @dirname(__FILE__)."/site.inc.php";	// Path to the system's global include file - Unix.
require_once	($globalIncludeFilePath);			// System's global include file.


// =================================================================================

// /////////////////////////////// //
//  The specific program related   //
//  settings section starts here.  //
// /////////////////////////////// //
//  NOTE: Use the section below to
//  set a program's absolute
//  initialization and configuration
//  values when you need these
//  variables to be used on a
//  site "global" basis.
//

$_prog_irsimJabSrvrFileLoc = @dirname(__FILE__)."/jabber-servers.inc.php";	// Location of the IRSIM's Jabber Servers description file.
$_prog_irsimIdent = "IRSIM";					// The IRSIM program's identity label.
$_prog_irsim_minutesUp = 60;					// Minutes connection, maximum (in one time.)
$_prog_irsimJabberAdmin = "YourJabberAdminAccountNameHere";	// IRSIM jabber Admin name.
$_prog_irsimWinWidth =  '200';					// IRSIM primary window's pixel width.
$_prog_irsimWinHeight = '275';					// IRSIM primary window's pixel height.
$irsimDefaultHostLabel = "zim";					// IRSIM DEFAULT Jabber server name (defined in array "$_prog_irsimSrv")..
//
$irsimJabAcct1 = "YourMainPersonalIMaccountNameHere";		// IRSIM "main" jabber server account name 1 (IRSIMguest is ok, but should be changed.)
$irsimJabAcct2 = "someSecondAccountNameHere";			// IRSIM "secondary" jabber server account name 2.
$irsimJabAcct1pass = $_sysDBuser1LoginPass;			// IRSIM account 1 password.
$irsimJabAcct2pass = $_sysDBuser1LoginPass;			// IRSIM account 2 password.
//
$_prog_irsimResource = "InvisionixIRSIM";			// IM account Jaber resource name.
$_prog_irsimPort = 5222;					// IM server port number using.
$_prog_irsimDEBUG = FALSE;					// IRSIM debug mode on/off switch.
$_prog_irsimLogswitch = FALSE;					// IM transaction logging on/off switch.
$_prog_irsimFilename = 'logfile.txt';				// IM transaction logging file name.
$_prog_irsimDEFAULTusername = $irsimJabAcct1;			// IRSIM DEFAULT account name  on jabber servers.
$_prog_irsimDEFAULTuserPass = $irsimJabAcct1pass;		// IRSIM DEFAULT account password on jabber servers.
$_prog_irsimDEFAULTsrvr = $irsimDefaultHostLabel;		// IRSIM DEFAULT Jabber server name (defined in array "$_prog_irsimSrv")..

// =================================================================================

// /////////////////////////////// //
//  The specific program related   //
//  settings section starts here.  //
// /////////////////////////////// //
//  NOTE: There is little need to
//  make changes in the area below
//  unless you are adding a new
//  program to the IRSR and wish
//  to set its initialization and
//  configuration values globally.
//

//
// IRSIM program (irsim_).
//
//
require "$_prog_irsimJabSrvrFileLoc";			// The jabber servers' list and definitions.
//
$irsim_host = $_sysDBhost1;				// DB host name
$irsim_db = $_sysDBname;				// Database name.
$irsim_user = $_sysDBuser1Login;			// DB user name.
$irsim_pass = $_sysDBuser1LoginPass;			// DB user password.
//
$irsim_server = $_prog_irsimJabberServer;		// IM Jabber server name.
$irsim_port = $_prog_irsimPort;				// IM server port number using.
$irsim_username = $_prog_irsimDEFAULTusername;		// IRSIM DEFAULT account name.
$irsim_password	= $_prog_irsimDEFAULTuserPass;		// IRSIM DEFAULT account password.
$irsim_resource	= $_prog_irsimResource;			// IM account Jaber resource name.
$irsim_logswitch = $_prog_irsimLogswitch;		// ????? IM transaction logging on/off switch.
$irsim_filename = $_prog_irsimFilename;			// ???? IM transaction logging file name.



?>