<?PHP
# ========================================================================== #
#           IRSIM - Invisionix Roaming System Instant Messenger              #
# ========================================================================== #
#                                                                            #
#  Copyright (c) 2004 by Invisionix Systems                                  #
#     http://www.invisionix.org                                              #
#                                                                            #
#  This file is part of the IRSIM.                                           #
#  IRSIM is free software; you can redistribute it and/or modify it          #
#     under the terms of the GNU Lesser General Public License as            #
#     published by the Free Software Foundation; Latest version.             #
# IRSIM is distributed in the hope that it will be useful,                   #
#     but WITHOUT ANY WARRANTY; without even the implied                     #
#    warranty of MERCHANTABILITY or FITNESS FOR A                            #
#    PARTICULAR PURPOSE. See the GNU Lesser General Public                   #
#    License for more details.                                               #
#  You should have received a copy of the GNU Lesser General Public          #
#     License along with IRSIM (see license.txt); if not, write to the Free  #
#     Software Foundation Inc,59 Temple Place,Suite 330,Boston,MA 02111,USA  #
#     Copy of full license is in file "license.txt, and on the net at:       #
#            http://www.opensource.org/licenses/lgpl-license.php             #
# ========================================================================== #
#                                                                            #

//
// Perform IRSR system page header functions here.
//
$globalProgsFilePath = @dirname(__FILE__)."/programs.inc.php";	// Path to the system's global programs include file - Unix.
//$globalProgsFilePath = @dirname(__FILE__)."\programs.inc.php"; // Path to the system's global programs include file - Windows.
require_once	($globalProgsFilePath);						// System's global programs include file.

require_once 'irsim.inc.php';			// The IRSIM-Jabber routines.
include("mysql.php");
global $JABBER;					// The Jabber primary data structure pointer.

$theMessageFromMe = '';				// Init the buffer for sending messages out via the Chat Message Handler.
$numInMinute = 12;				// Cruise control's number of "$timeUp"s (below) in a minute..
$maxLoopTimes = ($_prog_irsim_minutesUp * $numInMinute);	// Cruise control's maximum loop time.
$timeUp = 5;					// Cruise control seconds timer.


function processEmotIcons($theMsg) {		// Translate EmotIcons into images.

	$retMsg = eregi_replace (";)", "<IMG SRC=\"img/smi.gif\">", $theMsg);
	$retMsg = eregi_replace (':)', "<IMG SRC=\"img/sad.gif\">", $theMsg);
	$retMsg = eregi_replace (':P', "<IMG SRC=\"img/ang.gif\">", $theMsg);
	$retMsg = eregi_replace (';P', "<IMG SRC=\"img/win.gif\">", $theMsg);
	$retMsg = eregi_replace (':q', "<IMG SRC=\"img/coo.gif\">", $theMsg);
	$retMsg = eregi_replace (';q', "<IMG SRC=\"img/ide.gif\">", $theMsg);
	$retMsg = eregi_replace (':o', "<IMG SRC=\"img/que.gif\">", $theMsg);
	$retMsg = eregi_replace (':!', "<IMG SRC=\"img/sur.gif\">", $theMsg);
	$retMsg = eregi_replace (':l', "<IMG SRC=\"img/tup.gif\">", $theMsg);

	return $retMsg;
}

function isStr_Hebrew($string) {		// Is the message in Hebrew?

	$cnt = 0;				// Hebrew character counter.
	$array = preg_split('//',$string,-1,PREG_SPLIT_NO_EMPTY);	// Break up the string into an array of characters.
	foreach ($array as $VAL)		// For each character in the array.
		{				// Count the number of Hebrew characters.
			if ($VAL >= "&#1488" && $VAL <= "&#1514") $cnt++; // Count Hebrew characters only.
			if ( $cnt > 10 ) return true;			// Stop counting at 10 characters.		
		}
	if ( $cnt > 0 ) return true;		// At least one character is Hebrew.

	return false;	// There are no Hebrew characters in the string.
}

function processLanguages($str) {	

	$strng = $str;
	if (isStr_Hebrew($strng)) {				// Is the message in Hebrew?
		$strng = str_replace("\\n","n\\",$strng);	// Prepare newlines for reversal.
		$strng = str_replace("<br>",">rb<",$strng);	// Prepare "breaks" for reversal.
		$strng = strrev(hebrevc($strng)); 	 	// Convert to visual-Hebrew characters and reverse the message's character order.
	} else {						// Handle the possiblity that it's UTF-8 format of Hebrew characters.
		if (iconv('UTF-8', 'UTF-8', $strng) != $strng) { // It's not UTF-8?
			return $strng;
		} else {					// It's UTF-8.
			$strng = utf8_decode($strng);		// Convert from UTF-8.
			if (isStr_Hebrew($strng)) {		// Is the message in Hebrew?
				$strng = str_replace("\\n","n\\",$strng);	// Prepare newlines for reversal.
				$strng = str_replace("<br>",">rb<",$strng);	// Prepare "breaks" for reversal.
				$strng = strrev(hebrevc($strng)); 	 	// Convert to visual-Hebrew characters and reverse the message's character order.
			}
		}
	}

	return $strng;
}

function processSendingRemoteMsgs() {		// Handle remote message sending.
	global  $link, $username, $theMessageFromMe;
	global $JABBER, $msgFrom, $msgType;

	$query="select message, buddy from chat_data where msgType='remote' order by id asc";
	$result=mysql_query($query, $link);
	$num_rows=mysql_num_rows($result);
	while ($fresult=mysql_fetch_array($result)) {
		$query2="select username, onlineReporter from chat_users where username='$fresult[1]' ";
		$result2=mysql_query($query2, $link);
		$num_rows2=mysql_num_rows($result2);
		if ($num_rows2 > 1) {				// Multiple "online user" reporters found.
			print "More than 1 username found in chat_users table. Figure out why.";
			while ($fresult2=mysql_fetch_array($result2)) { print"$fresult2[0]<br>"; }
		} else if ($num_rows2 == 1) {					// Found one "remote buddy online" reporter, as expected.
				$fresult2 = mysql_fetch_array($result2);
				if ($fresult2[1] == $username) {		// Local user sending to remote buddy.
					$theMessageFromMe = utf8_encode($fresult[0]);	// Buffer the message, to be sent by the Jabber Chat/Message Handler.
					$msgTo = $fresult[1];
					$JABBER->SendMessage($msgTo, 'chat', NULL, array("body" => $theMessageFromMe)); // Send the message to buddy.
					$query3="update chat_data set msgType='sentRemote' where msgType='remote' and buddy='$fresult2[0]' and message='$fresult[0]' ";
					$result3=mysql_query($query3, $link);	// Mark the sent message as "sentRemote".
				}
			}
	}
}

function processOnlineRemoteBuddy($theMsg,$remoteBud) {	// Process remote buddies online/offline/disconnect.
	global $onlineMSGpreamble, $onlineMSGpostamble;
	global $offlineMSGpreamble, $offlineMSGpostamble;
	global $disconMSGpreamble, $disconMSGpostamble ;
	global $username, $link, $_prog_irsimDEBUG;

	$retMsg = $theMsg;				// As default, return the original message.
	if ($remoteBud != "IRSIM") return $retMsg;	// Only handle IRSIM program generated messages here.

	$onPos1 = strpos($theMsg, $onlineMSGpreamble);	// Locate the "online" preamble in the message.
	$onPos2 = strpos($theMsg, $onlineMSGpostamble);	// Locate the "online" postamble in the message.
	if (($onPos1 !== false) && ($onPos2 !== false)) {	// Is the "online from remote location" identifier in the message?
		$theContact = str_replace($onlineMSGpostamble, '', str_replace($onlineMSGpreamble, '', $theMsg));
		$query="update chat_users  set status='online', onlineReporter='$username'  where username='$theContact' "; // Switch buddy to "online" and designate in local table who reported the remote "online".
		$result= mysql_query($query, $link);
		if ($_prog_irsimDEBUG == FALSE) $retMsg = '';	// If not in debug mode erase the message so the user doesn't see it.
	}

	$offPos1 = strpos($theMsg, $offlineMSGpreamble);  // Locate the "offline" preamble in the message.
	$offPos2 = strpos($theMsg, $offlineMSGpostamble); // Locate the "offline" postamble in the message.
	if (($offPos1 !== false) && ($offPos2 !== false)) {	// Is the "online from remote location" identifier in the message?
		$theContact = str_replace($offlineMSGpostamble, '', str_replace($offlineMSGpreamble, '', $theMsg));
		$query="update chat_users  set status='offline', onlineReporter=''  where username='$theContact' "; // Set buddy to "offline".
		$result= mysql_query($query, $link);
		if ($_prog_irsimDEBUG == FALSE) $retMsg = '';	// If not in debug mode erase the message so the user doesn't see it.
	}

	$disPos1 = strpos($theMsg, $disconMSGpreamble);	// Locate the "disconnect" preamble in the message.
	$disPos2 = strpos($theMsg, $disconMSGpostamble);	// Locate the "disconnect" postamble in the message.
	if (($disPos1 !== false) && ($disPos2 !== false)) {	// Is the "online from remote location" identifier in the message?
		$query="update chat_users  set status='offline', onlineReporter=''  where onlineReporter!='' "; // On disconnection, switch all the buddies OFF.
		$result= mysql_query($query, $link);
		$retMsg = $theMsg;				// Always show a "disconnect" message.
	}

	return $retMsg;					// It was an "IRSIM" sent message.
}

function processTheMessage($aMsg,$fromBud) {		// All message pre-display processing is done here.
	global $link;

	$aMsg = processOnlineRemoteBuddy($aMsg,$fromBud);	// Check if its an IRSIM "ONLINE/OFFLINE/DISCONNECT" message and if so process it.

	$aMsg = processLanguages($aMsg);			// Language-particular processing.

	$aMsg = str_replace ( "<br>",  "||br||", $aMsg);	// Hide "<br>"s.
	$aMsg = str_replace ( "<",  " ", $aMsg);		// Remove tag elementdesignator.
	$aMsg = str_replace ( ">",  " ", $aMsg);		// Remove tag element designator.
	$aMsg = str_replace ( "||br||",  "<br>", $aMsg);	// Restore "<br>"s.
	$aMsg = str_replace ( "\n", "||n", $aMsg);		// Hide "\n"s.
	$aMsg = stripslashes ($aMsg);				// Remove all slashes.
	$aMsg = str_replace ( "||n", "\n", $aMsg);		// Restore "\n"s.
	$aMsg = str_replace ( " ", " ", $aMsg);
	$aMsg = addslashes ($aMsg);				// Escape quotes before inserting into DB.
//ir	$aMsg = processEmotIcons($aMsg);			// Translate EmotIcons into images.

	return $aMsg;
}

function displayTheMessage($aMessage,$fromWhom) {	// Display the message in the IM window by placing it into the DB buffer.
	global  $username, $link;

	$theMsg = processTheMessage($aMessage, $fromWhom); // Prior to inserting the message into the display buffer, process it.

	$query="insert into chat_data set sender='$fromWhom',  buddy='$username', message='$theMsg' ";
	$result=mysql_query($query, $link);
}


# ###################### #
#			 #
#	- Main -	 #
#			 #
# ###################### #
#			 #

//
// Connect the Jabber account to the net via the Jabber server.
//
if ($username == $JABBER->username) {		// Does the local account have a Jabber counterpart?
	$JABBER->Connect() or die("Couldn't connect to the Jabber server!");
	$JABBER->SendAuth() or die("Couldn't authenticate the Jabber connection!");
	$JABBER->SendPresence();		// Notify the world that I am alive.
	for ($ii=0; $ii<30; $ii++) {		// Wait until connection is established.
		if($JABBER->connected) break; 	// Wait till we're "online" with Jabber server.
		else sleep(1);			// Still not connected to Jabber server.
	}
	$JABBER->connected or die ("Failed connecting to Jabber server.");

	print "<script>parent.onlineFrame.location.href=\"online.php?user=$username\";</script>\n"; // Refresh the contact list frame.
	print "<script>parent.dialogFrame.location.href=\"dialog.php?username=$username&alreadyDown=false\";</script>\n"; // Refresh the dialog frame.
}

//
// Do the Jabber interactions processing.
//
for ($ii=1; $ii<=$maxLoopTimes; $ii++) {
	if ( ($shutdown == 'true') && ($JABBER->connected) ) {	// Was this file invoked with a "shutdown" command from the dialog frame?
		print "<script>parent.dialogFrame.location.href=\"dialog.php?username=$username&alreadyDown=true\";</script>\n"; // Refresh the dialog frame.
		processJabCleanup();		// Cleanup processing.
		break;				// Get out of the loop.
	} elseif ( ($username == $JABBER->username) && ($JABBER->connected) ){	// Does the local account have a Jabber counterpart?
			$JABBER->CruiseControl($timeUp); // Keep the connection up for "timeUp".
			processSendingRemoteMsgs();	// If there is a remote message to send, do it.
		}
	$shutdown = 'false';			// Toggle the shutdown flag.
}

for ($ii=0; $ii<10; $ii++) {			// Attempt to disconnect 10 more times before giving up.
	if($JABBER->connected) {		// Is the Jabber server connection still up?
 		sleep(2);			// Wait 2 seconds.
		$JabberprocessJabCleanup();	// Cleanup processing, if still connected.
	} else {				// Finish, and get out of loop when disconnection occurs.
		print "<script>parent.onlineFrame.location.href=\"online.php?user=$username\";</script>\n"; // Refresh the contact list frame.
		//ir print "<script>self.window.close();</script>\n";	// Close all frames and this window.
		break;
	}
}


?>

