<?PHP
# ========================================================================== #
#           IRSIM - Invisionix Roaming System Instant Messenger              #
# ========================================================================== #
#                                                                            #
#  Copyright (c) 2004 by Invisionix Systems                                  #
#     http://www.invisionix.org                                              #
#                                                                            #
#  This file is part of the IRSIM.                                           #
#  IRSIM is free software; you can redistribute it and/or modify it          #
#     under the terms of the GNU Lesser General Public License as            #
#     published by the Free Software Foundation; Latest version.             #
# IRSIM is distributed in the hope that it will be useful,                   #
#     but WITHOUT ANY WARRANTY; without even the implied                     #
#    warranty of MERCHANTABILITY or FITNESS FOR A                            #
#    PARTICULAR PURPOSE. See the GNU Lesser General Public                   #
#    License for more details.                                               #
#  You should have received a copy of the GNU Lesser General Public          #
#     License along with IRSIM (see license.txt); if not, write to the Free  #
#     Software Foundation Inc,59 Temple Place,Suite 330,Boston,MA 02111,USA  #
#     Copy of full license is in file "license.txt, and on the net at:       #
#            http://www.opensource.org/licenses/lgpl-license.php             #
# ========================================================================== #
#                                                                            #

require_once 'class.jabber.php';		// The Jabber interface classes.

$onlineMSGpreamble ="** ONLINE: ";		// Preamble for the "online" message.
$onlineMSGpostamble = " **";			// Postamble for the "online" message.
$offlineMSGpreamble = "** OFFLINE: ";		// Preamble for the "offline" message.
$offlineMSGpostamble = " **";			// Postamble for the "offline" message.
$disconMSGpreamble = "** DISCONNECTED ";	// Preamble for the "disconnected" message.
$disconMSGpostamble = " **";			// Postamble for the "disconnected" message.

$JABBER = new Jabber;		// Instantiate class Jabber.

$JABBER->server		= $irsim_server;	// IM server name
$JABBER->port		= $irsim_port;		// IM server port number using.
$JABBER->username	= $irsim_username;	// IM account name.
$JABBER->password	= $irsim_password;	// IM account password.
$JABBER->resource	= $irsim_resource;	// IM account Jaber resource name.
$JABBER->enable_logging = $irsim_logswitch;	// IM transaction logging on/off switch.
$JABBER->log_filename   = $irsim_filename;	// IM transaction logging file name.

$progIdent = $_prog_irsimIdent;			// The IRSIM program's identity label.

function Handler_presence_available($message){	// Returns output.
	global $JABBER, $onlineMSGpreamble, $onlineMSGpostamble;

	$fullAddrFrom = $JABBER->GetInfoFromPresenceFrom($message);
	$onlineMSG = $onlineMSGpreamble . $fullAddrFrom . $onlineMSGpostamble;

	pipeMsgToMe($onlineMSG);		// Send the message to my desired destination.
}

function Handler_presence_unavailable($message){	// Returns output.
	global $JABBER, $offlineMSGpreamble, $offlineMSGpostamble;

	$jid = $JABBER->StripJID($JABBER->GetInfoFromPresenceFrom($message));
	$offlineMSG = $offlineMSGpreamble . $jid . $offlineMSGpostamble;
	pipeMsgToMe($offlineMSG);		// Send the message to my desired destination.
}

function disconnectIM(){	// Disconnect the transport/contact links -- Returns output..
	global $JABBER, $disconMSGpreamble, $disconMSGpostamble ;

	$JABBER->Disconnect();
	$disconMSG = $disconMSGpreamble . "from the Jabber Server !" . $disconMSGpostamble;
	pipeMsgToMe($disconMSG);		// Send the message to my desired destination.
	exit;
}

function Connected_already() {	 	 	// Check if we are already connected to the net.
	if ($this->_check_connected()) {
		$this->connected = TRUE;	// Already connected.?
		return TRUE;		  	// Yes.
	} else {
		return FALSE;		  	// Not connected.
	}
}


function Handler_message_chat($message) {	// Handle a chat message.
	global $JABBER, $_prog_irsimJabberAdmin, $_prog_irsimJabberServer;
//ir	global $theMessageFromMe;
	global $msgFrom, $msgBody, $msgType, $msgErr, $msgID;

	$msgFrom = $JABBER->GetInfoFromMessageFrom($message);
	$msgBody = $JABBER->GetInfoFromMessageBody($message);
	$msgType = $JABBER->GetInfoFromMessageType($message);
	$msgErr = $JABBER->GetInfoFromMessageError($message);
	$msgID = $JABBER->GetInfoFromMessageId($message);

	$matchExpr = "/^".$_prog_irsimJabberAdmin."@".$_prog_irsimJabberServer."/i";
	$matchShutSelf = "/^".$JABBER->username."@".$JABBER->server."/i";
	if ( ($msgBody == "go2sleep") && (preg_match($matchExpr, $msgFrom) || preg_match($matchShutSelf, $msgFrom)) ) {	// Command from remote buddy (or self) to shut this IM client down.
		$remotelyShutdownMSG ="** Remote SHUTDOWN command sent by: " . $msgFrom. " **";
		pipeMsgToMe($remotelyShutdownMSG);	// Send the message to my desired destination.
		processJabCleanup();			// Shutdown this IM.
	}

	if ($msgBody != '') {			// Receive message from remote buddy.
		displayTheMessage($msgBody,$msgFrom);	// Display the message in the IM window.
	}

//ir	if ($theMessageFromMe != "") {		// Send message in buffer "$theMessageFromMe" to remote buddy, only when we receive a message first.
//ir		$JABBER->SendMessage($msgFrom, $msgType, NULL, array("body" => $theMessageFromMe));
//ir		$theMessageFromMe = "";		// Empty out the buffer afer sending its contents.
//ir	}

}

function Handler_message_normal($message) {	// Handle an e-mail message.
	global $JABBER, $_prog_irsimJabberAdmin, $_prog_irsimJabberServer;

	$msgFrom = $JABBER->GetInfoFromMessageFrom($message);
	$msgSubject = $JABBER->GetInfoFromMessageSubject($message);
	$msgBody = $JABBER->GetInfoFromMessageBody($message);
	$msgType = $JABBER->GetInfoFromMessageType($message);
	$msgErr = $JABBER->GetInfoFromMessageError($message);
	$msgThread = $JABBER->GetInfoFromMessageThread($message);
	$msgID = $JABBER->GetInfoFromMessageId($message);

	$matchExpr = "/^".$_prog_irsimJabberAdmin."@".$_prog_irsimJabberServer."/i";
	if ((($msgSubject == "go2sleep") || ($msgBody == "go2sleep")) && preg_match($matchExpr, $msgFrom)) {
		$remotelyShutdownMSG ="** Remote SHUTDOWN command sent by: " . $msgFrom. " **";
		pipeMsgToMe($remotelyShutdownMSG);	// Send the message to my desired destination.
		processJabCleanup();			// Shutdown this IM.
	}

	if ($msgBody != '') {			// Notify that non-chat type message are notaccepted.
		$msgBody = "Message Subject: ".$msgSubject."<br>".$msgBody;
		displayTheMessage($msgBody,$msgFrom);	// Display the message in the IM window.
		$JABBER->SendMessage($msgFrom, $msgType, NULL, array("body" => "NOTE: I don't accept non-chat type messages, yet!"));
	}

//ir	if (preg_match("/^elmar /i", $msgBody)) {	// Example of accepting a message from a bot.
//ir		$phrase = preg_replace("/^Bot /i", "", $msgBody);
//ir		$sameBody = $phrase;
//ir		$JABBER->SendMessage($msgFrom, $msgType, NULL, array("body" => $sameBody));
//ir	}
//ir	else {						// Example of acting like a bot.
//ir		$JABBER->SendMessage($msgFrom, $msgType, NULL, array("body" => "I am the Bot-bot... HELLOOOO!!! "));
//ir	}
}

function connectTransport(){	// Returns output.
	global $JABBER, $_prog_irsimJabberServer;

	$transport = "icq.$_prog_irsimJabberServer";
	$JABBER->Connect() or die ('damn');
	$JABBER->SendAuth() or die ('damn');

	// Hardcoded example values follow, normally you either know your login details
	// or you'd get them from the enduser as described in step one
	// (see Jabber::TransportRegistrationDetails()).

	$details["nick"] = "ICQnickname";
	$details["username"] = "ICQ num";
	$details["password"] = "ICQ password";

	// the TransportRegistration method returns the same values as
	// the AccountRegistration method
	$status = $JABBER->TransportRegistration($transport, $details);
	switch ($status){
		case "1":
			$ret = 'Already registered with this transport!';
		break;
		case "2":
			$ret = 'Success in registering transport';
		break;
		case "3":
			$ret = 'Server not responding - registering transport!';
		break;
		case "Error":
			$ret = '"Error" - registering transport!';
		break;
		default:
			$ret = 'BAD status - registering transport!';
		break;
	}
	pipeMsgToMe($ret);			// Send the message to my desired destination.
}

function pipeMsgToMe($thePipedMsg) {		// Pipe text data where you desire.
	global  $progIdent;				// This program's identity label.

	displayTheMessage($thePipedMsg,$progIdent);	// Display the message in the IM window.
}

function processJabCleanup() {			// Cleanup processing at the end of IRSIM.
	global $username, $link, $JABBER;

	if ($username == $JABBER->username) {	// If the local account has a Jabber counterpart, then we connected Jabber earlier.
		$query = "update chat_users set status='offline', onlineReporter='' where onlineReporter='$username'";	// Switch all reported remote "online" buddies to "off" locally.
		$result = mysql_query($query, $link);
		disconnectIM();			// Disconnect the IM from the Jabber transports/contacts.
	}
}


?>
