<?PHP
# ========================================================================== #
#           IRSIM - Invisionix Roaming System Instant Messenger              #
# ========================================================================== #
#                                                                            #
#  Copyright (c) 2004 by Invisionix Systems                                  #
#     http://www.invisionix.org                                              #
#                                                                            #
#  This file is part of the IRSIM.                                           #
#  IRSIM is free software; you can redistribute it and/or modify it          #
#     under the terms of the GNU Lesser General Public License as            #
#     published by the Free Software Foundation; Latest version.             #
# IRSIM is distributed in the hope that it will be useful,                   #
#     but WITHOUT ANY WARRANTY; without even the implied                     #
#    warranty of MERCHANTABILITY or FITNESS FOR A                            #
#    PARTICULAR PURPOSE. See the GNU Lesser General Public                   #
#    License for more details.                                               #
#  You should have received a copy of the GNU Lesser General Public          #
#     License along with IRSIM (see license.txt); if not, write to the Free  #
#     Software Foundation Inc,59 Temple Place,Suite 330,Boston,MA 02111,USA  #
#     Copy of full license is in file "license.txt, and on the net at:       #
#            http://www.opensource.org/licenses/lgpl-license.php             #
# ========================================================================== #
#                                                                            #

//
// Perform IRSR system page header functions here.
//
$globalProgsFilePath = @dirname(__FILE__)."/programs.inc.php";	// Path to the system's global programs include file - Unix.
//$globalProgsFilePath = @dirname(__FILE__)."\programs.inc.php"; // Path to the system's global programs include file - Windows.
require_once	($globalProgsFilePath);						// System's global programs include file.

require_once 'irsim.inc.php';			// The IRSIM-Jabber routines.
include("mysql.php");
include("style.php");

global $JABBER;
global $theMessageFromMe;			// Buffer for sending messages out via the Chat Message Handler.

if ($alreadyDown != 'true') {			// Is the Jabber connection up now?
	$shutdownMsg = '&shutdown=true';	// Setup for shutting down the Jabber server connection.
	$exitButton = 'exit';
} else {					// Not connected to the Jabber server.
	$shutdownMsg = '';			// Setup for re-connecting to the Jabber server.
	$exitButton = 'Connect';
}
$buddy="$list";
$theMsgType = 'local';				// Default RSIM message type. (options: "remote" or "local").
$textareaRows = '3';				// Text area height.
$textareaCols = '100%';				// Text area width.
$font = 'Arial';				// Text area font.
$fontSize = '12pt';				// Text area font size.

function processEmotIcons($theMsg) {		// Translate EmotIcons into images.

	$retMsg = eregi_replace (";)", "<IMG SRC=\"img/smi.gif\">", $theMsg);
	$retMsg = eregi_replace (':)', "<IMG SRC=\"img/sad.gif\">", $theMsg);
	$retMsg = eregi_replace (':P', "<IMG SRC=\"img/ang.gif\">", $theMsg);
	$retMsg = eregi_replace (';P', "<IMG SRC=\"img/win.gif\">", $theMsg);
	$retMsg = eregi_replace (':q', "<IMG SRC=\"img/coo.gif\">", $theMsg);
	$retMsg = eregi_replace (';q', "<IMG SRC=\"img/ide.gif\">", $theMsg);
	$retMsg = eregi_replace (':o', "<IMG SRC=\"img/que.gif\">", $theMsg);
	$retMsg = eregi_replace (':!', "<IMG SRC=\"img/sur.gif\">", $theMsg);
	$retMsg = eregi_replace (':l', "<IMG SRC=\"img/tup.gif\">", $theMsg);

	return $retMsg;
}

function isStr_Hebrew($string) {		// Is the message in Hebrew?

	$cnt = 0;				// Hebrew character counter.
	$array = preg_split('//',$string,-1,PREG_SPLIT_NO_EMPTY);	// Break up the string into an array of characters.
	foreach ($array as $VAL)		// For each character in the array.
		{				// Count the number of Hebrew characters.
			if ($VAL >= "&#1488" && $VAL <= "&#1514") $cnt++; // Count Hebrew characters only.
			if ( $cnt > 10 ) return true;	// Stop counting at 10 characters.		
		}
	if ( $cnt > 0 ) return true;		// At least one character is Hebrew.

	return false;	// There are no Hebrew characters in the string.
}

function processLanguages($str) {	

	$strng = $str;
	if (isStr_Hebrew($strng)) {				// Is the message in Hebrew?
		$strng = str_replace("\\n","n\\",$strng);	// Prepare newlines for reversal.
		$strng = str_replace("<br>",">rb<",$strng);	// Prepare "breaks" for reversal.
		$strng = strrev(hebrevc($strng)); 	 	// Convert to visual-Hebrew characters and reverse the message's character order.
	}

	return $strng;
}

//
// Handle remote message type designation..
//
$query="select onlineReporter from chat_users where username='$buddy' ";
$result=mysql_query($query, $link);
$num_rows=mysql_num_rows($result);
if ($num_rows > 1) {					// Multiple "online user" reporters found.
	print "More than 1 username found in chat_users table. Figure out why.";
	while ($fresult=mysql_fetch_array($result)) { print"$fresult[0]<br>"; }
} else if ($num_rows == 1) {				// Found one "remote buddy online" reporter, as expected.
		$fresult = mysql_fetch_array($result);
		if ($fresult[0] == $username) {		// Local user sending to remote buddy.
			$theMsgType = 'remote';		// The message is to be sent by the Jabber Chat/Message Handlers.
		}
	}


//
// Process and insert the message being sent into the message transfer DB buffer.
//

$message = processLanguages($message);			// Language-particular processing.

$message = str_replace ( "<br>",  "||br||", $message);	// Hide "<br>"s.
$message = str_replace ( "<",  " ", $message);		// Remove tag elementdesignator.
$message = str_replace ( ">",  " ", $message);		// Remove tag element designator.
$message = str_replace ( "||br||",  "<br>", $message);	// Restore "<br>"s.
$message = str_replace ( "\n", "||n", $message);	// Hide "\n"s.
$message = stripslashes ($message);			// Remove all slashes.
$message = str_replace ( "||n", "\n", $message);	// Restore "\n"s.
$message = str_replace ( " ", " ", $message);
$message = addslashes ($message);			// Escape quotes before inserting into DB.
//ir $message = processEmotIcons($message);		// Translate EmotIcons into images.
$query="insert into chat_data set sender='$username',  buddy='$buddy', message='$message', msgType='$theMsgType'";
$result=mysql_query($query, $link);

echo "<BODY bgcolor='#000066' text='lightblue' link='00FFCC' vlink ='FF6666' alink='FFFFFF' onload='theForm.message.focus()' topmargin='0' leftmargin='0' rightmargin='0'>\n";
echo "<font face='arial' size='2'>\n";

echo "<CENTER>\n";
echo "<FORM name='theForm' action='$PHP_SELF?username=$username&buddy=$buddy&message=$message' method='POST'>\n";
echo "<input type='hidden' name='buddy' value='$buddy'>";

echo "<div style=\"font-family: $font; font-size: $fontSize\">\n";

echo "<TEXTAREA name='message' style='width:$textareaCols;' rows='$textareaRows'>";
echo "</TEXTAREA>\n";

echo "<table width='100' valign='top' topmargin='0' border='0' padding='0'>\n";
echo  "<tr>\n";
echo   "<table valign='top'>\n";
echo   "<td>\n";
	 $theBuddy = ($buddy != '') ? $buddy : $selectedBuddy;	// Use dialog frame buddy if not empty.
	 $onClickString = "theForm.message.focus();\n";  // Assemble the instructions to execute upon a submit.
	 $onClickString .= "parent.onlineFrame.location.href=\"online.php?user=$username&Uname=$theBuddy\";\n"; // Refresh the "online" contact list frame.
echo     "<input type='submit' name='send' value='SEND/RECEIVE' onclick='$onClickString' onmouseover=\"this.style.cursor=(document.all)?'hand':'pointer'\">\n";
echo   "</td>\n";
echo   "<td>\n";
	 $msgJabber = "parent.jabberFrame.location.href=\"jabber.php?username=$username$shutdownMsg\";"; // Send a signal to the Jabber frame to close down.
echo     "<input type='submit' value='$exitButton' onmouseover=\"this.style.cursor=(document.all)?'hand':'pointer'\" onclick='$msgJabber'>\n";
echo   "</td>\n";
echo   "<td>\n";
	 $onListClickString  = "theForm.message.focus();\n";	// Assemble the instructions to execute upon a submit.
	 $onListClickString .= "this.form.submit();\n";
echo     "<SELECT name='list' size='1' value='select' onchange='$onListClickString'>\n";
		if ($selectedBuddy != '') {	// Did selection arrive from the "online" frame?
			echo "<OPTION SELECTED value=$selectedBuddy>$selectedBuddy</option>\n";
			$buddy = $selectedBuddy;// The current "buddy" comes from the "online" contact list.
			print "<script>document.theForm.list.click;</script>\n";	// Cause the select list values to "register".
		} else { echo "<OPTION value=$buddy>$buddy</option>\n"; }
		$query = "select nickname, username from chat_users  where status='online' and username!='$username' ";
		$res=mysql_query($query, $link);
		$num_rows=mysql_num_rows($res);
		if ($num_rows > 0) {				// Multiple online users found.
			while($row=mysql_fetch_row($res)) {
				$showName = ($row[0] != '') ? $row[0] : $row[1]; // If a nickname exists, show the nickname.
				$buddy = $row[1];
				echo "<OPTION value=$row[1]>$showName</option>\n";
			}
		} else {					// No online users found.
			print "<OPTION SELECTED value='$buddy'>-- NO BUDDY SELECTED --</option>\n";
		}
echo     "</SELECT>\n";
echo   "</td>\n";
echo   "</table>\n";
echo  "</tr>\n";
echo "</table>\n";
//
echo "</div>\n";
echo"</FORM>\n";
echo "</BODY>\n";

?>
