<?php
/*
* Classe per lettura delle immagini in una cartella
* 
* Autore	Andrea Tarquini
* Data		05-05-2005 
* 
* 
* 		Uso:
*  
*			 $pntReadimage=new readImage('percorso'); 
*			 if($pntReadimage->caricaImmagini){	
* 			 	$pntReadimage->getNumImg();		
* 			 	$pntReadimage->getImmagini(); 		
* 			}
* 
* 
*/


class readImage{
	
	//dichiarazione delel propiet
	var $percorso,$estImg,$immagini,$nunImg;
	
	//metodo costruttore
	function readImage($inValue){
		$this->percorso=trim($inValue);
		$this->immagini=array();
		$this->nunImg=0;
		$this->estImg=array('jpg','JPG','jpeg','JPEG','gif','GIF','png','PNG');
	}
	
	//metodo che legge le immagini
	function caricaImmagini(){
		$this->percorso=(substr($this->percorso,-1)!='/') ? $this->percorso.'/' : '';
		if(is_dir($this->percorso)){
			if($tmp=opendir($this->percorso)){
				while(($file=readdir($tmp))!=FALSE){
					$tmpEst=explode('.',$this->percorso.$file);
					if(filetype($this->percorso.$file)=='file' && in_array($tmpEst[1],$this->estImg)){
						$this->immagini[]=$this->percorso.$file;
						$this->nunImg++;
					}
				}
				closedir($tmp);
				return TRUE;
			}
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	//metodo che restituisce il numero delle immagini trovate
	function getNumImg(){
		return $this->nunImg;
	}
	
	//metodo che restituisce le immagini
	function getImmagini(){
		return $this->immagini;
	}
}

?>