<?php

/*---------------------------------------------------\
|	MGDSH v. 1.0.0 
|   database abstraction interface class
|													
\-------*/
include_once("lib/class.mgdbase.php");
include_once("lib/class.mgddb.php");

class MGDQuery extends MGDBase
{
	//DB Class referentce 
	var $qrDB;

	//result set resource
	var $qrResID;

	//last call type
	var $qrUseUnbuffered;

	//constructor with database-object reference
	function MGDQuery($dbObj)
	{
		$this->Setup();
		
		if (!is_null($dbObj))
		{
			$this->qrDB = $dbObj;
		}
		else
		{
			$db = new MGDDB();
			$db->DBConnect();
			$this->qrDB = $db;
		}

		$this->qrResID = FALSE;
		$this->qrUseUnbuffered = false;

		MGDBase::DebugMessage(4, "Class Constructor", "Object OK");
	}

	//read the CFG settings
	function Setup()
	{
		require("lib/cfg.mgd.php");

		$this->SetDebugLevel($cfg['MGD']['debug_level']);
		$this->SetDebugOutputType($cfg['MGD']['debug_output_type']);
		$this->SetDebugOutputFile($cfg['MGD']['debug_log_file']);		
	}

	//open a db - query
	//$cmd =>					sql command
	//$useNonBufferedQuery =>	if true use mysql_unbuffered_query instead of mysql_query 
	function Open($cmd, $useNonBufferedQuery = false)
	{
		$bRes = false;
		
		if ($this->qrResID != FALSE)
		{
			MGDBase::DebugMessage(3, "Open", "Query already open: autoclosing");
			$this->Close();
		}

		MGDBase::DebugMessage(4, "Open", "Opening query: " . $cmd);

		//save the query mode
		$this->qrUseUnbuffered = $useNonBufferedQuery;

		if ($useNonBufferedQuery)
		{
			$this->qrResID = mysql_unbuffered_query($cmd);
		}
		else
		{
			$this->qrResID = mysql_query($cmd);
		}

		if ($this->qrResID == FALSE || is_null($this->qrResID))
		{
			MGDBase::DebugMessage(1, "Open", "Query Failed : " . mysql_errno() . ": " . mysql_error());	
			MGDBase::DebugMessage(1, "Open", "Query Failed : " . $cmd);	
			$bRes = false;
		}
		else
		{
			MGDBase::DebugMessage(4, "Open", "Query successfful");
			$bRes = true;
		}

		return $bRes;
	}

	function Close()
	{
		if ($this->qrResID != FALSE)
		{
			/* Free resultset */
			mysql_free_result($this->qrResID);
			$this->qrResID = false;
			MGDBase::DebugMessage(4, "Close", "Query Closed");
		}
	}

	function GetNumRows()
	{
		if ($this->qrUseUnbuffered)
		{
			MGDBase::DebugMessage(3, "GetNumRows", "Retrieving Num Rows with UseUnbuffered Query. Results may be incorrect.");
		}
		
		return mysql_num_rows($this->qrResID);
	}

	//return TRUE if there are more rows to fetch
	function FetchNextArray(&$resRow)
	{
		$bRes = FALSE;

		if ($this->qrResID != FALSE)
		{
			$bRes = (($resRow = mysql_fetch_array($this->qrResID, MYSQL_NUM)) != FALSE);
		}
		else
		{
			MGDBase::DebugMessage(3, "FetchNextArray", "Query Not Open");
		}
		return $bRes;
	}

	//return TRUE if there are more rows to fetch
	function FetchNextAssoc(&$resRow)
	{
		$bRes = FALSE;

		if ($this->qrResID != FALSE)
		{
			$bRes = (($resRow = mysql_fetch_assoc($this->qrResID)) != FALSE);			
		}
		else
		{
			MGDBase::DebugMessage(3, "FetchNextAssoc", "Query Not Open");
		}		
		return $bRes;
	}
	
	//returns a metadata array
	//with the informations about fields in the result set
	//available informations are:
	//blob:         $meta[]->blob
	//max_length:   $meta[]->max_length
	//multiple_key: $meta[]->multiple_key
	//name:         $meta[]->name
	//not_null:     $meta[]->not_null
	//numeric:      $meta[]->numeric
	//primary_key:  $meta[]->primary_key
	//table:        $meta[]->table
	//type:         $meta[]->type
	//unique_key:   $meta[]->unique_key
	//unsigned:     $meta[]->unsigned
	//zerofill:     $meta[]->zerofill
	function GetFieldsInfo()
	{
		if ($this->qrResID != FALSE)
		{
			$res = array();
			for ($i = 0; $i < mysql_num_fields($this->qrResID); $i++) 
			{				
				$meta = mysql_fetch_field($this->qrResID);
				if ($meta) 
				{   
					array_push($res, $meta);    				
				}
			}
		}
		else
		{
			$res = FALSE;				
		}
		return $res; 
	}
	
	//get the fields count
	function GetFieldCount()
	{
		if ($this->qrResID != FALSE)
		{
			$res = mysql_num_fields($this->qrResID);
		}
		else
		{
			$res = FALSE;				
		}
		return $res; 
	}

	//retrieves an ID from a table 
	//or -1 if an error occours or the '$fieldValue' is not found
	function GetIDFromTable($table, $fieldName, $fieldValue)
	{
		$retID = -1;
		$fd = strtoupper($fieldName);

		$cmd = "Select id " . " from " . $table . " WHERE " . $fd . " = '" . $fieldValue . "'";

		$res = array();
		if ($this->Open($cmd))
		{
			if ($this->FetchNextAssoc($res))
			{
				$retID = $res['id'];
			}
		}
		$this->Close();
		return $retID;
	}
	
	function GetSelectOptionValues($table, $keyField, $valueField, $selectedValue)
	{
		$selectOption = array();
		
		$cmd = "Select " . $keyField . ", " . $valueField . " from " . $table . " order by " . $keyField;

		$res = array();
		if ($this->Open($cmd))
		{
			while ($this->FetchNextAssoc($res))
			{
				$v1 = $res[$keyField];
				$v2 = $res[$valueField];
				
				$opt = "<option value='" . $v1 . "'";
				if ($selectedValue == $v1)
				{
					$opt .= "selected";
				}
				$opt .= ">" . $v2 . "</option>";
				
				array_push($selectOption, $opt);
			}
		}
		$this->Close();
		
		return $selectOption;
	}
	
	//returns true if the query is open
	function IsOpen()
	{
		return ($this->qrResID != FALSE);
	}
	
	//returns an array of field flags
	function GetFieldsFlags()
	{
		if ($this->qrResID != FALSE)
		{
			$res = array();
			for ($i = 0; $i < mysql_num_fields($this->qrResID); $i++) 
			{				
				$flags = mysql_field_flags($this->qrResID, $i);
				if ($flags) 
				{   
					$meta = array();
					$meta = explode(" ", $flags);
					array_push($res, $meta);   				
				}
				else
				{
					$meta = array();
					array_push($res, $meta); 
				}
			}
		}
		else
		{
			$res = FALSE;				
		}
		return $res; 
	}		
}
?>