<?php
/*---------------------------------------------------\
|	MGDSH v. 1.0.0 
|   editable php grid
|													
\-------*/
include_once("lib/class.mgdbase.php");
include_once("lib/class.mgdquery.php");

/*---------------------------------------------------\
|  
|
|
|
|
\---*/
define("MGDGRID_LANGUAGE", "IT");

define ("MGDGRID_BTCANCEL", "BT_Cancel");
define ("MGDGRID_BTNEWROW", "BT_NewRow");
define ("MGDGRID_BTDELROW", "BT_DelRow");
define ("MGDGRID_BTSAVE", "BT_Save");
define ("MGDGRID_BTGOTO", "BT_GoTo");

define ("MGDGRID_MSG_NEWROW", "MSG_NewRow");
define ("MGDGRID_MSG_CANCEL", "MSG_Cancel");
define ("MGDGRID_MSG_DELROW", "MSG_DelRow");

define ("MGDGRID_FRM_NEWROW_TITLE", "NFRM_Title");
define ("MGDGRID_FRM_NEWROW_CANCEL", "NFRM_Cancel");
define ("MGDGRID_FRM_NEWROW_SAVE", "NFRM_Save");
define ("MGDGRID_FRM_NEWROW_BACK", "NFRM_Back");

$mgdGridRes["IT"][MGDGRID_BTCANCEL] = "Annulla Modifiche";
$mgdGridRes["EN"][MGDGRID_BTCANCEL] = "Cancel";

$mgdGridRes["IT"][MGDGRID_BTNEWROW] = "Nuova Riga";
$mgdGridRes["EN"][MGDGRID_BTNEWROW] = "New Row";

$mgdGridRes["IT"][MGDGRID_BTDELROW] = "Elimina Riga Numero:";
$mgdGridRes["EN"][MGDGRID_BTDELROW] = "Delete Row:";

$mgdGridRes["IT"][MGDGRID_BTSAVE] = "Salva Modifiche";
$mgdGridRes["EN"][MGDGRID_BTSAVE] = "Save";

$mgdGridRes["IT"][MGDGRID_BTGOTO] = "Vai al record:";
$mgdGridRes["EN"][MGDGRID_BTGOTO] = "Goto record:";

$mgdGridRes["IT"][MGDGRID_MSG_NEWROW] = "Confermi nuova riga? Eventuali modifiche non salvate andranno perse.";
$mgdGridRes["EN"][MGDGRID_MSG_NEWROW] = "Warning, unsaved changes will be lost.";
$mgdGridRes["IT"][MGDGRID_MSG_CANCEL] = "Annullare tutte le modifiche?";
$mgdGridRes["EN"][MGDGRID_MSG_CANCEL] = "OK to discard all changes?";
$mgdGridRes["IT"][MGDGRID_MSG_DELROW] = "Confermi cancellazione riga? Eventuali modifiche non salvate andranno perse.";
$mgdGridRes["EN"][MGDGRID_MSG_DELROW] = "Are you sure to delete row? Changes will be discarded.";

$mgdGridRes["IT"][MGDGRID_FRM_NEWROW_TITLE] = "Inserimento Nuova Riga";
$mgdGridRes["EN"][MGDGRID_FRM_NEWROW_TITLE] = "New Row";

$mgdGridRes["IT"][MGDGRID_FRM_NEWROW_CANCEL] = "Cancella dati";
$mgdGridRes["EN"][MGDGRID_FRM_NEWROW_CANCEL] = "Cancel";

$mgdGridRes["IT"][MGDGRID_FRM_NEWROW_SAVE] = "Salva";
$mgdGridRes["EN"][MGDGRID_FRM_NEWROW_SAVE] = "Save";

$mgdGridRes["IT"][MGDGRID_FRM_NEWROW_BACK] = "Annulla";
$mgdGridRes["EN"][MGDGRID_FRM_NEWROW_BACK] = "Back";

/*-------------------
| Grid column types
\*----*/
define("COL_TYPE_TEXT", "Text");
define("COL_TYPE_NUMBER", "Numeric");
define("COL_TYPE_BOOL", "Bool");
define("COL_TYPE_EXT_TABLE", "ExtId");
define("COL_TYPE_DATE", "Date");
define("COL_TYPE_TIME", "Time");
define("COL_TYPE_DATETIME", "DateTime");
	
	
/*----------------
| grid column class
\---*/
class MGDGridColumn
{
	//column attributes
	var $gcTitle;		//column title
	var $gcEditable;	//editable column
	var $gcLength;		//column length
	
	var $gcVisible;		//visible column
	var $gdDefaultValue;//default value
	
	var $gcHRef;		//the content of the column is rendered as link
	var $gcImage;		//the content of the column is rendered as image
	
	var $gcDBBound;		//the column is bound to a db field
	
	//database field attributes
	var $gcPrimaryKey;	//column is part of primary key
	var $gcTableName;	//table name
	var $gcType;		//column control type
						//must be one of predefined const values for column type COL_TYPE_...
	var $gcDBType;		//database column type
						//string, int, double, date, datetime, time....					
	var $gcDBFieldName;	//phisical column name
	
	var $gcDBIsAutoIncrement;	//DB Column is auto-increment
		
	
	//external table handled by combo box input
	var $gcForeignTable;	//column have foreign key constraint
	var $gcFTOptionsValues;		//list of possible options values
	var $gcFTOptionsDisplays;		//list of possible options display
	var $gcFTSqlCommand;	//sql command used to build the option list
	var $gcFTKeyField;		//key field 
	var $gcFTDisplayFields;	//array with the displayed fields
	
	//constructor
	function MGDGridColumn()
	{
		$this->SetTitle("");
		$this->SetEditable(true);
		
		//standard type text
		$this->SetType(COL_TYPE_TEXT);
		//standard column length
		$this->SetLength(10);
		$this->SetForeignTable(false);
		$this->SetVisible(true);
		$this->SetDefaultValue("");
		$this->SetHRef(false);
		$this->SetImage(false);
		$this->SetEditable(true);
		$this->SetDBBound(true);
	}
	
	/*----------------
	|builds the foreign table options list from the DB
	|	$sqlCmd  =>   sql command
	|	$keyField =>  key field to edit the table
	|	$displayFields => displayed field in the drop down list
	|	$loadMaxN		=> if != -1 load only the first loadMaxN elements
	\-----*/
	function SetupDBForeignTable($sqlCmd, $keyField, $displayFields, $loadMaxN = -1)
	{
		$db = new MGDDB();
		if (!$db->DBConnect())
		{
			return;
		}
		
		$qr = new MGDQuery($db);
		
		if ($qr->Open($sqlCmd))
		{
			$this->SetForeignTable(true);
			$this->gcFTOptions = "";
			
			$this->gcFTSqlCommand = $sqlCmd;	
			$this->gcFTKeyField = $keyField;		
			$this->gcFTDisplayFields = $displayFields;
	
			$data = array();
			$optCount = 0;
			$this->gcFTOptionsValues = array();		//list of possible options values
			$this->gcFTOptionsDisplays = array();
	
			while ($qr->FetchNextAssoc($data))
			{
				$optCount++; 
				array_push($this->gcFTOptionsValues, $data[$keyField]);
				
				$tmpOpt = "";
				for ($i = 0; $i < count($displayFields); $i++)
				{
					$tmpOpt .= $data[$displayFields[$i]] . " ";
				}
				array_push($this->gcFTOptionsDisplays, $tmpOpt);
				
				if ($optCount >= $loadMaxN && $loadMaxN > 0)
				{
					break;
				}
			}
		}
		$qr->Close();
	}
	
	//builds the foreign table options list from the given array of values
	function SetupConstForeignTable()
	{	
	}
	
	//builds the list of the foreign table options
	function GetFTOptions($selectedValue, $selectFirst=false)
	{
		$ftOpt = "";
		for ($i = 0; $i < count($this->gcFTOptionsValues); $i++)
		{
			$tmpOpt = "<option";
			$tmpOpt .= " value=\"" . $this->gcFTOptionsValues[$i] . "\"";
			if (($selectFirst && $i == 0) || 
				 $this->gcFTOptionsValues[$i] == $selectedValue)
			{
				$tmpOpt .= " selected ";
			}
			$tmpOpt .= ">";
			$tmpOpt .= $this->gcFTOptionsDisplays[$i] . " ";
			
			$tmpOpt .= "</option>";
			$ftOpt .= $tmpOpt;
		}
		return $ftOpt;
	}
	/*---------
	| column properties
	\-----*/
	
	//column type
	function SetType($colType)
	{
		switch($colType)
		{
			case COL_TYPE_TEXT:
			case COL_TYPE_NUMBER:
	 		case COL_TYPE_BOOL:
			case COL_TYPE_EXT_TABLE:
			case COL_TYPE_DATE:
			case COL_TYPE_TIME:
			case COL_TYPE_DATETIME:
				$this->gcType = $colType;
				break;
			default:
				MGDBase::DebugMessage(4, "SetType", $colType . " is not a valid column type");
		}
	}
	function GetType()
	{
		return $this->gcType;
	}
	
	//column title
	function SetTitle($title)
	{
		$this->gcTitle = $title;
	}
	function GetTitle()
	{
		return $this->gcTitle;
	}
	
	//column editable
	function SetEditable($bEditable)
	{
		$this->gcEditable = $bEditable;
	}
	function GetEditable()
	{
		return $this->gcEditable;
	}
	
	//phisical db field name
	function SetDBFieldName($dbFName)
	{
		$this->gcDBFieldName = $dbFName;
	}
	function GetDBFieldName()
	{
		return $this->gcDBFieldName;
	}
	
	//length get-set
	function GetLength()
	{
		return $this->grLength;
	}
	function SetLength($cLength)
	{
		if ($cLength < 10) $cLength = 10;
		if ($cLength > 100) $cLength = 100;
		$this->grLength = $cLength;
	}
	//primary key get-set
	function GetPrimaryKey()
	{
		return $this->gcPrimaryKey;
	}
	function SetPrimaryKey($pk)
	{
		$this->gcPrimaryKey = $pk;
	}
	//table get-set
	function GetTable()
	{
		return $this->gcTable;
	}
	function SetTable($tb)
	{
		$this->gcTable = $tb;
	}
	//dbcoltype get set 
	function GetDBType()
	{
		return $this->gcDBType;
	}
	function SetDBType($dbType)
	{
		$this->gcDBType = $dbType;
	}
	//db is auto increment get-set
	function SetAutoIncrement($isAI)
	{
		$this->gcDBIsAutoIncrement = $isAI;
	}
	function GetAutoIncrement()
	{
		return $this->gcDBIsAutoIncrement;
	}
	
	//is foreign table get-set
	function SetForeignTable($fc)
	{
		$this->gcForeignTable = $fc;	//column is have foreign key constraint
	}
	function GetForeignTable()
	{
		return $this->gcForeignTable;	//column is have foreign key constraint
	}
	//key field get
	function GetFTKeyField()
	{
		return $this->gcFTKeyField;		//key field 
	}
	//display fields array get
	function GetFTDisplayFields()
	{
		return $this->gcFTDisplayFields;	//array with the displayed fields
	}
	
	//visible get-set
	function GetVisible()
	{
		return $this->gcVisible;		//visible column
	}
	function SetVisible($vis)
	{
		$this->gcVisible = $vis;		//visible column
	}
	//default value get-set
	function GetDefaultValue()
	{
		return $this->gcDefaultValue;//default value
	}
	function SetDefaultValue($dv)
	{
		$this->gcDefaultValue = $dv;
	}
	//render as href get-set
	function GetHRef()
	{
		return $this->gcHRef;
	}
	function SetHRef($hr)
	{
		$this->gcHRef = $hr;		//the content of the column is rendered as link
		$this->SetEditable(!$hr);
	}
	//render as image get-set
	function GetImage()
	{
		return $this->gcImage;		//the content of the column is rendered as image
	}
	function SetImage($img)
	{
		$this->gcImage = $img;		//the content of the column is rendered as image
		$this->SetEditable(!$img);
	}
	//column is bound with db table field
	function GetDBBound()
	{
		return $this->gcDBBound;		//the column is bound to a db field
	}
	function SetDBBound($dbb)
	{
		$this->gcDBBound = $dbb;
	}
}

/*----------------
| grid class
\---*/
class MGDGrid extends MGDBase
{
	//attributes
	var $grName;	//name of the grid instance
	var $grBaseLink;	//base link
						//very important : if the script is included in a page with oter scripts
						//it's your responsability to set the base link 
						//with  (if needed) predefined variables (eg page.php?v1=0....)
	//data
	var $grSqlCommand;	//direct sql command
	var $grPreparedSqlCommand;  //prepared sql command;
	
	var $grQuery;		//prepared query class
	var $grDB;			//db connection class
	
	//grid cursor state
	var $grCurrentPage;		//ZERO-based page index
	var $grRowsPerPage;
	
	//columns
	var $grColumns;
	
	//rows Information
	var $grNumRows;
	
	//numer of items in the navbar
	var $grNavBarMaxItems;
	
	//standard constructor
	function MGDGrid()
	{
		//call to base-class constructor
		MGDBase::MGDBase();
		
		require("lib/cfg.mgd.php");
		
		$this->SetDebugLevel($cfg['MGD']['debug_level']);
		$this->SetDebugOutputType($cfg['MGD']['debug_output_type']);
		$this->SetDebugOutputFile($cfg['MGD']['debug_log_file']);
		
		$this->grColumns = array();
		$this->SetSqlCommand("");
		$this->SetQuery(null);
		
		$this->SetCurrentPage(0);
		
		
		$this->SetRowsPerPage($mgdGrisSettings["NUM_ROWS_PER_PAGE"]);
		$this->SetNavBarMaxItems($mgdGrisSettings["NAV_BAR_MAX_ITEMS"]);
		//standard name 
		//should call $grid->SetName("yourGridName");
		$this->SetName("MGDGrid_1_0");
		
		$this->SetBaseLink( $_SERVER['PHP_SELF']);
		
		$this->SetNumRows(0);
	}
	
	//db-related objects setup
	function DBSetup()
	{
		//if defined, use the query object
		//else creates new one
		if (is_null($this->grQuery) || !is_object($this->grQuery))
		{
			if (is_null($this->grDB) || !is_object($this->grQuery))
			{
				$this->grDB = new MGDDB();
				
			}
			$this->grQuery = new MGDQuery($this->grDB);
		}
	}
	//opens the user-specified recordset
	function DBOpen()
	{
		//prepare the sql command
		$this->PrepareSqlCommand();
		
		if (!$this->grDB->DBConnect())
		{
			MGDBase::DebugMessage(3, "Setup", "Unable to setup the grid. Invalid db connection");
			return false;
		}
		
		if (!$this->grQuery->IsOpen())
		{
			if (!$this->grQuery->Open($this->GetPreparedSqlCommand()))
			{
				MGDBase::DebugMessage(3, "Setup", "Unable to setup the grid. Invalid sql command");
				return false;
			}
		}
		return true;
	}
	
	//grid setup
	//columns layout setup
	function Setup()
	{	
		//remove all columns
		array_splice($this->grColumns, 0);
		
		$this->DBSetup();
		if (!$this->DBOpen()) return;
		
		$fInfo = $this->grQuery->GetFieldsInfo();
		$fFlags = $this->grQuery->GetFieldsFlags();
		
		for ($i = 0; $i < count($fInfo); $i++)
		{
			$cl = new MGDGridColumn();
			$cl->SetDBFieldNAme($fInfo[$i]->name);
			$cl->SetTitle($fInfo[$i]->name);
			$cl->SetLength($fInfo[$i]->max_length);
			$cl->SetPrimaryKey($fInfo[$i]->primary_key);
			$cl->SetTable($fInfo[$i]->table);
			$cl->SetDBType($fInfo[$i]->type);
			
			$cl->SetAutoIncrement(in_array("auto_increment", $fFlags[$i]));	
			array_push($this->grColumns, $cl);
		}
		$this->grQuery->Close();
	}
	
	function SetupNumRows()
	{
		$db = new MGDDB();
		if ($db->DBConnect())
		{
			$qr = new MGDQuery($db);
			if ($qr->Open($this->GetSqlCommand()))
			{
				$numRows = $qr->GetNumRows();
				//store num rows for further use
				$this->SetNumRows($numRows);
			}
			$qr->Close();
		}
	}
	
	//prepares the sql statement for the grid
	function PrepareSqlCommand()
	{
		//steps:
		//		filter option
		//		limit option
		//		sorting order by option
		$sqlCmd = $this->GetSqlCommand();
		
		$startRec = $this->GetCurrentPage() * $this->GetRowsPerPage();
		$sqlCmd .= " limit " . $startRec . ", " . $this->GetRowsPerPage();
		$this->SetPreparedSqlCommand($sqlCmd);
	}
	
	//display the record-navigation bar
	function DisplayNavBar()
	{
		global $mgdGridRes;
		
		$btGoto = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_BTGOTO];
		
		//retrieve rows count
		$numRows = $this->GetNumRows();
		
		$baseLink = $this->GetBaseLink();
		$numPages = ceil($numRows / $this->GetRowsPerPage());
		
		$firstPageLink = $baseLink . "?toPage=0";
		
		$lastPage = $numPages - 1;
		$lastPageLink = $baseLink . "?toPage=" . $lastPage;
		
		$previuosPage = $this->GetCurrentPage() - 1; if ($previuosPage < 0) $previuosPage = 0;
		$previousPageLink = $baseLink . "?toPage=" . $previuosPage;
		
		$nextPage = $this->GetCurrentPage() + 1; if ($nextPage >= $numPages) $nextPage = $numPages - 1;
		$nextPageLink = $baseLink . "?toPage=" . $nextPage;
		
		$navFormName = $this->GetName() . "_navForm";
		
		echo "<table width='100%' border='1' cellspacing='0' cellpadding='2' bgcolor='#FFFFFF'>
		  <tr>
		  	<td width='25%' bgcolor='#999999'>
			<form name='$navFormName' method='post' action='$baseLink'>
				<table width='100%' border='0' cellspacing='0' cellpadding='0'>
				  <tr bgcolor='#999999'>
					<td width='100%' valign='top'>
						<input type='submit' name='goToRec' value='$btGoto' class='btFormObjStyle'>
				    	<input name='goToRecN' type='text' class='grTxtObj1' size='5' onblur=\"this.className='grTxtObj1'\"
											onfocus=\"this.className='grTxtObjFocus1'\">
					</td>
				  </tr>
				</table>
			</form>
			</td>
			<td width='75%' class='txtStd4' valign='top' align='left' bgcolor='#999999'>
			<a href='$firstPageLink'>&lt;&lt;</a> 
			<a href='$previousPageLink'>&lt;</a> ";
			
			
		$maxItems = $this->GetNavBarMaxItems();
		$startItem = $this->GetCurrentPage() - floor($maxItems/2);
		if ($startItem < 0) $startItem = 0;
		
		$nItems = 0;
		for ($i = $startItem; $i < $numPages && $nItems < $maxItems; $i++)
		{
			if ($i == $startItem && $startItem != 0) echo " .. ";
			
			$pageLink = $baseLink . "?toPage=" . $i;
			$pgDisp = $i + 1;
			echo "<a href='$pageLink'";
			if ($i == $this->GetCurrentPage()) echo "class='txtStd5'"; //
			echo ">  $pgDisp  </a>";
			$nItems++;
		}
		if ($i < $numPages ) echo " .. ";
		
		echo "<a href='$nextPageLink'>&gt;</a> 
			<a href='$lastPageLink'>&gt;&gt;</a>    
			</td>
		  </tr>
		</table>";
	}
	
	//displays the grid toolbar
	function DisplayToolBar()
	{
		global $mgdGridRes;
		
		$msgCancel = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_MSG_CANCEL];
		$msgNew = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_MSG_NEWROW];
		$msgDel = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_MSG_NEWROW];
		
		$btCancel = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_BTCANCEL];
		$btNew = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_BTNEWROW];
		$btDel = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_BTDELROW];
		$btSave = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_BTSAVE];

		$btGoto = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_BTGOTO];

		$optionList = "";
		$firstRow = $this->GetCurrentPage() * $this->GetRowsPerPage() + 1;
		
		for ($i = $firstRow; $i < ($firstRow + $this->GetRowsPerPage()) && $i < ($this->GetNumRows() + 1); $i++)
		{
			$optionList .= "<option value='" . $i . "' "; 
			if ($i == $firstRow) $optionList .= " selected ";
			$optionList .= " >" . $i . "</option>";
		}
		
		echo "<table width='100%' border='1' cellspacing='0' cellpadding='0' bgcolor='#FFFFFF'>				  				
								<tr bgcolor='#999999'>
									<td >
										<input type='submit' name='NONE' value='' class='btFormObjStyle' onclick=\"return false;\">
										<input type='submit' name='grSave' value='$btSave' class='btFormObjStyle'>
										<input type='reset' name='grReset' value='$btCancel' class='btFormObjStyle' onclick=\"if (!confirm('$msgCancel')) return false;\">																			
									</td>
				 				 </tr> 
								 <tr>
				  					<td bgcolor='#999999'>
										<input type='submit' name='newRow' value='$btNew' class='btFormObjStyle' onclick=\"if (!confirm('$msgNew')) return false;\">
					  					<input type='submit' name='delRow' value='$btDel' class='btFormObjStyle' onclick=\"if (!confirm('$msgDel')) return false;\">
										<select name='delRowN' class='grCbObj' onblur=\"this.style.backgroundColor='#ffffff'\"
											onfocus=\"this.style.backgroundColor='#ffff00'\" >$optionList</select>
				 		
					  				</td>
								</tr>
			  </table>";        
	}
	
	//displays the html - grid
	function Display()
	{
		//first store global variables
		global $toPage;
		global $newRow;
		global $delRow;
		global $delRowN;
		global $goToRec;
		global $goToRecN;
		global $grSave;
		
		global $newRowPost;	//variables from the new row form
		global $newRowData;
		
		global $tx;		//data from the grid-form
		
		$this->SetupNumRows();
		
		if (isset($goToRec))
		{
			if (isset($goToRecN))
			{
				if ($goToRecN < 1) $goToRecN = 1;
				if ($goToRecN > $this->GetNumRows()) $goToRecN = $this->GetNumRows();
				
				//recalc page number and override $toPage var
				$toPage = floor(($goToRecN - 1)/ $this->GetRowsPerPage()); 
			}
		}
		
		if (isset($toPage)) $this->SetCurrentPage($toPage);
		
		//second setup the db connection
		$this->DBSetup();
		if (!$this->DBOpen()) return;
		
		$grFormName = $this->GetName() . "_mainForm";
		$grNewRowFormName = $this->GetName() . "_nrForm"; 
		$baseLink = $this->GetBaseLink();
		$action = $baseLink . "?toPage=" . $toPage;
		
		//third verify if have to show the grid or the new row form or delete row function
		if (isset($newRow))
		{
			$this->DisplayNewRowForm($grNewRowFormName, $action);
			return;
		}
		if (isset($delRow))
		{
			$this->DeleteRow($delRowN, $tx, $action);
			return;
		}	
		if (isset($newRowPost))		//new row posted
		{	
			$this->SaveNewRow($newRowData, $action);
			return;
		}
		if (isset($grSave))
		{
			$this->SaveData($tx, $action);
			return;
		}
		
		//display the grid
		echo "<table width='100%' border='0' cellpadding='0' cellspacing='0' bgcolor='#CCCCCC'>
				<tr>
				  	<td><form name='$grFormName' method='post' action='$action'>";
					   //display the grid tool bar
					   $this->DisplayToolBar();
			   
				echo "<table width='100%' border='0' cellspacing='0' cellpadding='0'>
		 					<tr>
								<td width='5%' align='center' class='txtStd2'>N</td>";
					
					//$numRows = $this->grQuery->GetNumRows();
					$data = array();
					$nR = 0;
					$rowIdx = $this->GetCurrentPage() * $this->GetRowsPerPage();
					for ($i = 0; $i < count($this->grColumns); $i++)
					{
							$cN = $this->grColumns[$i]->GetTitle();
							if ($this->grColumns[$i]->GetVisible())
							{
								echo "<td width='16%' align='center' class='txtStd2'>$cN</td>";
							}
							else
							{
								echo "<td width='0%' align='center'></td>";
							}
					}
								
							
						echo"</tr>";
		  
							while ($this->grQuery->FetchNextAssoc($data))
							{
								$rowIdx++;
								echo "<tr><td  class='txtStd3'>$rowIdx</td>";
								for ($l = 0; $l < count($this->grColumns); $l++)
								{
									$clName = $this->grColumns[$l]->GetDBFieldName();
									$rwValue = $data[$clName];
									
									$this->DisplayGridCell($rowIdx, $nR, $l, $rwValue);
								}
								echo "</tr>";
								$nR++;		
							}
		  echo "</table></form></td></tr></table>";
		  //end display grid
	
		//display the grid navigation bar
		$this->DisplayNavBar();
		
		$this->grQuery->Close();
	}
	
	//displays a grid cell according with column flags
	//$dbRowIdx => true row index
	//$grRowIdx => displayed row index 
	//$grColIdx => column index
	//$cellValue => db value of this cell
	function DisplayGridCell($dbRowIdx, $grRowIdx, $grColIdx, $cellValue)
	{
		$clName = $this->grColumns[$grColIdx]->GetDBFieldName();
		$clSize = $this->grColumns[$grColIdx]->GetLength();
		if ($clSize < 20) $clSize = 20;
		if (($dbRowIdx % 2) == 0)
		{
			$txtBaseClass = "grTxtObjEven"; $cbBaseClass = "grCbObjEven"; $labelBaseClass = "grLabelObjEven";
		}
		else
		{
			$txtBaseClass = "grTxtObjOdd"; $cbBaseClass = "grCbObjOdd"; $labelBaseClass = "grLabelObjOdd";
		}
		
		/*---------------------------
		| column flags to evaluate:
		| $gcEditable;	//editable column
	    | $gcLength;		//column length
		|
		|$gcVisible;		//visible column
		|$gdDefaultValue;//default value
		|
		|$gcHRef;		//the content of the column is rendered as link
		|$gcImage;		//the content of the column is rendered as image
		\*---*/
		
		//setting the default value
		$defVal = $this->grColumns[$grColIdx]->GetDefaultValue();
		if ($defVal != "") $cellValue = $defVal;
		
		if ($this->grColumns[$grColIdx]->GetVisible())
		{
			if ($this->grColumns[$grColIdx]->GetEditable())
			{
				if ($this->grColumns[$grColIdx]->GetForeignTable())
				{
					$opt = $this->grColumns[$grColIdx]->GetFTOptions($cellValue);
					echo "<td><select class='$cbBaseClass' name='tx[$grRowIdx][$clName]' onblur=\"this.className='$cbBaseClass'\"
							  onfocus=\"this.className='grCbObjFocus'\" >$opt</select></td>";
				}
				else
				{
					echo "<td ><input type='text' name='tx[$grRowIdx][$clName]' class='$txtBaseClass' onblur=\"this.className='$txtBaseClass'\"
							onfocus=\"this.className='grTxtObjFocus'\" value='$cellValue' size='$clSize'></td>";
				}
			}
			else
			{
				//not editable cell
				//render as image?
				if ($this->grColumns[$grColIdx]->GetImage())
				{
					echo "<td class='$labelBaseClass'><input type='hidden' name='tx[$grRowIdx][$clName]' value='$cellValue'><img src='$cellValue'></td>";
				}
				elseif ($this->grColumns[$grColIdx]->GetHRef())
				{
					$tt = $this->grColumns[$grColIdx]->GetTitle();
					echo "<td class='$labelBaseClass'><input type='hidden' name='tx[$grRowIdx][$clName]' value='$cellValue'><a href='$cellValue'>$tt</a></td>";
				}
				else
				{
					echo "<td class='$labelBaseClass' ><input type='hidden' name='tx[$grRowIdx][$clName]' value='$cellValue'>$cellValue</td>";
				}
			}
		}
		else
		{
			//not visible cell
			echo "<td ><input type='hidden' name='tx[$grRowIdx][$clName]' value='$cellValue'></td>";
		}
	}
	
	//displays a grid cell according with column flags
	//$dbRowIdx => true row index
	//$grRowIdx => displayed row index 
	//$grColIdx => column index
	//$cellValue => db value of this cell
	function DisplayNewRowCell($grColIdx)
	{
		$clName = $this->grColumns[$grColIdx]->GetDBFieldName();
		$clSize = $this->grColumns[$grColIdx]->GetLength();
		$cTitle = $this->grColumns[$grColIdx]->GetTitle();
		
		//setting the default value
		$defVal = $this->grColumns[$grColIdx]->GetDefaultValue();
		
		if ($this->grColumns[$grColIdx]->GetVisible())
		{
			if ($this->grColumns[$grColIdx]->GetEditable())
			{
				echo "<tr><td class='txtStd2'>$cTitle</td>";	
				if ($this->grColumns[$grColIdx]->GetForeignTable())
				{
					$opt = $this->grColumns[$grColIdx]->GetFTOptions("", true);
					echo "<td><select class='grCbObj' name='newRowData[$clName]' onblur=\"this.className='grCbObj'\"
							  onfocus=\"this.className='grCbObjFocus'\" >$opt</select></td>";
				}
				else
				{
					echo "<td><input name='newRowData[$clName]' type='text' class='grTxtObj1' size='$clSize' onblur=\"this.className='grTxtObj1'\"
										onfocus=\"this.className='grTxtObjFocus1'\">";
				}
				echo "</td></tr>";
			}
			else
			{
				echo "<tr><td class='txtStd2'>$cTitle</td><td class='txtStd2' ><input type='hidden' name='newRowData[$clName]' value='$defVal'>$defVal</td></tr>";
			}
		}
		else
		{
			//not visible cell
			echo "<tr><td class='txtStd2'></td><td ><input type='hidden' name='newRowData[$clFName]' value='$defVal'></td>";
		}
	}
	
	//displays the new-row form
	function DisplayNewRowForm($formName, $action)
	{
		global $mgdGridRes;
		
		$lbTitle = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_FRM_NEWROW_TITLE];
		$lbCancel = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_FRM_NEWROW_CANCEL];
		$lbSave = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_FRM_NEWROW_SAVE];
		$lbBack = $mgdGridRes[MGDGRID_LANGUAGE][MGDGRID_FRM_NEWROW_BACK];

		echo "<table width='100%' border='1' cellspacing='0' cellpadding='0'>
			  <tr>
				<td class='txtStd1' ><b>$lbTitle</b></td>
			  </tr>
			  <tr>
			  	<td>
					<form name='$formName' method='post' action='$action'>
						<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
		
		for ($i = 0; $i < count($this->grColumns); $i++)
		{
			if (!$this->grColumns[$i]->GetAutoIncrement() &&
				 $this->grColumns[$i]->GetDBBound())
			{
				$this->DisplayNewRowCell($i);
			}
		}				
		echo "	 <tr>
					<td>
					</td>
					<td>
						<input type='reset' name='Reset' value='$lbCancel' class='btFormObjStyle'>
						<input type='submit' name='newRowPost' value='$lbSave' class='btFormObjStyle'>
					</td>
				 </tr>	
					</table>				
					</form>
			  	</td>
			  </tr>
			  <tr>
				<td class='txtStd1'><a href='javascript:history.back()'>$lbBack</a></td>
			  </tr>
			</table>";
	}
	
	//removes the specified row from the database
	//$tx is the grid data array
	//prev link i s the link
	function DeleteRow($delRowN, $tx, $prevLink)
	{
		//calculating relative row number
		if ($this->GetCurrentPage() > 0) $delRowN = $delRowN - ($this->GetRowsPerPage() * $this->GetCurrentPage());
		
		$cmd = "";
		
		$pkWhere = "";
		$pkWhereCount = 0;
		$tb = $this->grColumns[0]->GetTable();
		
		for ($i = 0; $i < count($this->grColumns); $i++)
		{
			if ($this->grColumns[$i]->GetPrimaryKey())
			{
				if ($pkWhereCount > 0) $pkWhere .= " and ";
				
				$clName = $this->grColumns[$i]->GetDBFieldName();
				$pkWhere .= $clName . " = ";
				$pkWhere .= "'" . mysql_escape_string($tx[$delRowN - 1][$clName]) . "'";
				$pkWhereCount++;
			}	
		}
		if ($pkWhereCount > 0)
		{
			$cmd = "delete from " . $tb . " where " . $pkWhere;
			if (mysql_query($cmd) == TRUE)
			{
				$msg = "Riga cancellata.";
			}
			else
			{
				$msg = "Errore durante la cancellazione.";
			}
		}
		else
		{
			$msg = "Impossibile cancellare una riga se la tabella non ha una primary key.";
		}
		
		echo "<table width='100%' border='1' cellpadding='0' cellspacing='1' bordercolor='#009900'>
			  <tr>
				<td>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'>
						<tr>
							<td class='txtStd1'>$msg</td>
						</tr>
						<tr>
						  <td class='txtStd1'><a href='$prevLink'>&lt;-Ritorna ai dati</a></td>
					  </tr>
					</table>
				</td>
			  </tr>
			</table>";
	}
	
	//inserts the specified new row into the database
	//$tx is the data array
	//prev link is the link to the main page
	function SaveNewRow($tx, $prevLink)
	{
		$cmd = "";
		
		$colList = "";
		$valuesList = "";
		
		$tb = $this->grColumns[0]->GetTable();
		
		$nC = count($this->grColumns);
		for ($i = 0; $i < $nC; $i++)
		{	
			if (!$this->grColumns[$i]->GetAutoIncrement())
			{
				$colList .= " " . $this->grColumns[$i]->GetDBFieldName() . ",";
				$valuesList .= " '" . mysql_escape_string($tx[$this->grColumns[$i]->GetDBFieldName()]) . "',";
			}
		}
		$colList = substr($colList, 0, strlen($colList) - 1);
		$valuesList = substr($valuesList, 0, strlen($valuesList) - 1);
		
		$cmd = "insert into " . $tb . " (" . $colList . ") values (" . $valuesList . ")";
		$db = new MGDDB();
		if (!$db->DBConnect())
		{
			$msg = "Errore durante la connessione.<br>Riga non inserita.";
		}
		else
		{
			if (mysql_query($cmd) == TRUE)
			{
				$msg = "Riga inserita con successo.";
			}
			else
			{
				$msg = "Errore durante l'inserimento.";
			}
		}	
		
		echo "<table width='100%' border='1' cellpadding='0' cellspacing='1' bordercolor='#009900'>
			  <tr>
				<td>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'>
						<tr>
							<td class='txtStd1'>$msg</td>
						</tr>
						<tr>
						  <td class='txtStd1'><a href='$prevLink'>&lt;-Ritorna ai dati</a></td>
					  </tr>
					</table>
				</td>
			  </tr>
			</table>";
	}
	
	//updates the db with all data in the current page
	//$tx is the data array
	//prev link is the link to the main page
	function SaveData($tx, $prevLink)
	{
		$cmd = "";
		
		$updList = "";
		$whereList = "";
		
		$tb = $this->grColumns[0]->GetTable();
		
		$nC = count($this->grColumns);
		
		$allOK = true;
		
		$db = new MGDDB();
		if (!$db->DBConnect())
		{
			$msg = "Errore durante la connessione.<br>Riga non inserita.";
		}
		else
		{
			if ($this->HavePK())
			{
				for ($r = 0; $r < count($tx); $r++)
				{
					$updList = "";
					$whereList = "";
					$whereCount = 0;
					for ($i = 0; $i < $nC; $i++)
					{	
						$clName = $this->grColumns[$i]->GetDBFieldName();
						if (!$this->grColumns[$i]->GetAutoIncrement() &&
							 $this->grColumns[$i]->GetDBBound())
						{
							$updList .= $clName . " = '" . mysql_escape_string($tx[$r][$clName]) . "',";
						}
						if ($this->grColumns[$i]->GetPrimaryKey())
						{
							if ($whereCount > 0) $whereList .= " and ";
							
							$whereList .= $clName . " = ";
							$whereList .= "'" . mysql_escape_string($tx[$r][$clName]) . "'";
							$whereCount++;
						}
					}
					$updList = substr($updList, 0, strlen($updList) - 1);
					$cmd = "update " . $tb . " set " . $updList . " where " . $whereList;
					$allOK &= mysql_query($cmd);
				}
			}
			else
			{
				$msg = "Impossibile aggiornare i dati:<br>Primary key non definita.";
			}
		}
		
		if ($allOK)
		{
			$msg = "Aggiornamento effettuato.";
		}
		else
		{
			$msg = "Errore durante l'aggiornamento.";
		}
				
		echo "<table width='100%' border='1' cellpadding='0' cellspacing='1' bordercolor='#009900'>
			  <tr>
				<td>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'>
						<tr>
							<td class='txtStd1'>$msg</td>
						</tr>
						<tr>
						  <td class='txtStd1'><a href='$prevLink'>&lt;-Ritorna ai dati</a></td>
					  </tr>
					</table>
				</td>
			  </tr>
			</table>";
	}
	
	//returns true if there is one or more columns in the primary key
	function HavePK()
	{
		for ($i = 0; $i < count($this->grColumns); $i++)
		{
			if ($this->grColumns[$i]->GetPrimaryKey())
			{
				return true;
			}
		}
		return false;
	}
	
	/*-------------------
	| class properties
	\---*/
	//sqlcommand get-set
	function  GetSqlCommand()
	{
		return $this->grSqlCommand;
	}
	function SetSqlCommand($sqlCmd)
	{
		$this->grSqlCommand = $sqlCmd;
		//overwrite prepared sql command
		$this->SetPreparedSqlCommand($sqlCmd);
	}
	
	//prepared sql command get_set
	function GetPreparedSqlCommand()
	{
		return $this->grPreparedSqlCommand;
	}
	function SetPreparedSqlCommand($pSql)
	{
		$this->grPreparedSqlCommand = $pSql;
	}
	
	//sql query class get-set
	function GetQuery()
	{
		return $this->grQuery;
	}
	function SetQuery($clQuery)
	{
		$this->grQuery = $clQuery;
	}
	//db connection class get-sel
	function GetDB()
	{
		return $this->grDB;
	}
	function SetDB($clDB)
	{
		$this->grDB = $clDB;
	}
	
	//current page get-set
	function GetCurrentPage()
	{
		return $this->grCurrentPage;
	}
	function SetCurrentPage($curPage)
	{
		$this->grCurrentPage = $curPage;
	}
	//number of rows per page get-set
	function GetRowsPerPage()
	{
		return $this->grRowsPerPage;
	}
	function SetRowsPerPage($nR)
	{
		$this->grRowsPerPage = $nR;
	}
	//instance grid name get-set
	function GetName()
	{
		return $this->grName;
	}
	function SetName($name)
	{
		if ($name != "") $this->grName = $name;
	}
	
	//cached rows number 
	function SetNumRows($nRows)
	{
		$this->grNumRows = $nRows;
	}
	function GetNumRows()
	{
		return $this->grNumRows;
	}
	
	//base link get-set
	function GetBaseLink()
	{
		return $this->grBaseLink;
	}
	function SetBaseLink($bLink)
	{
		$this->grBaseLink = $bLink;
	}
	//nav bar max items get-set
	function GetNavBarMaxItems()
	{
		return $this->grNavBarMaxItems;
	}
	function SetNavBarMaxItems($nI)
	{
		$this->grNavBarMaxItems = $nI;
	}
}
?>
