<?php

/*---------------------------------------------------\
|	MGDSH v. 1.0.0 
|   database abstraction interface class
|													
\-------*/
include_once("lib/class.mgdbase.php");

class MGDDB extends MGDBase
{
	//connection resource
	var $dbConnection;

	var $dbUser;
	var $dbHost;
	var $dbDatabase;
	var $dbPassword;

	var $dbUsePersistentConnection = false;

	var $dbConnectionOK;

	//class contructor
	function MGDDB()
	{		
		//call to base-class constructor
		MGDBase::MGDBase();

		$this->dbConnection = FALSE;
		
		$this->dbUser = "";
		$this->dbHost = "";
		$this->dbDatabase = "";
		$this->dbPassword = "";

		$this->dbUsePersistentConnection = false;

		$this->dbConnectionOK = false;

		$this->Setup();
	}

	//executes the connection to the database
	function DBConnect()
	{
		/* Connecting, selecting database */
		$msg = "";
		if ($this->dbUsePersistentConnection)
		{		
			$msg = "Connected to MySQL using pconnect ";
			$this->dbConnection = mysql_pconnect($this->dbHost, $this->dbUser, $this->dbPassword);						
		}
		else
		{
			$msg = "Connected to MySQL using connect ";
			$this->dbConnection = mysql_connect($this->dbHost, $this->dbUser, $this->dbPassword);				
		}

		if ($this->dbConnection == false)
		{
			MGDBase::DebugMessage(1, "DBConnect", "Connection FAILED to MySQL " . $this->dbHost . " user : " . $this->dbUser . " " . mysql_errno() . ": " . mysql_error());	
		}
		else
		{			
			MGDBase::DebugMessage(4, "DBConnect", "Connection OK to MySQL " . $this->dbHost . " user : " . $this->dbUser);	
			if (mysql_select_db($this->dbDatabase))
			{
				MGDBase::DebugMessage(4, "DBConnect", "Database " . $this->dbDatabase . " successfully selected");	
				$this->dbConnectionOK = true;
			}
			else
			{
				MGDBase::DebugMessage(1, "DBConnect", "Database " . $this->dbDatabase . " NOT Selected. Check your Database. " . mysql_errno() . ": " . mysql_error());	
			}
		}		
		return $this->dbConnectionOK;
	}

	function DBDisconnect()
	{
		/* Closing connection */
		if ($this->dbConnectionOK)
		{
			if ($this->dbUsePersistentConnection)
			{		
				MGDBase::DebugMessage(3, "DBDisconnect", "Cannot close persistent connections");	
			}
			else
			{
				mysql_close($this->dbConnection);
				MGDBase::DebugMessage(4, "DBDisconnect", "MySQL Connection Closed");	
			}
			$this->dbConnectionOK = false;
		}
		else
		{
			MGDBase::DebugMessage(4, "DBDisconnect", "Closing a non-opened connection");	
		}			
	}

	/*-------------------------------------------*\
	| executes a command 
	\*--------------------*/
	function DBExecute($cmd)
	{
		if (!$this->dbConnectionOK)
		{
			if (!$this->DBConnect())
			{
				return false;
			}
		}
		$result = mysql_query($cmd);
		
		return ($result != FALSE);
	}
	
	//properties settings
	
	//read-only
	function GetConnection()
	{
		return $this->dbConnection;
	}

	function GetUser()
	{
		return $this->dbUser;
	}

	function SetUser($user)
	{
		$this->dbUser = $user;
	}

	function GetHost()
	{
		return $this->dbHost;
	}

	function SetHost($host)
	{
		$this->dbHost = $host;
	}

	function GetDatabase()
	{
		return $this->dbDatabase;
	}

	function SetDatabase($database)
	{
		$this->dbDatabase = $database;
	}

	//write - only
	function SetPassword($password)
	{
		$this->dbPassword = $password;
	}

	function GetUsePersistentConnection()
	{
		return $this->dbUsePersistentConnection;
	}

	function SetUsePersistentConnection($usePersistentConnection)
	{
		$this->dbUsePersistentConnection = $usePersistentConnection;
	}
	//end properties setting
	

	//read the CFG settings
	function Setup()
	{
		require("lib/cfg.mgd.php");

		$this->SetDebugLevel($cfg['MGD']['debug_level']);
		$this->SetDebugOutputType($cfg['MGD']['debug_output_type']);
		$this->SetDebugOutputFile($cfg['MGD']['debug_log_file']);

		$this->SetUsePersistentConnection($cfg['DB']['use_persistent_connection']);

		$this->SetHost($cfg['DB']['host']);
		$this->SetUser($cfg['DB']['user']);
		$this->SetPassword($cfg['DB']['password']);
		$this->SetDatabase($cfg['DB']['database']);
			
		error_reporting($cfg['PHP']['ERROR_REPORTING']);
	}
}
?>
