<?php
/*---------------------------------------------------\
|	MGDSH v. 1.0.0 
|   base class
|													
\-------*/
class MGDBase
{
	/*---------------------------------------------------\
	|  DEBUG 
	\-------*/
	//debug level
	//0 -> No error messages
	//1 -> Fatal Error messages 
	//2 -> Error messages
	//3 -> Warning messages
	//4 -> Trace - Level (ALL)
	var $bsDebugLevel;

	//debug output type
	//0 -> echo stream
	//1 -> file
	var $bsDebugOutType;

	//name of the file for log-output
	var $bsDebugFile;

	function MGDBase()
	{
		$this->bsDebugLevel = 0;

		$this->bsDebugOutType = 0;

		$this->bsDebugFile = "./MGDLog.txt";
	}

	//start class properties access
	function SetDebugLevel($debugLevel)
	{
		if ($debugLevel >= 0 && $debugLevel <= 4)
		{
			$this->bsDebugLevel = $debugLevel;
		}
	}

	function SetDebugOutputType($debugOutputType)
	{
		if ($debugOutputType >= 0 && $debugOutputType <= 1)
		{
			$this->bsDebugOutType = $debugOutputType;
		}
	}

	function SetDebugOutputFile($debugOutputFile)
	{
		$this->bsDebugFile = $debugOutputFile;		
	}
	//end  class properties access

	//function ShowDebugMessage
	//params	$messageLevel =>level of the message
	//						   =>severity of the message	0 = NO MESSAGE
	//														1 = fatal error
	//														2 = error
	//														3 = warning
	//														4 = trace
	//			$messageText  =>text  of the message
	//			
	function DebugMessage($messageLevel, $callerFunction, $messageText)
	{
		//is message to show?
		if ($messageLevel <= $this->bsDebugLevel)
		{
			$sev = "<< NO MESSAGE >>";
			switch ($messageLevel)
			{
			case 4:
				$sev = "<< Trace >>";
				break;
			case 3:
				$sev = "<< Warning >>";
				break;
			case 2:
				$sev = "<< ERROR >>";
				break;
			case 1:
				$sev = "<< FATAL ERROR >>";
				break;
			}

			$date = date("Y-m-d H:i:s");

			$msg = $sev . " Class: " . get_class($this) . " Function: " . $callerFunction . " Time: " . $date . " Level: " . $messageLevel . " Message: " . $messageText . "\n";
			if ($this->bsDebugOutType == 0)
			{
				echo $msg . "<br>";
			}
			else
			{
				$fp = fopen($this->bsDebugFile, "a");
				fwrite($fp, $msg);
				fclose($fp);
			}
		}
	}
}

?>