<?php
require_once _LIBPATH . "common.php";
require_once _LIBPATH . "xml.php";
$_TSM = array();
class CTemplate {
var $input;
var $output;
var $blocks;
function CTemplate($source,$source_type = "file") {
$this->Load($source,$source_type);
}
function Load($source,$source_type = "file") {
switch ($source_type) {
case "file":
$data = GetFileContents($source);
break;
case "rsl":
case "string":
$data = $source;
break;
}
preg_match_all("'<!--S\:.*?-->.*?<!--E\:.*?-->'si",$data,$matches);
if (count($matches[0]) != 0)
foreach ($matches[0] as $block) {
$name = substr($block,strpos($block,"S:") + 2,strpos($block,"-->") - 6);
$block = substr($block,9 + strlen($name),strlen($block) - 18 - strlen($name) * 2);
$this->blocks["$name"] = new CTemplate($block,"string");
}
$this->input = $this->output = preg_replace(array("'<!--S\:.*?-->(\r\n|\n|\n\r)'si","'<!--E\:.*?-->(\r\n|\n|\n\r)'si"),"",$data);
}
function Replace($vars,$clear = TRUE) {
if (is_array($vars)) {
foreach ($vars as $key => $var) {
if (is_array($var)) {
unset($vars[$key]);
}				
}			
}
$patterns = array();
$replacements = array();
if (is_array($vars))
foreach ($vars as $key => $val) {
$patterns[] = "/\{" . strtoupper($key) . "\}/";
$replacements[] = str_replace('$','\$',$val);
}
$result = $this->output = preg_replace($patterns,$replacements,$this->input);
if ($clear == TRUE)
$this->Clear();
return $result;
}
function ReplaceSingle($var,$value,$perm = FALSE) {
$var = strtoupper($var);
if ($perm == TRUE)
$this->input = str_replace("\{$var}",$value,$this->input);
return $this->output = str_replace("\{$var}",$value,$this->output);
}
function Clear() {
$this->output = $this->input;
}
function EmptyVars() {
global $_TSM;
return $this->output = preg_replace("'{[A-Z_\-0-9]*?}'si","",$this->output);
}
function BlockExists($block_name) {
return isset($this->blocks[$block_name]) ? TRUE : FALSE;
}
}
class CLayout extends CXMLParser {
var $data;
var $version;
var $name;
var $base;
var $body;
var $blocks;
var $loaded = FALSE;
function CLayout($file_name = "") {
parent::CXMLParser();
if ($file_name != "")
$this->Load($file_name);
}
function HNDTagOpen($parser,$tag,$attr) {
global $base;
switch ($tag) {
case "LAYOUT":
$this->version = ($attr["VERSION"] == "") ? "1.0" : $attr["VERSION"];
$this->base = $attr["BASE"];
$this->name = $attr["NAME"];
$this->body = new CTemplate($GLOBALS["_TEMPLATES_PATH"] . $this->base . $attr["SRC"]);
break;
case "BLOCK":
$this->blocks[$attr["NAME"]] = new CTemplate($GLOBALS["_TEMPLATES_PATH"] . $this->base . $attr["SRC"]);
break;
case "ASSIGN":
switch ($attr["TYPE"]) {
case "var":
	if ($attr["BLOCK"] == $this->name)
		$this->body->ReplaceSingle($attr["VAR"],$attr["VAL"],TRUE);
	else
		$this->blocks[$attr["BLOCK"]]->ReplaceSingle($attr["VAR"],$attr["VAL"]);
break;
case "tpl":
	$parse = TRUE;
	if ($attr["REQUIRES"] != "")
		if ($GLOBALS["_TSM"][$attr["REQUIRES"]] == "")
			$parse = FALSE;
	if ($parse)
		$val = GetFileContents($this->base . $attr["VAL"],TRUE);
	else
		$val = $attr["DEFAULT"];
	if ($attr["BLOCK"] == $this->name)
		$this->body->ReplaceSingle($attr["VAR"],$val,TRUE);
	else
		$this->blocks[$attr["BLOCK"]]->ReplaceSingle($attr["VAR"],$val,TRUE);
break;
case "call":
	if ($attr["BLOCK"] == $this->name)
		$this->body->ReplaceSingle($attr["VAR"],call_user_func($attr["VAL"]),TRUE);
	else
		$this->blocks[$attr["BLOCK"]]->ReplaceSingle($attr["VAR"],call_user_func($attr["VAL"]));
break;
case "module":
	if (strstr($attr["PARAMS"],",")) {
		$params = "," . $attr["PARAMS"];
		$call = "\$result = call_user_func(array(&\$base->modules[\$attr[\"MODULE\"]],\$attr[\"METHOD\"])$params);";
		echo $call;
		eval($call);
	} else {
		$call = "\$result = \$base->modules[$attr[MODULE]]->$attr[METHOD]($attr[PARAMS]);";
		eval($call);							
		}
	if ($attr["BLOCK"] == $this->name)
		$this->body->ReplaceSingle($attr["VAR"],$result,TRUE);
	else
		$this->blocks[$attr["BLOCK"]]->ReplaceSingle($attr["VAR"],$result,TRUE);
break;
}
break;
}
}
function Load($file_name) {
if (file_exists($file_name)) {
parent::Parse($this->data = GetFileContents($file_name));
$this->loaded = TRUE;
} else
$this->loaded = FALSE;
}
function Replace($vars) {
$this->body->Replace($vars,FALSE);
}
function BlockReplace($block,$vars) {
$this->blocks[$block]->Replace($vars,FALSE);
}
function BlockExists($block) {
if (isset($this->blocks[$block]))
return TRUE;
else
return FALSE;
}
function Build() {
global $_TSM;
if ($this->loaded == FALSE)
return;
$vars = array();
if (is_array($this->blocks)) {
foreach ($this->blocks as $key => $block) {
if ($_TSM[$key])
$this->BlockReplace($key,$_TSM[$key]);
$vars[$key] = $block->output;
}
foreach ($_TSM as $k => $v)
if (!$this->BlockExists($k))
$vars[$k] = $v;
$vars = array_merge($vars,$_TSM["_PERM"]);
$this->body->Replace($vars,FALSE);
} else
$this->body->Replace($_TSM,FALSE);
}
function Show() {
print($this->body->output);
}
}
?>
