<?php
	function FileExt($filename) {
		if (!strstr($filename, "."))
			return array("0"=>$filename,"1"=>"");
		$filename = strrev($filename);
		$extpos = strpos($filename , ".");
		$file = strrev(substr($filename , $extpos + 1));
		$ext = strrev(substr($filename ,  0 , $extpos));
		return array("0"=>$file,"1"=>$ext);
	}
function UploadFile($source, $destination , $name ="") {
	$name = $name ? $name : basename($source);
	$name = FileExt($name);
	$name[2]= $name[0];
	$counter = 0 ;
	while (file_exists( $destination . $name[0] . "." . $name[1] )) {
		$name[0] = $name[2] . $counter;
		$counter ++;
	}
	copy($source , $destination . $name[0] . "." . $name[1] );
	@chmod($destination . $name[0] . "." . $name[1] , 0777);
}
function UploadFileFromWeb($source, $destination , $name) {
	$name = FileExt($name);
	$name[2]= $name[0];
	$counter = 0 ;
	while (file_exists( $destination . $name[0] . "." . $name[1] )) {
		$name[0] = $name[2] . $counter;
		$counter ++;
	}
	SaveFileContents($destination . $name[0] . "." . $name[1] , $source);
	@chmod($destination . $name[0] . "." . $name[1] , 0777);
}
function GetFileContents($file_name) {
 	$file = fopen($file_name,"r");
	if (!$file)
		return null;
	if (strstr($file_name,"://"))
		while (!feof($file))
			$result .= fread($file,1024);
	else
		$result = @fread($file,filesize($file_name));
	fclose($file);
	return $result;
}
function SaveFileContents($file_name,$content) {
	$file = fopen($file_name,"w");
	fwrite($file,$content);
	fclose($file);
}
function Debug($what,$pre = 1,$die = 0) {
	if (PB_DEBUG_EXT == 1) {
		if ($pre == 1)
			echo "<pre style=\"background-color:white;\">";
		print_r($what);
		if ($pre == 1)
			echo "</pre>";
		if ($die == 1)
			die;
	}
}
function SendMail($to,$from,$subject,$message,$to_name,$from_name) {	
	if ($to_name)
		$to = "$to_name <$to>";
	$headers  = "MIME-Version: 1.0\n";
	$headers .= "Content-type: text; charset=iso-8859-1\n";
	if ($from_name) {
		$headers .= "From: $from_name <$from>\n";
		$headers .=	"Reply-To: $from_name <$from>\n";
	}
	else {
		$headers .= "From: $from\n";
		$headers .=	"Reply-To: $from\n";
	}
	$headers .=	"X-Mailer: PHP/" . phpversion();
	return mail($to, $subject, $message,$headers);		
}
function FillVars($var,$fields,$with) {
	$fields = explode (",",$fields);
	foreach ($fields as $field)
		if (!$var[$field])
			!$var[$field] = $with;
	return $var;
}
function CleanupString($string,$strip_tags = TRUE) {
	$string = addslashes(trim($string));
	if ($strip_tags)
		$string = strip_tags($string);
	return $string;
}
define("RX_EMAIL","^[a-z0-9]+([_\\.-][a-z0-9]+)*@([a-z0-9]+([\.-][a-z0-9]+)*)+\\.[a-z]{2,}$");
define("RX_CHARS","[a-z\ ]");
define("RX_DIGITS","[a-z0-9]"); 
define("RX_ALPHA","[^a-z0-9_]");
define("RX_ZIP","[0-9\-]"); 
define("RX_PHONE","[0-9\-\+\(\)]");
function CheckString($string,$min,$max,$regexp = "",$rx_result = FALSE) {
	if (get_magic_quotes_gpc() == 0)
		$string = CleanupString($string);
	if ($regexp == RX_DIGITS) 
		$string == intval($string);
	if (strlen($string) < $min)
		return 1;
	elseif (($max != 0) && (strlen($string) > $max))
		return 2;
	elseif ($regexp != "") {
			if ($regexp == RX_DIGITS) {
				return $string == intval($string) ? 3 : 0; 
			} else
			if ($rx_result == eregi($regexp,$string))
				return 3;
		}
	return 0;
}
function ValidateVars($source,$vars) {
	$vars = explode(",",$vars);
	foreach ($vars as $var) {
		list($name,$type,$min,$max) = explode(":",$var);
		switch ($type) {
			case "S":
				$type = RX_CHARS;
				$rx_result = FALSE;
			break;
			case "I":
				$type = RX_DIGITS;
				$rx_result = false;
			break;
			case "E":
				$type = RX_EMAIL;
				$rx_result = FALSE;
			break;
			case "P":
				$type = RX_PHONE;
				$rx_result = TRUE;
			break;
			case "Z":
				$type = RX_ZIP;
				$rx_result = FALSE;
			break;
			case "A":
				$type = "";
			break;
			case "F":
				$type = RX_ALPHA;
				$rx_result = TRUE;
			break;
		}
		if (($result = CheckString($source[strtolower($name)],$min,$max,$type,$rx_result)) != 0)
			$errors[] = $name;
	}	
	return is_array($errors) ? $errors : 0;
}
function ResizeImage($source,$destination,$size) {
	if (PB_IMAGE_MAGICK == 1)
		system( PB_IMAGE_MAGICK_PATH . "convert $source -resize {$size}x{$size} $destination");
	else
		copy($source,$destination);
}
function GetMicroTime() {
	list($usec,$sec) = explode(" ",microtime());
	return (float) $usec + (float) $sec;
}
function GetArrayPart($input,$from,$count) {
	$return = array();
	$max = count($input);
	for ($i = $from; $i < $from + $count; $i++ ) 
		if ($i<$max)
			$return[] = $input[$i];
	return $return;	
}
function ReplaceAllImagesPath($htmldata,$image_path) {
	$htmldata = stripslashes($htmldata);
	$htmldata = str_replace("<IMG","<img",$htmldata);
	preg_match_all("'<img.*?>'si",$htmldata,$images);
	foreach ($images[0] as $image)
		$htmldata = str_replace($image,ReplaceImagePath($image,$image_path),$htmldata);
	return $htmldata;
}
function ReplaceImagePath($image,$replace) {
	$image = stripslashes($image);
	$image = str_replace("<","",$image);
	$image = str_replace(">","",$image);
	$image_arr = explode(" ",$image);
	for ($i = 0;$i < count($image_arr) ;$i++ ) {
		if (stristr($image_arr[$i],"src")) {
			$image_arr[$i] = explode("=",$image_arr[$i]);
			$image_arr[$i][1] = str_replace("'","",$image_arr[$i][1]);
			$image_arr[$i][1] = str_replace("\"","",$image_arr[$i][1]);
			$image_arr[$i][1] = strrev(substr(strrev($image_arr[$i][1]),0,strpos(strrev($image_arr[$i][1]),"/")));
			$image_arr[$i][1] = "\"" . $replace . $image_arr[$i][1] . "\"";
			$image_arr[$i] = implode ("=",$image_arr[$i]);
		}		
	}	
	return "<" . implode(" ",$image_arr) . ">";
}
function DowloadAllImages($images,$path) {	
	foreach ($images as $image)
		@SaveFileContents($path ."/".ExtractFileNameFromPath($image),@implode("",@file($image)));	
}
function GetAllImagesPath($htmldata) {
	$htmldata = stripslashes($htmldata);
	$htmldata = str_replace("<IMG","<img",$htmldata);
	preg_match_all("'<img.*?>'si",$htmldata,$images);
	foreach ($images[0] as $image)
		$images_path[] = GetImageName($image);
	return $images_path;
}
function GetImagePath($image) {
	$image = stripslashes($image);
	$image = str_replace("<","",$image);
	$image = str_replace(">","",$image);
	$image_arr = explode(" ",$image);
	for ($i = 0;$i < count($image_arr) ;$i++ ) {
		if (stristr($image_arr[$i],"src")) {
			$image_arr[$i] = explode("=",$image_arr[$i]);
			$image_arr[$i][1] = str_replace("'","",$image_arr[$i][1]);
			$image_arr[$i][1] = str_replace("\"","",$image_arr[$i][1]);
			return strrev(substr(strrev($image_arr[$i][1]),0,strpos(strrev($image_arr[$i][1]),"/")));;
		}		
	}	
	return "";
}
function GetImageName($image) {
	$image = stripslashes($image);
	$image = str_replace("<","",$image);
	$image = str_replace(">","",$image);
	$image_arr = explode(" ",$image);
	for ($i = 0;$i < count($image_arr) ;$i++ ) {
		if (stristr($image_arr[$i],"src")) {
			$image_arr[$i] = explode("=",$image_arr[$i]);
			$image_arr[$i][1] = str_replace("'","",$image_arr[$i][1]);
			$image_arr[$i][1] = str_replace("\"","",$image_arr[$i][1]);
			return $image_arr[$i][1];
		}		
	}	
	return "";
}
function ExtractFileNameFromPath($file) {
	return basename($file);
}
function RemoveArraySlashes($array) {
	if ($array)		
		foreach ($array as $key => $item)
			if (is_array($item)) 
				$array[$key] = RemoveArraySlashes($item);
			else		
				$array[$key] = stripslashes($item);
	return $array;
}
function AddArraySlashes($array) {
	if ($array)		
		foreach ($array as $key => $item)
			if (is_array($item)) 
				$array[$key] = AddArraySlashes($item);
			else		
				$array[$key] = addslashes($item);
	return $array;
}
function Ahtmlentities($array) {
	if (is_array($array))		
		foreach ($array as $key => $item)
			if (is_array($item)) 
				$array[$key] = ahtmlentities($item);
			else		
				$array[$key] = htmlentities(stripslashes($item),ENT_COMPAT);
	else
		return htmlentities(stripslashes($array),ENT_COMPAT);
	return $array;
}
function AStripSlasshes($array) {
	if (is_array($array))		
		foreach ($array as $key => $item)
			if (is_array($item)) 
				$array[$key] = AStripSlasshes($item);
			else		
				$array[$key] = stripslashes($item);
	else
		return stripslashes($array);
	return $array;
}
function Ahtml_entity_decode($array) {
	if ($array)	
		foreach ($array as $key => $item)
			if (is_array($item))
				$array[$key] = ahtml_entity_decode($item);
			else		
				$array[$key] = html_entity_decode($item,ENT_COMPAT);
	return $array;
}
function array2xml ($name, $value, $indent = 1)
{
 $indentstring = "\t";
 for ($i = 0; $i < $indent; $i++)
 {
   $indentstring .= $indentstring;
 }
 if (!is_array($value))
 {
   $xml = $indentstring.'<'.$name.'>'.$value.'</'.$name.'>'."\n";
 }
 else
 {
   if($indent === 1)
   {
     $isindex = False;
   }
   else
   {
     $isindex = True;
     while (list ($idxkey, $idxval) = each ($value))
     {
       if ($idxkey !== (int)$idxkey)
       {
         $isindex = False;
       }
     }
   }
   reset($value);  
   while (list ($key, $val) = each ($value))
   {
     if($indent === 1)
     {
       $keyname = $name;
       $nextkey = $key;
     }
     elseif($isindex)
     {
       $keyname = $name;
       $nextkey = $name;
     }
     else
     {
       $keyname = $key;
       $nextkey = $key;
     }
     if (is_array($val))
     {
       $xml .= $indentstring.'<'.$keyname.'>'."\n";
       $xml .= array2xml ($nextkey, $val, $indent+1);
       $xml .= $indentstring.'</'.$keyname.'>'."\n";
     }
     else
     {
       $xml .= array2xml ($nextkey, $val, $indent);
     }
   }
 }
 return $xml;
}
function GetPhpContent($file) {
	if (file_exists($file) ) {
		$data = GetFileContents($file);
		$data = str_replace("<?php","",$data);
		$data = str_replace("?>","",$data);
		return $data;
	}
}
function KeyArray($array,$recurse = 0 , $count = 1) {
	if (is_array($array)) {
		foreach ($array as $key => $val) {
			$array[$key]["key"] = $count ++;
			if ($recurse) {
				foreach ($array[$key] as $k => $val)
					if (is_array($val)) {
						KeyArray($array[$key][$k] , $recurse , &$count);
					}													
			}			
		}		
	}
	return $count + 1;
}
function RandomWord( $passwordLength ) {
    $password = "";
    for ($index = 1; $index <= $passwordLength; $index++) {
         $randomNumber = rand(1, 62);
         if ($randomNumber < 11)
              $password .= Chr($randomNumber + 48 - 1); 
         else if ($randomNumber < 37)
              $password .= Chr($randomNumber + 65 - 10); 
         else
              $password .= Chr($randomNumber + 97 - 36); 
    }
    return $password;
}
function DeleteFolder($file) {
 if (file_exists($file)) {
   chmod($file,0777);
   if (is_dir($file)) {
     $handle = opendir($file); 
     while($filename = readdir($handle)) {
       if ($filename != "." && $filename != "..") {
         DeleteFolder($file."/".$filename);
       }
     }
     closedir($handle);
     rmdir($file);
   } else {
     unlink($file);
   }
 }
}
	function GenerateRecordID($array) {
		$max = 0;
		if (is_array($array)) {
			foreach ($array as $key => $val)
				$max = ($key > $max ? $key : $max);
			return $max + 1;
		}
		else return 1;
	}
function CryptLink($link) {
	if (defined("PB_CRYPT_LINKS") && (PB_CRYPT_LINKS == 1)) {
		if (stristr($link,"javascript:")) {
		} else {
			$url = @explode("?" , $link);
			if (!is_array($url))
				$url[0] = $link;
			$tmp = str_replace( $url[0] . "?" , "" , $link);	
			$uri = urlencode(urlencode(base64_encode(str_rot13($tmp))));
			$link = $url[0] . "?" . $uri . md5($uri);
		}
	}	
	return $link;
}
if (defined("PB_CRYPT_LINKS") && (PB_CRYPT_LINKS == 1) ) {
	$key = key($_GET);
	if (is_array($_GET) && (count($_GET) == 1) && ($_GET[$key] == "")) {
		$tmp = $_SERVER["QUERY_STRING"];
		$md5 = substr($tmp , -32);
		$tmp = substr($tmp , 0 , strlen($tmp) - 32);
		if ($md5 != md5($tmp)) {
			die("Please dont change the links!");
		}
		$tmp = str_rot13(base64_decode(urldecode(urldecode($tmp))));
		$tmp_array = @explode("&" , $tmp);
		$tmp_array = is_array($tmp_array) ? $tmp_array : array($tmp);
		if (is_array($tmp_array)) {
			foreach ($tmp_array as $key => $val) {
				$tmp2 = explode("=" , $val);
				$out[$tmp2[0]] = $tmp2[1];
			}				
		} else {
			$tmp2 = explode("=" , $tmp);
			$out[$tmp2[0]] = $tmp2[1];
		}
		$_GET = $out;
	}	
}
function ArrayReplace($what , $with , $array ) {
	if ($array)	
		foreach ($array as $key => $item)
			if (is_array($item))
				$array[$key] = ArrayReplace($what , $with , $item);
			else		
				$array[$key] = str_replace($what , $with , $item);
	return $array;
}
function stri_replace( $find, $replace, $string )
{
   $parts = explode( strtolower($find), strtolower($string) );
   $pos = 0;
   foreach( $parts as $key=>$part ){
       $parts[ $key ] = substr($string, $pos, strlen($part));
       $pos += strlen($part) + strlen($find);
       }
   return( join( $replace, $parts ) );
}
function GMTDate($format , $date) {
	global $_GMT;
	return date($format , $date - $_GMT);
}
function putcsv ($array, $deliminator=",") {
	$line = "";
	foreach($array as $val) {
		$val = str_replace("\r\n", "\n", $val);
		if(ereg("[$deliminator\"\n\r]", $val)) {
			 $val = '"'.str_replace('"', '""', $val).'"';
		}
		$line .= $val.$deliminator;
	}
	$line = substr($line, 0, (strlen($deliminator) * -1));
	$line .= "\n";
	return $line;
}
function fputcsv ($fp, $array, $deliminator=",") {
	return fputs($fp, putcsv($array,$delimitator));
}
function is_subaction($sub,$action) {
	return (bool)($_GET["sub"] == $sub) && ($_GET["action"] == $action);
}
function striphtmltags ( $text ) {
	$search = array ("'<script[^>]*?>.*?</script>'si",  
					"'<[\/\!]*?[^<>]*?>'si"           
					);                    
	$replace = array ("", 
					 ""
					); 
	return preg_replace ($search, $replace, $text); 
}
function ArrayValueByKey($array, $key) {
	return $array[$key];
}
function FormatSize($file) {
   if(is_file($file)) {	   
	   $size = filesize($file);
   } else
	   $size = $file;
   $kb = 1024;         
   $mb = 1024 * $kb;   
   $gb = 1024 * $mb;   
   $tb = 1024 * $gb;   
   if($size < $kb) {
	   return $size." B";
   }
   else if($size < $mb) {
	   return round($size/$kb,2)." KB";
   }
   else if($size < $gb) {
	   return round($size/$mb,2)." MB";
   }
   else if($size < $tb) {
	   return round($size/$gb,2)." GB";
   }
   else {
	   return round($size/$tb,2)." TB";
   }
}
function get_real_size($size=0) {
        if (!$size) {
            return 0;
        }
        $scan['MB'] = 1048576;
        $scan['Mb'] = 1048576;
        $scan['M'] = 1048576;
        $scan['m'] = 1048576;
        $scan['KB'] = 1024;
        $scan['Kb'] = 1024;
        $scan['K'] = 1024;
        $scan['k'] = 1024;
        while (list($key) = each($scan)) {
            if ((strlen($size)>strlen($key))&&(substr($size, strlen($size) - strlen($key))==$key)) {
                $size = substr($size, 0, strlen($size) - strlen($key)) * $scan[$key];
                break;
            }
        }
        return $size;
    } 
function html_print_r($object, $returnValue = false) {
   $output = print_r($object, true);
   $output = htmlentities($output);
   $output = str_replace(" ", "&nbsp;", $output);
   $output = nl2br($output);
   if ($returnValue) {
       return $output;
   } else {
       echo $output;
       return true;
   }
}
?>
