  function str_replace(oldS,newS,fullS) 
  {
     for (var i=0; i<fullS.length; i++) 
	 {      
		if (fullS.substring(i,i+oldS.length) == oldS) 
		{         
			fullS = fullS.substring(0,i)+newS+fullS.substring(i+oldS.length,fullS.length)      
		}   
	  }   
	  return fullS
  }


function delay(gap){ /* gap is in millisecs */
	var then , now; 
	then = new Date().getTime();
	now = then;

	while((now-then) < gap) {
			now=new Date().getTime();
	}
}


function HTMLBuilder (field_name , width , height) {
	
	//setting the default config vars
	this._HBname = field_name;
	this._HBwidth = width;
	this._HBheight = height;
	this._HBmode = "html";
	this._HBtoolbars = new Array();

	//checking for browser compatibility
}

//detect the browser
HTMLBuilder.agt = navigator.userAgent.toLowerCase();
HTMLBuilder._browserIE = ((HTMLBuilder.agt.indexOf("msie") != -1) && (HTMLBuilder.agt.indexOf("opera") == -1));
HTMLBuilder._browserMAC = (HTMLBuilder.agt.indexOf("mac") != -1);
HTMLBuilder._browserMACIE = (HTMLBuilder._browserIE && HTMLBuilder._browserMACIE);
HTMLBuilder._browserWINIE = (HTMLBuilder._browserIE && !HTMLBuilder._browserMACIE);
HTMLBuilder._browserMOZILLA = (navigator.product == "Gecko");


/**
* description
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype.Compatible = function () {
	
	//checking if the product is newer then mozila blabla
	if ((HTMLBuilder._browserMOZILLA)&&(navigator.productSub < 20031010)) 
		return false;

	return HTMLBuilder._browserMOZILLA || HTMLBuilder._browserIE; 
}

/**
* description
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype.Init = function () {
	if (!this.Compatible())
		return null;

	
	//iframe for html editor
	this._HBiframe = document.getElementById( this._HBname + "_iframe");


	var proc_Wexists = ( str_replace("%" , "" , this._HBwidth) == this._HBwidth );
	var proc_Hexists = ( str_replace("%" , "" , this._HBheight) == this._HBheight );

	//changinf the size
	this._HBiframe.style.height = this._HBheight //+ ( proc_Hexists ? "" : "px");
	this._HBiframe.style.width = this._HBwidth //+ ( proc_Wexists ? "" : "px");

	//textarea for source edit mode
	this._HBtextarea = document.getElementById( this._HBname);

	//changinf the size
	this._HBtextarea.style.height = this._HBheight //+ ( proc_Hexists ? "" : "px");
	this._HBtextarea.style.width = this._HBwidth //+ ( proc_Wexists ? "" : "px");

	//after some rtfm seems i have to wait a sec before initializing the iframe ... so sleep for 0.1 seconds.
	delay(100);
	this._privateInitIframe ();
}

HTMLBuilder.prototype._privateRegisterEvent = function ( form , event , func ) {
	if (HTMLBuilder._browserIE) {
		for (var i in event) 
			form.attachEvent("on" + event[i], func);
	} else {
		for (var i in event) 
			form.addEventListener(event[i], func, true);
	}
}
/**
* description
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype._privateInitIframe = function () {

	//checking for browser 
	if (this._browserIE) {
		//IE
		this._HBiframe.contentWindow.document.body.contentEditable = true;
	} else {
		//MOZILLA
		this._HBiframe.contentWindow.document.designMode = "on";		
	}
	//save a shortcut to this._HBiframe.contentWindow.document
	this._HBeditor = this._HBiframe.contentWindow.document;

	
	//opening the document for writing
	this._HBiframe.contentWindow.document.open();
	//writing the html page
	var html = "<html><head></head><body>" + "</body></html>";
	this._HBiframe.contentWindow.document.write(html);
	//close
	this._HBiframe.contentWindow.document.close();

	//adding the content
	this._privateSetHTML(this._HBtextarea.value);

	//i cant access this in other function so i create a pointer to it.
	var editor = this;

	this._privateRegisterEvent(this._HBiframe.contentWindow.document,["keyup", "mousedown", "mouseup", "drag"] , 	function () {
				//cheking for editing mode
				if (editor._HBmode == "html") {
					//if html the get the content from iframe and store it on textarea
					editor._HBtextarea.value=editor._privateGetHTML();					
				}
			}
	)
	//focus editor
	this._privateFocus(); 
}

/**
* description
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype._privateFocus = function () {
		
	//if html the focus the iframe
	if (this._HBmode == "html") {
		this._HBiframe.contentWindow.focus();
	} else {
		//checking for browser 
		if (this._browserIE) {
			//else focus the textarea
			this._HTBtexarea.focus();			
		}
	}
}

HTMLBuilder.prototype._privateUpdateValue = function () {
	if (this._HBmode == "html") {
			//if html the get the content from iframe and store it on textarea
			this._HBtextarea.value=this._privateGetHTML();			
		}
}

/**
* description
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype._privateGetHTML = function () {
	//checking for edirting mode
	if (this._HBmode == "html") {
		//checking for browser
		if ( HTMLBuilder._browserIE )
			return this._HBiframe.contentWindow.document.body.innerHTML;
		else
			return this._HBiframe.contentWindow.document.body.innerHTML;
	} else {
		//edit source mode ... under construction 
		if ( HTMLBuilder._browserIE ) {
		} else {
			var html = this._HBiframe.contentWindow.document.body.ownerDocument.createRange();
			html.selectNodeContents(this._HBiframe.contentWindow.document.body);
			return html.toString();
		}
	}
}

/**
* function got, modified from the mozilla exemple editor http://www.mozilla.org/editor/midasdemo/
* Copyright  1998-2004 The Mozilla Organization
*/
HTMLBuilder.prototype.insertNodeAtSelection = function (insertNode) {
	// get current selection
	var sel = this._privateSelection();
	
	// get the first range of the selection
	// (there's almost always only one range)
	var range = this._privateRange(sel);

	// deselect everything
	sel.removeAllRanges();

	// remove content of current selection from document
	range.deleteContents();

	// get location of current selection
	var node = range.startContainer;
	var pos = range.startOffset;

	switch (node.nodeType) {
		case 3:
			// we have to split it at the caret position.
			if (insertNode.nodeType == 3) {
				// do optimized insertion
				node.insertData(pos, insertNode.data);
				
				// make a new range for the new selection      
				range = this._privateRange();

				range.setEnd(node, pos + insertNode.length);
				range.setStart(node, pos + insertNode.length);
				sel.addRange(range);
			} else {
				node = node.splitText(pos);
				var selnode = insertNode;
				if (insertNode.nodeType == 11) {
					selnode = selnode.firstChild;
				}
				node.parentNode.insertBefore(insertNode, node);

				range.selectNodeContents(node);
				//(collapsed) && range.collapse(pos);
				sel.removeAllRanges();
				sel.addRange(range);

			}
		break;

		default:
			var selnode = insertNode;
			if (insertNode.nodeType == 11) {
				selnode = selnode.firstChild;
			}
			node.insertBefore(insertNode, node.childNodes[pos]);
			//this.selectNodeContents(selnode);
			range.selectNodeContents(node);
			//(collapsed) && range.collapse(pos);
			sel.removeAllRanges();
			sel.addRange(range);
		break;
	}

}
/**
* description
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype._privateSetHTML = function ( html ) {


	if ( HTMLBuilder._browserIE ) {

		this._privateFocus(); 
		this._privateRange( this._privateSelection() ).pasteHTML( html );

	} else {

		var fragment = this._HBiframe.contentWindow.document.createDocumentFragment();
		var div = this._HBiframe.contentWindow.document.createElement("div");
		div.innerHTML = html;
		while (div.firstChild) {
			// the following call also removes the node from div
			fragment.appendChild(div.firstChild);
		}
		// this also removes the selection
		var node = this.insertNodeAtSelection(fragment);

		this._privateFocus(); 
	}
}


/**
* description
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype._privateSelection = function () {

	if (HTMLBuilder._browserIE)
		return this._HBiframe.contentWindow.document.selection;
	else
		return this._HBiframe.contentWindow.getSelection();
}


/**
* description
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype._privateRange = function ( selection ) {

	if (HTMLBuilder._browserIE)
		return selection.createRange();
	else {

		if (typeof selection != "undefined")
			return selection.getRangeAt(0);
		else
			return this._HBiframe.contentWindow.document.createRange();		
	}
}


/**
* description switches the editiing mode between html and source
*
* @param
*
* @return
*
* @access
*/
HTMLBuilder.prototype._privateSwitchMode = function (){
	if (this._HBmode == "html"){
		//switch to textmode
		this._HBiframe.style.display = "none";
		this._HBtextarea.style.display = "inline";
		this._HBtextarea.value = this._HBiframe.contentWindow.document.body.innerHTML ;

		//here hide the toolbars

		this._HBmode = "text";

	} else {
		this._HBiframe.style.display = "inline";
		this._HBtextarea.style.display = "none";
		this._HBiframe.contentWindow.document.body.innerHTML = this._HBtextarea.value;

		this._HBmode = "html";
	}
}

HTMLBuilder.prototype._privateExecCommand = function ( cmd , flag , params ) {
	if (HTMLBuilder._browserIE) {
		alert(cmd);
		this._HBiframe.contentWindow.document.execCommand(cmd, flag , params );
		//document.getElementById(this._HBname).document.execCommand('cut',false,null);
		this._privateUpdateValue();
		this._privateFocus(); 
	} else {
		this._HBiframe.contentWindow.document.execCommand(cmd, flag , params );
		this._privateUpdateValue();
		this._privateFocus(); 
	}
}

HTMLBuilder.prototype._insertHTML = function(html) {
	var sel = this._privateSelection();
	var range = this._privateRange(sel);
	if (HTMLBuilder._browserIE) {
		range.pasteHTML(html);
	} else {
		// construct a new document fragment with the given HTML
		var fragment = this._HBiframe.contentWindow.document.createDocumentFragment();
		var div = this._HBiframe.contentWindow.document.createElement("div");
		div.innerHTML = html;
		while (div.firstChild) {
			// the following call also removes the node from div
			fragment.appendChild(div.firstChild);
		}
		// this also removes the selection
		var node = this.insertNodeAtSelection(fragment);
	}
};


HTMLBuilder.prototype.InsertLink = function() {
	var win = NewWindow("htmleditor/windows/insertlink.htm?editor=" + this._HBname, "insertlink", 400, 250, "no");
}
HTMLBuilder.prototype.InsertResource = function() {
	var win = NewWindow("htmleditor/rm/?editor=" + this._HBname, "insertresource", 868, 505, "no");
}

//buttons section


var _menu = new Array();
	_menu["cut"] = new Array ("Cut" , false , "cut" , "Cut..." , "_privateExecCommand('Cut');" , "" , false );
	_menu["copy"] = new Array ("Copy" , false , "copy" , "Copy..." , "_privateExecCommand('Copy');" , "" , false );
	_menu["paste"] = new Array ("Paste" , false , "paste" , "Paste..." , "_privateExecCommand('Paste');" , "" , false );
	_menu["undo"] = new Array ("Undo" , false , "undo" , "Undo..." , "_privateExecCommand('Undo');" , "" , false );
	_menu["undo"] = new Array ("Undo" , false , "undo" , "Undo..." , "_privateExecCommand('Undo');" , "" , false );
	_menu["redo"] = new Array ("Redo" , false , "redo" , "Redo..." , "_privateExecCommand('Redo');" , "" , false );
	_menu["removeformat"] = new Array ("RemoveFormat" , false , "remove_format" , "Remove Text Format" , "_privateExecCommand('RemoveFormat');" , "" , false );
	_menu["bold"] = new Array ("Bold" , false , "bold" , "Bold" , "_privateExecCommand('bold');" , "2" , false );
	_menu["italic"] = new Array ("Italic" , false , "italic" , "Italic" , "_privateExecCommand('italic');" , "2" , false );
	_menu["underline"] = new Array ("Underline" , false , "underline" , "Underline" , "_privateExecCommand('underline');" , "2" , false );
	_menu["strike"] = new Array ("Strikethrough" , false , "strikethrough" , "Strike Through" , "_privateExecCommand('Strikethrough');" , "2" , false );
	_menu["justifyleft"] = new Array ("JustifyLeft" , false , "align_left" , "Align Left" , "_privateExecCommand('JustifyLeft');" , "2" , false );
	_menu["justifycenter"] = new Array ("JustifyCenter" , false , "align_center" , "Align Center" , "_privateExecCommand('JustifyCenter');" , "2" , false );
	_menu["justifyright"] = new Array ("JustifyRight" , false , "align_right" , "Align Right" , "_privateExecCommand('JustifyRight');" , "2" , false );
	_menu["justifyfull"] = new Array ("JustifyFull" , false , "align_justify" , "Justify" , "_privateExecCommand('JustifyFull');" , "2" , false );
	_menu["findreplace"] = new Array ("FindReplace" , false , "search" , "Find / Replace" , "HTMLEditorFindQuery();" , "" , false );
	_menu["superscript"] = new Array ("SuperScript" , false , "superscript" , "Superscript..." , "_privateExecCommand('superscript');" , "2" , false );
	_menu["subscript"] = new Array ("SubScript" , false , "subscript" , "Subscript..." , "_privateExecCommand('subscript');" , "2" , false );
	_menu["insertorderedlist"] = new Array ("InsertOrderedList" , false , "numbers" , "Insert Ordered List" , "_privateExecCommand('InsertOrderedList');" , "2" , false );
	_menu["insertunorderedlist"] = new Array ("InsertUnorderedList" , false , "bullets" , "Insert Unordered List" , "_privateExecCommand('InsertUnOrderedList');" , "2" , false );
	_menu["indent"] = new Array ("Indent" , false , "increase_indent" , "Increase Indent" , "_privateExecCommand('Indent');" , "" , false );
	_menu["outdent"] = new Array ("Outdent" , false , "decrease_indent" , "Decrease Indent" , "_privateExecCommand('outdent');" , "" , false );
	_menu["fontcolor"] = new Array ("FontColor" , false , "font_color" , "Change Font Color" , "showMenu('colorMenu',180,291);" , "" , false );
	_menu["backgroundcolor"] = new Array ("BackgroundColor" , false , "highlight" , "Change Background Color" , "showMenu('colorMenu2',180,291);" , "" , false );
	_menu["inserthr"] = new Array ("InsertHR" , false , "hr" , "Insert Horizontal Line" , "_privateExecCommand('InsertHorizontalRule');" , "" , false );
	_menu["insertresource"] = new Array ("InsertResource" , false , "image" , "Insert Resource ( image, documents ... )" , "HTMLEditorInsertImageQuery();" , "" , false );
	_menu["tablemenu"] = new Array ("TableMenu" , false , "table_down" , "Tables Menus" , "HTMLEditorTableFunctionsMenu();" , "" , false );
	_menu["textbox"] = new Array ("TextBox" , false , "textbox" , "Insert Text Box" , "HTMLEditorInsertTextbox();" , "" , false );
	_menu["insertanchor"] = new Array ("InsertAnchor" , false , "anchor" , "Insert / Modify Anchor" , "HTMLEditorInsertAnchorQuery();" , "" , false );
	_menu["link"] = new Array ("Link" , false , "link" , "Insert / Modify Link" , "InsertLink();" , "" , false );
	_menu["resource"] = new Array ("Insert Resource" , false , "image" , "Insert / Modify Resource" , "InsertResource();" , "" , false );
	_menu["hightliteborders"] = new Array ("HightliteBorders" , false , "show_borders" , "Hightlite Borders" , "HTMLEditorHighliteBorders();" , "2" , false );
	_menu["absoluteposition"] = new Array ("AbsolutePosition" , false , "absolute" , "Toggle Absolute Position" , "_privateExecCommand('AbsolutePosition');" , "2" , false );
		//_menuStyle[16] = new Array ("Help" , false , "help" , "Help..." , "HTMLEditorHelp();" , "");

var _fonts = new Array("Times New Roman" , "Arial" , "Verdana, Helvetica" , "Courier" , "Comic");
var _fontsize = new Array("1" , "2" , "3" , "4" , "5" , "6" , "7");
var _fontblock = new Array("<p>" , "<h1>" , "<h2>" , "<h3>" , "<h4>" , "<h5>" , "<h6>");
var _fontblocktitle = new Array("Normal" , "Heading 1" , "Heading 2" , "Heading 3" , "Heading 4" , "Heading 5" , "Heading 6");

	var _imagespath = "htmleditor/images/htmlbuilder/";


HTMLBuilder.prototype.InitToolbar = function ( id , editor_id , data ) {		

		var html = "";
		var tmp = "";

		//saving the toolbar id and components for future updates
		this._HBtoolbars[id] = data;

		for (var i=0; i<data.length; i++ )
		{
			switch (data[i]) {

			case "separator":
				html += "<td><img UNSELECTABLE=\"on\" src=\"" + _imagespath + "separator.gif\"></td>";
			break;

			case "toolbar":
				html += "<td><img src=\"" + _imagespath + "toolbar.gif\"></td> \n" ;
			break;

			case "font-family":
				tmp = "";
				for (var j=0; j<_fonts.length; j++ )
					tmp += "<option style=\"font-family:" + _fonts[j] + "\" value=\"" + _fonts[j] + "\">" + _fonts[j] + "</option>";

				html += "<td><select id=\"" + editor_id + "_button_font-family\" onchange=\"" + editor_id + "._privateExecCommand('FontName',false,this.value);\">" + tmp + "</select></td>";
			break;

			case "font-size":
				tmp = "";
				for (var j=0; j<_fontsize.length; j++ )
					tmp += "<option value=\"" + _fontsize[j] + "\">" + _fontsize[j] + "</option>";

				html += "<td><select id=\"" + editor_id + "_button_font-size\" onchange=\"" + editor_id + "._privateExecCommand('FontSize',false,this.value);\">" + tmp + "</select></td>";
			break;

			case "font-header":
				tmp = "";
				for (var j=0; j<_fontblocktitle.length; j++ )
					tmp += "<option value=\"" + _fontblock[j] + "\">" + _fontblocktitle[j] + "</option>";

				html += "<td><select disabled id=\"" + editor_id + "_button_font-block\" onchange=\"" + editor_id + "._privateExecCommand('FontBlock',false,this.value);\">" + tmp + "</select></td>";
			break;

			default:
				//checking if i have 2 images
				if (_menu[data[i]][1]) {
					//i have a disabled image and a enable one
					html += "<td>" +
							"	<img UNSELECTABLE=\"on\" disabled id=\"" + editor_id + "_button_" + _menu[data[i]][0].toLowerCase() + "OFF\" src=\"" + _imagespath + "button_" + _menu[data[i]][2] + "_disabled.gif\" title=\"" + _menu[data[i]][3] + "\" style=\"display:inline; border: #eeeeee solid 1px\">" +
							"	<img UNSELECTABLE=\"on\" id=\"" + editor_id + "_button_" + _menu[data[i]][0].toLowerCase() + "ON\" title=\"" + _menu[data[i]][3] + "\" src=\"" + _imagespath + "button_" + _menu[data[i]][2] + ".gif\" onclick=\"" + editor_id + "." + _menu[data[i]][4] + "\" onmousedown=\"ToolbarButtonDown(this);\"  onmouseover=\"ToolbarButtonOver(this);\" onmouseout=\"ToolbarButtonOut" + _menu[data[i]][5] + "(this);\" style=\"display:none;border: #eeeeee solid 1px;\" >" +
							"</td>";
				} else {
					//i have a single image
					html += "<td>" +
							"	<img width=\"21\" height=\"20\" unselectable=\"on\" id=\"" + editor_id + "_button_" + _menu[data[i]][0].toLowerCase() + "\" title=\"" + _menu[data[i]][3] + "\" src=\"" + _imagespath + "button_" + _menu[data[i]][2] + ".gif\" onclick=\"" + editor_id + "." + _menu[data[i]][4] + "\" onmousedown=\"ToolbarButtonDown(this);\"  onmouseover=\"ToolbarButtonOver(this);\" onmouseout=\"ToolbarButtonOut" + _menu[data[i]][5] + "(this);\" style=\"border: #eeeeee solid 1px;\" >" +
							"</td>";
				}
			break;
			}
		}

		//boilding teh buttons toolbar
		html = 
			"<table bgcolor=\"#EEEEEE\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"> \n" +
			"	<tr> \n" +
			"		<td><img src=\"" + _imagespath + "toolbar.gif\"></td> \n" +
			html +
			"	</tr>\n" +
			"<tr> <td bgcolor=DDDDDD colspan=" + data.length + " height=2></td>" +
			"</table>\n";

		document.write(html);
	}

function ToolbarButtonOver(button) {
	
	if (button.style.borderBottom != "#0a246a 1px solid") {
		button.style.borderBottom = "#0A246b solid 1px";
		button.style.borderLeft = "#0A246A solid 1px";
		button.style.borderRight = "#0A246A solid 1px";
		button.style.borderTop = "#0A246A solid 1px";
		button.style.backgroundColor = "#B6BDD2";
	}
}

function ToolbarButtonDown(button) {
		button.style.borderBottom = "#0a246a 1px solid";
		button.style.borderLeft = "#0A246A solid 1px";
		button.style.borderRight = "#0A246A solid 1px";
		button.style.borderTop = "#0A246A solid 1px";
		button.style.backgroundColor = "#8592B5";
}

function ToolbarButtonOut(button) {
		button.style.borderColor = "#EEEEEE";
		button.style.backgroundColor = "transparent";
}

function ToolbarButtonOut2(button) {
	if (button.style.borderBottom != "#0a246a 1px solid") {
		button.style.borderColor = "#EEEEEE";
		button.style.backgroundColor = "transparent";
	}
} 


// dropmenus 
HTMLBuilder.prototype._privateShowMenu = function ( id , but) {
	//read the possition of the button
	var button = document.getElementById("html_editor_button_fontcolor");
//	alert(button);

	var mOffsetLeft = button.offsetLeft;
	var mOffsetParent = button.offsetParent;

	while(mOffsetParent){
		mOffsetLeft += mOffsetParent.offsetLeft;
		mOffsetParent = mOffsetParent.offsetParent;
	}

	var mOffsetTop = button.offsetTop;
	var mOffsetParent = button.offsetParent;

	while(mOffsetParent){
		mOffsetTop += mOffsetParent.offsetTop;
		mOffsetParent = mOffsetParent.offsetParent;
	}

	document.getElementById(id).style.left =  mOffsetLeft;
	document.getElementById(id).style.top =  mOffsetTop + button.offsetHeight;

	document.getElementById(id).style.visibility = "visible";
}	