<?php
if(isset($inbox)) {
$title = __('Inbox',true);
$tableCaption = __('From',true);
echo $html->link(__('Outbox',true),'/messages/outbox');
}
else {
$title = __('Outbox',true);
$tableCaption = __('To',true);
echo $html->link(__('Inbox',true),'/messages/inbox');
}
?>
<h1><?php echo $title; ?></h1>
<table>
<thead>
<tr>
<th style="width: 200px;"><?php echo $tableCaption; ?></th>
<th><?php __('Subject'); ?></th>
<th style="width: 200px;"><?php __('Date'); ?></th>
</thead>
<tbody>

<?php
foreach($messages as $message) {
$msg_class = "message";
if($message['Message']['new']) $msg_class = "new_message";
?>
<tr>
<?php if(isset($inbox)): ?>
<td><?php echo ucfirst($message['userFrom']['username']); ?></td>
<?php else: ?>
<td><?php echo ucfirst($message['userTo']['username']); ?></td>
<?php endif; ?>
<td style="text-align: left;"><?php echo $html->link($message['Message']['subject'],'/messages/read/'.$message['Message']['id'],array('class'=>$msg_class)); ?></td>
<td><?php echo $time->niceShort($message['Message']['created']) ?></td>

</tr>
<?php
}
?>
</tbody>
</table>

<?php
	echo $paginator->prev(__('« Previous ',true));
	echo $paginator->numbers();
	echo $paginator->next(__(' Next »',true));
?>