<?php
/*
 * CakeMap -- a google maps integrated application built on CakePHP framework.
 * Copyright (c) 2005 Garrett J. Woodworth : gwoo@rd11.com
 * rd11,inc : http://rd11.com
 *
 * @author      gwoo <gwoo@rd11.com>
 * @version     0.10.1311_pre_beta
 * @license     OPPL
 *
 *
 * Modified by 	Ivan Ribas <ivanrise@gmail.com>
 * Date			Nov 7, 2008
 */
class GoogleMapHelper extends Helper {

	var $errors = array();
  var $helpers = array('Html');
  
	var $key = "ABQIAAAAX03IVK3audMRTrhMwn1TmBTy4VbwYQk-hWUEAUKsnw0ZvQdh6RQ7FaTc4m4HYhX4Me7NLCyjsDur5w";

	function map($default, $style = 'width: 400px; height: 400px' )
	{
		//if (empty($default)){return "error: You have not specified an address to map"; exit();}
		$out = "<div id=\"map\" ";
		$out .= isset($style) ? "style=\"".$style."\"" : null;
		$out .= " ></div>";
		$out .= "
		<script type=\"text/javascript\">
		//<![CDATA[

		if (GBrowserIsCompatible()) 
		{	
			var map = new GMap(document.getElementById(\"map\"));
			map.addControl(new GSmallMapControl());
	//		map.addControl(new GMapTypeControl());
			map.setMapType(map.getMapTypes()[".$default['type']."]);
			map.centerAndZoom(new GPoint(".$default['long'].", ".$default['lat']."), ".$default['zoom'].");
		}
		//]]>
		</script>";

		return $out;
	}

	function addMarkers(&$data, $icon=null)
	{
		$out = "
			<script type=\"text/javascript\">
			//<![CDATA[
			if (GBrowserIsCompatible()) 
			{
			";
			
			if(is_array($data))
			{
				if($icon)
				{
					$out .= $icon;		
				}
				else
				{
					$out .= 'var icon = new GIcon();
						icon.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
						icon.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
						icon.iconSize = new GSize(12, 20);
						icon.shadowSize = new GSize(22, 20);
						icon.iconAnchor = new GPoint(6, 20);
						icon.infoWindowAnchor = new GPoint(5, 1);
					';

				}
				$i = 0;
				foreach($data as $n=>$m){
					$keys = array_keys($m);
					$point = $m[$keys[0]];
					if(!preg_match('/[^0-9\\.\\-]+/',$point['longitude']) && preg_match('/^[-]?(?:180|(?:1[0-7]\\d)|(?:\\d?\\d))[.]{1,1}[0-9]{0,15}/',$point['longitude'])
						&& !preg_match('/[^0-9\\.\\-]+/',$point['latitude']) && preg_match('/^[-]?(?:180|(?:1[0-7]\\d)|(?:\\d?\\d))[.]{1,1}[0-9]{0,15}/',$point['latitude']))
					{
						$out .= "
							var point".$i." = new GPoint(".$point['longitude'].",".$point['latitude'].");
							var marker".$i." = new GMarker(point".$i.",icon);
							map.addOverlay(marker".$i.");
							marker$i.html = \"$point[title]$point[html]\";
							GEvent.addListener(marker".$i.", \"click\", 
							function() {
								marker$i.openInfoWindowHtml(marker$i.html);
							});";
						$data[$n][$keys[0]]['js']="marker$i.openInfoWindowHtml(marker$i.html);";
						$i++;
					}
				}
			}
		$out .=	"} 
				//]]>
			</script>";
		return $out;
	}
	
	function addClick($var, $script=null)
	{
		$out = "
			<script type=\"text/javascript\">
			//<![CDATA[
			if (GBrowserIsCompatible()) 
			{
			" 
			.$script
			.'GEvent.addListener(map, "click", '.$var.', true);'
			."} 
				//]]>
			</script>";
		return $out;
	}	
	
	function addMarkerOnClick($innerHtml = null)
	{
		$mapClick = '
			var mapClick = function (overlay, point) {
				var point = new GPoint(point.x,point.y);
				var marker = new GMarker(point);
				map.addOverlay(marker)
				GEvent.addListener(marker, "click", 
				function() {
					marker.openInfoWindowHtml('.$innerHtml.');
				});
			}
		';
		return $this->addClick('mapClick', $mapClick);
		
	}	
	
	
	function showAddress($address) {
    
	  $code = '
	     <script type="text/javascript">
    //<![CDATA[

   var addressMarker;
    
   geocoder = new GClientGeocoder();

      if (geocoder) {
        geocoder.getLatLng("'.$address.'",
          function(point) {
            if (!point) {
               map.setCenter(new GLatLng(37.4419, -122.1419), 13);
               map.openInfoWindow(map.getCenter(),
                           "Sorry, I don\'t find the address:<br/>"+\''.Sanitize::clean($address).'\');

            } else {
              if (addressMarker) {
                map.removeOverlay(addressMarker);
              }
              addressMarker = new GMarker(point);
              map.setCenter(point);
 					    var lat = point.y;
					    var lng = point.x;

              map.addOverlay(addressMarker); 
              
            }
          }
        );
      }
      		//]]>
		</script>
   
	  ';
	  return $code;
	}

	function showLatLng($lat,$lng) {
	  $code = '
	     <script type="text/javascript">
    //<![CDATA[
              var point = new GLatLng('.$lat.','.$lng.');
              var addressMarker = new GMarker(point);
              map.setCenter(point);
 					    map.setZoom(15);
              map.addOverlay(addressMarker); 
      		//]]>
		</script>
	  ';
	  return $code;
	}

	function showLatLngEdit($lat,$lng) {
	  $code = '
	     <script type="text/javascript">
    //<![CDATA[
              var point = new GLatLng('.$lat.','.$lng.');
              var addressMarker = new GMarker(point,{draggable: true});
              map.setCenter(point);
 					    map.setZoom(15);

              var lat = point.y;
	            var lng = point.x;
	                      				  
            GEvent.addListener(addressMarker, "dragstart", 
                                function() {
                                  map.closeInfoWindow();
                                }
                              );

            GEvent.addListener(addressMarker, "dragend", 
                                function() {
                                point = addressMarker.getPoint();
                       					  lat = point.y;
	                      				  lng = point.x;
                                   
					var form = "<p>Move the marker and confirm the location of this event.</p><p><a href=\"#\" onClick=\"getElementById(\'EventLat\').value="+lat+";getElementById(\'EventLng\').value="+lng+";addressMarker.closeInfoWindow();return false;\">Confirm Location</a></p>";

                                  addressMarker.openInfoWindowHtml(form);
                                }
                              );
                                
					
            map.addOverlay(addressMarker); 
            
					var form = "<p style=\"min-height:100px;margin:0px;padding:0px;\">Move the marker and confirm the location of this event.<br/><a href=\"#\" onClick=\"getElementById(\'EventLat\').value="+lng+";getElementById(\'EventLng\').value="+lat+";addressMarker.closeInfoWindow();return false;\">Confirm Location</a></p>";

              addressMarker.openInfoWindowHtml(form);
              
              
      		//]]>
		</script>
	  ';
	  return $code;
	}
	
	function showAddressEdit() {
    
	  $code = '
	     <script type="text/javascript">
    //<![CDATA[

   var addressMarker;
    
   geocoder = new GClientGeocoder();
   function showAddress(address) {
   
   
      if (geocoder) {
        geocoder.getLatLng(address,
          function(point) {
              if (addressMarker) {
                map.removeOverlay(addressMarker);
              }
            if (!point) {
              point = map.getCenter();
            } else {
                map.setZoom(15);
            }
            addressMarker = new GMarker(point,{draggable: true});

            GEvent.addListener(addressMarker, "dragstart", 
                                function() {
                                  map.closeInfoWindow();
                                }
                              );

            GEvent.addListener(addressMarker, "dragend", 
                                function() {
                                point = addressMarker.getPoint();
                       					  lat = point.y;
	                      				  lng = point.x;
					var form = "<p>Move the marker and confirm the location of this event.</p><p><a href=\"#\" onClick=\"getElementById(\'EventLat\').value="+lat+";getElementById(\'EventLng\').value="+lng+";addressMarker.closeInfoWindow();return false;\">Confirm Location</a></p>";

                                  addressMarker.openInfoWindowHtml(form);
                                }
                              );
                                
            map.setCenter(point);
            point = addressMarker.getPoint();
 					  var lat = point.y;
					  var lng = point.x;

					var form = "<p>Move the marker and confirm the location of this event.</p><p><a href=\"#\" onClick=\"getElementById(\'EventLat\').value="+lat+";getElementById(\'EventLng\').value="+lng+";addressMarker.closeInfoWindow();return false;\">Confirm Location</a></p>"
										  					
            map.addOverlay(addressMarker); 
            
              addressMarker.openInfoWindowHtml(form);
                                  
          }
        );
      }
      }
      		//]]>
		</script>
   
	  ';
	  return $code;
	}
}
?>