<div id="events">

<?php 
if($city_name!='all-cities' and $current_tag!='all-tags') {
echo "<p class=\"info-line\">".sprintf(__("Events in %s tagged %s",true),$city_name, $current_tag)." | ";
echo $html->link(__('Show all',true),'/events/index/'.$city.'/all-tags')."</p>";
}
elseif($city_name!='all-cities') {
echo "<p class=\"info-line\">".sprintf(__("Events in %s",true),$city_name)." | ";
echo $html->link(__('Show all',true),'/events/index/')."</p>";
}
elseif($current_tag!='all-tags') {
echo "<p class=\"info-line\">".sprintf(__("Events tagged %s",true),$current_tag)." | ";
echo $html->link(__('Show all',true),'/events/index/'.$city.'/all-tags')."</p>";
}
?>

<?php 
if(!empty($events)):
  foreach($events as $event):
?>

<div class="post">
<div class=" vevent">
<h2 class="summary"><?php echo $html->link(ucfirst($event['Event']['name']),'/events/view/'.$event['City']['slug'].'/'.$event['Event']['slug']); ?></h2>
<p class="post-info">
<?php     echo __("Posted",true)." ".$time->timeAgoInWords($event['Event']['created']);

      if($event['User']['username']==null) {
        echo ' '.__('by',true).' '.__('Anonymous',true);
      }
      else {
        echo ' '.__('by',true).' '.$html->link(ucfirst($event['User']['username']),'/users/view/'.$event['User']['slug']);      
      }
?>
</p>

<?php 
$display_description = "block";
if(strlen($event['Event']['notes'])>200) {

?>
<p class="description" id="eventFullDescription<?php echo $event['Event']['id']?>" style="display:none"><?php echo str_replace(chr(13),"<br/>",$event['Event']['notes']);
 
echo ' '.$ajax->link($html->image('/img/minus.png'), '/', 
								array('update' => '','loading' => 'Element.toggle(\'eventFullDescription'.$event['Event']['id'].'\');', 'complete' => 'return false;', 'before' => '$(\'eventShortDescription'.$event['Event']['id'].'\').appear();'), null, false
								);
								
?></p>
<?php
echo "<p class=\"shortDescription\" id=\"eventShortDescription".$event['Event']['id']."\">".str_replace(chr(13),"<br/>",$text->truncate($event['Event']['notes'],200, '...', false));

echo $ajax->link($html->image('/img/plus.png'), '/events/view/'.$event['City']['slug'].'/'.$event['Event']['slug'], 
								array('update' => '','loading' => 'Element.toggle(\'eventShortDescription'.$event['Event']['id'].'\');', 'complete' => 'return false;', 'before' => '$(\'eventFullDescription'.$event['Event']['id'].'\').appear();'),null, false
								)."</p>";
}
else {
?>
<p class="description" id="eventFullDescription<?php echo $event['Event']['id']?>"><?php echo str_replace(chr(13),"<br/>",$event['Event']['notes']);
 ?></p>

<?php

}

?>


<div class="url">
<?php
    if(!empty($event['Event']['web'])):
      echo "<p>".$html->link($event['Event']['web'],'http://'.$event['Event']['web'],array('rel'=>'nofollow'))."</p>";
    endif;
?>
</div>

<div class="event-info">
<p>
<?php echo __('When',true).' '; ?>
<abbr class="dtstart" title="<?php echo $event['Event']['start_date']?>">
<?php echo $time->niceShort($event['Event']['start_date']); ?>
</abbr>
<abbr class="dtend" title="<?php echo $event['Event']['end_date']?>">
<?php 
    if($time->format('dmY',$event['Event']['end_date']) != $time->format('dmY',$event['Event']['start_date'])){
      echo ' '.__('until',true).' '.$time->niceShort($event['Event']['end_date']);
    }
    else {
      echo ' '.__('to',true).' '.$time->format('H:i',$event['Event']['end_date']);    
    }
?>
</abbr>
</p>

<p class="adr">
<?php echo __('Where',true).' '; ?>
<span class="location street-address"><?php echo $event['Event']['address']?></span>, 
<span class="locality"><?php echo $html->link($event['City']['name'],'/events/index/'.$event['City']['slug']); ?></span>. <span class="country-name"><?php __($event['City']['Country']['name']); ?></span>.
</p>
</div>
</div>

<?php
    echo "<p class=\"tags\">";
    foreach($event['Tag'] as $tag):
      echo $html->link($tag['name'],'/events/index/'.$event['City']['slug']."/".$tag['slug'],array('rel'=>'tag'))." ";
    endforeach;
  echo "</p>";
?>
</div>
<?php

  endforeach;
endif;
?>

<?php
	echo $paginator->prev(__('« Previous ',true));
	echo $paginator->numbers();
	echo $paginator->next(__(' Next »',true));
?> 


</div>

<div id="calendar">
  <?php echo $calendar->calendar($year, $month, $data, $base_url); ?>
<?php     if(!empty($countries)): ?>

  <div id="cities_column">
  <h2><?php echo __('Cities',true); ?></h2>  
 
    <?php
      foreach($countries as $country):
        echo "<span class=\"country\">".__($country['name'],true)."</span>";
        echo "<ul>";
        foreach($country['cities'] as $city_c):
          echo "<li>".$html->link(ucfirst($city_c['City']['name']),'/events/index/'.$city_c['City']['slug'])."</li>";
        endforeach;
         echo "</ul>";
      endforeach;  
    ?>
  
</div>
<?php   endif; ?>

<?php   if(!empty($toptags)): ?>  
<div id="tags_column">
  <h2><?php echo __('Tags',true); ?></h2>
  <p class="tags">
  <?php

    foreach($toptags as $toptag):
      echo $html->link(ucfirst($toptag['tags']['name']),'/events/index/'.$city."/".$toptag['tags']['slug'],array('rel'=>'tag'))." <span class=\"tagnum\">(".$toptag[0]['events_num'].")</span><br/>";
    endforeach;
 
  ?>
  </p>
  </div>
<?php  endif; ?>
</div>

<div style="clear:both"></div>
