<?php
/**
 * Copyright 2008 Ivan Ribas
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    Ivan Ribas
 * @copyright Copyright 2008 Ivan Ribas
 * @license		http://www.opensource.org/licenses/mit-license.php The MIT License
 */

class User extends AppModel {

	var $name = 'User';
	var $useTable = 'users';
  var $actsAs = array('Containable');
  var $uses = array('User','UsersUser', 'Event', 'Comment');

	var $validate = array(
		
		'username' 		=> array(
                      'notEmpty'  => array(
                        'rule'      => 'notEmpty',
                        'message'   => 'Pleas write your desired username.',
                       ),
                       'unique' => array(
                        'rule'    => 'isUnique',
                        'message'    => 'This username is already in use.',
                        'allowEmpty' => true,
                       ),
		                   'length'   => array(
                        'rule'      => array( 'between',2 , 25 ),
                        'message'   => 'username must have between 2 and 25 characters.',
                        'allowEmpty'=> true,
                       ),
                       'alphaNumeric' => array(
                        'rule'    => 'alphaNumeric',
                        'message' => 'Only alphanumeric characters.'                 
                     )
                ),
		'password' => array(
                     'notEmpty' => array(
                        'rule' => 'notEmpty',
                        'message' => 'Please write your desired password.',
                     ),		
		                'alphaNumeric' => array(
		                    'rule' => 'alphaNumeric',
		                    'message' => 'Only alphanumeric characters.',
		                    'allowEmpty' => true,
		          ),
		                  'confirmation' => array(
		                    'rule' => 'passwordConfirmation',
		                    'message' => 'password and password confirmation must be the same',
		                    
		                  )
		
		),
    'web' => array(
                      'rule' => 'url',
											'message' => 'Please enter a valid web address',
											'required' => false,
											'allowEmpty' => true,
    ),
    'email'=> array(
                     'email' => array(
                              'rule' => 'email',
                               'message' => 'Please enter a valid email address',
                                ),
                       'unique' => array(
                        'rule'    => 'isUnique',
                        'message'    => 'This email is already in use.',
                        'allowEmpty' => true,                                
                         ),
    )
	);
		
	var $belongsTo = array(
	                        'City'=>array('className' => 'City'),
	                        );	
	                        
  var $hasAndBelongsToMany = array(
                                    'Attendee'=>array('className'=>'Event',
                                                      'joinTable' => 'events_users',
                                                      'foreignKey' => 'user_id',
                                                      'associationForeignKey' => 'event_id',
                                                      'unique'=>false,
                                                    ),
                                     'Friend' => array('className'=>'User',
                                                        'joinTable' => 'users_users',
                                                        'foreignKey' => 'user_id',
                                                        'associationForeignKey' => 'friend_id',
                                                        'unique' => false,
                                                        'fields' => array('id','username','slug','photo'),
                                     ),
      );
  var $hasMany = array('Event'=>array('className'=>'Event'),
                       'messageFrom'=>array('className'=>'Message',
                                            'foreignKey' => 'from_user_id',
                                            'dependent' => true,
                            ),
                            
                        'messageTo'=>array('className'=>'Message',
                                           'foreignKey' => 'to_user_id',
                                           'dependent' => true,
                        ),
                        
                        'Comment'=>array('className'=>'Comment'),
  ); 
  
  /**
   * Check if password and password confirmation are the same.
   */
   
  function passwordConfirmation() {
    return ($this->data['User']['password'] == $this->data['User']['password_confirm']);
  }
  
  /**
   * create the user slug before we save.
   */
   
  function beforeSave() {
    if(!empty($this->data['User']['username'])) {
      $this->data['User']['slug'] = Inflector::slug(strtolower($this->data['User']['username']));
    }
    return true;
  }
  
  /**  
   * Save friend
   *
   * @param $user_id int
   * @param $friend_id int
   *   
   */
   
  function add_friend($user_id,$friend_id) {

    $is_friend = $this->UsersUser->find(array('user_id'=>$user_id,'friend_id'=>$friend_id));
    if(!empty($is_friend)) return false;
            
    $new_friend['UsersUser']['user_id'] = $user_id;
    $new_friend['UsersUser']['friend_id'] = $friend_id;
    
    return $this->UsersUser->save($new_friend);
  }
  
  /**
   * delete friend
   *
   * @param $user_id int
   * @param $friend_id int
   *
   */
   
  function delete_friend($user_id,$friend_id) {
    $this->UsersUser->query('delete from users_users where user_id = '.$user_id.' and friend_id = '.$friend_id);
  }
  
  /** 
   * check if users are friends
   *
   * @param $user_id int
   * @param $friend_id int
   *
   */
   
  function is_friend($user_id, $friend_id) {
    $is_friend = $this->UsersUser->find(array('user_id'=>$user_id,'friend_id'=>$friend_id));
    return empty($is_friend);
  }
  
  /**
   * delete user and set their submited events and comments to 
   * anonymous user.
   *
   * @param $user_id int
   *
   */
   
   function delete_user($user_id) {
    if($this->delete($user_id)) {
      $this->Event->updateAll(array('Event.user_id'=>null),array('Event.user_id'=>$user_id));
      $this->Comment->updateAll(array('Comment.user_id'=>null),array('Comment.user_id'=>$user_id));
    }
   }
   
   /**
    * delete validation codes
    */
    
    function delete_validation_codes() {
      $this->query('update users set validation_code = null where validation_code is not null');
    }
}
?>