<?php
/**
 * Copyright 2008 Ivan Ribas
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    Ivan Ribas
 * @copyright Copyright 2008 Ivan Ribas
 * @license		http://www.opensource.org/licenses/mit-license.php The MIT License
 */

class Tag extends AppModel {

	var $name = 'Tag';
	var $useTable = 'tags';
	var $validate = array(
	
		'name' => array(
											'rule' => array('minLength', 2),
											'message' => 'Name must be at least 2 characters long',
											'required' => true 
										),
	);

  var $hasAndBelongsToMany = array('Event'=>array(
                                        'className'=>'Event',
                                        'unique' => false,
                                        )); 

  function beforeSave()
  {
    $this->data['Tag']['slug'] = Inflector::slug(strtolower(trim($this->data['Tag']['name'])),'-');
    return true;
  }

  function getTopTags($city_id=null)
  {
   if($city_id) {
   $toptags = $this->query('select tags.slug, tags.name, tags.id, count(events_tags.id) as events_num from tags left join events_tags on events_tags.tag_id = tags.id left join events on events.id = events_tags.event_id where events.city_id = '.$city_id.' group by tags.id order by events_num DESC limit 30');  
   }
   else {
  $toptags = $this->query('select tags.slug, tags.name, tags.id, count(events_tags.id) as events_num from tags left join events_tags on events_tags.tag_id = tags.id  group by tags.id order by events_num DESC limit 30');   
   }
   return $toptags;
  }
  
  function deleteEmptyTags() {
    $this->query('DELETE tags FROM tags LEFT JOIN events_tags ON events_tags.tag_id = tags.id WHERE events_tags.id IS NULL');
  }
  
  function deleteEventTags($event_id) {
    $this->query('DELETE from events_tags WHERE events_tags.event_id = '.$event_id);
  }
  
}
?>