<?php
/**
 * Copyright 2008 Ivan Ribas
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    Ivan Ribas
 * @copyright Copyright 2008 Ivan Ribas
 * @license		http://www.opensource.org/licenses/mit-license.php The MIT License
 */

class Event extends AppModel {

	var $name = 'Event';
	var $useTable = 'events';
	var $actsAs = array('Containable');
var $use = array('Event', 'EventsUser');

	var $validate = array(
		
		'name' => array(
											'rule' => array('minLength', 2),
											'message' => 'Name must be at least 2 characters long',
										),
		'notes' => array(
											'rule' => array('minLength', 2),
											'message' => 'Please add some notes',
										),
		'address' => array(
											'rule' => array('minLength', 2),
											'message' => 'Please add the address',
										),
    'web' => array(
                      'rule' => 'url',
											'message' => 'Please enter a valid web address',
											'required' => false,
											'allowEmpty' => true,
    ),
    'end_date' => array(
                      'rule' => 'checkEventDate',
                      'message' => 'Please enter a valid end date'
    ),
	);

  var $hasAndBelongsToMany = array(
                                    'Tag'=>array('className'=>'Tag'),
                                    'Attendees'=>array('className'=>'User',
                                                  'unique' => false,
                                                  'joinTable' => 'events_users',
                                                  'foreignKey' => 'event_id',
                                                  'asociationForeignKey' => 'user_id',
                                                  'fields' => array('id','username','photo', 'slug'),
                                      ),
      );
  
  var $belongsTo = array(
                          'City'=>array('className'=>'City'),
                          'User'=>array('className'=>'User',
                                        'fields' => array('id','username','slug')  
                                  )
  );                     
  
  var $hasMany = array('Comment'=>array('className'=>'Comment',
                                        'order'=> 'Comment.created ASC',
                                        ));    

  /**
   * As the event id is used in the slug we create it after saving the event.
   */
  
  function afterSave($created)
  {
    if($created) {
      $event_id = $this->getInsertID();
      $update_event['Event']['slug'] = $event_id."-".Inflector::slug(strtolower($this->data['Event']['name']),'-');
      $update_event['Event']['id'] = $event_id;
        
      $this->save($update_event);
    } 
  }
 
  /**
   * End date must be after start date, at least while we can't travel in time.
   */
   
  function checkEventDate()
  {
    if($this->data['Event']['end_date']<$this->data['Event']['start_date']) return false;
    else return true;
  }
  
  
  /**
   * remove the http::// part in the url, we add it later in the view.
   */
  
  function beforeSave() {
    if(isset($this->data['Event']['web'])){
      if(preg_match('(^http://)',$this->data['Event']['web'])){
        $this->data['Event']['web'] = substr($this->data['Event']['web'],7);
      }
    }
   return true;
  }
  
  /**
  * check if the user is going to this event_id
  *
  * @param $event_id int
  * @param $user_id int
  *
  */
  
  function isAttendee($event_id, $user_id) {
    $attendee = $this->EventsUser->find(array('event_id'=>$event_id,'user_id'=>$user_id));
    return $attendee;
  }
  
  /**
  * delete attendee
  *
  * @param $event_id int
  * @param $user_id int
  *
  */
  
  function delAttendee($event_id, $user_id) {
    $this->EventsUser->deleteAll(array('user_id'=>$user_id,'event_id'=>$event_id));
  }
  
  /**
  * add attendee to the event if it does not exist
  *
  * @param $event_id int
  * @param $user_id int
  *
  */
  
  function addAttendee($event_id, $user_id) {
    $exists = $this->EventsUser->find(array('event_id'=>$event_id,'user_id'=>$user_id));
    if(!$exists) {
      $data['EventsUser']['event_id'] = $event_id;
      $data['EventsUser']['user_id'] = $user_id;
      $this->EventsUser->save($data);
    }
  }
  
}
?>