<?php
/**
 * Copyright 2008 Ivan Ribas
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    Ivan Ribas
 * @copyright Copyright 2008 Ivan Ribas
 * @license		http://www.opensource.org/licenses/mit-license.php The MIT License
 */

class City extends AppModel {

	var $name = 'City';
	var $useTable = 'cities';

	var $validate = array(
		
		'name' => array(
											'rule' => array('minLength', 2),
											'message' => 'Name must be at least 2 characters long',
											'required' => true,
											'allowEmpty' => false,
										),
		'country_id' => array(
		                  'rule' => array('numeric'),
		                  'message' => 'You must select a country',
		                  'required' => true,
		                   'allowEmpty' => false,
		)								
	);
		
  var $belongsTo = array('Country'=>array('className'=>'Country'));
  var $hasMany = array(
                        'Event'=>array('className'=>'Event'),
                        'User'=>array('className' => 'User'),
                       ); 
  
  
  function beforeSave()
  {
    $this->data['City']['slug'] = Inflector::slug(strtolower($this->data['City']['name']),'-');
    $this->data['City']['name'] = ucfirst($this->data['City']['name']);
    return true;
  }
  
  /**
   *  Get all cities with events
   **/
  function getCities()
  {
	  $countries = $this->query(
	   'select country_id, countries.name from cities left join countries 
	    on cities.country_id = countries.id group by countries.name');
	  
	  $cities_array = array();
	  foreach($countries as $country):
	    $cities['name']=$country['countries']['name'];
	    $cities['cities']=$this->find('all',array('conditions'=>array(
	                    'country_id'=>$country['cities']['country_id'])));
	    $cities_array[]=$cities;
	  endforeach;  
	  return $cities_array;
  }
  
  /**
   *  Delete cities not associated to events or users
   */
   
  function deleteEmptyCities()
  {
    $this->query('delete cities from cities left join events on events.city_id = cities.id left join users on users.city_id = cities.id where events.id is null and users.id is null');
  }
}
?>