<?php
/**
 * Copyright 2008 Ivan Ribas
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    Ivan Ribas
 * @copyright Copyright 2008 Ivan Ribas
 * @license    http://www.opensource.org/licenses/mit-license.php The MIT License
 */

class UsersController extends AppController {

    var $name = 'Users';    
    var $components = array('Upload', 'Email'); 
    var $helpers = array('Html', 'Form', 'Time', 'Ajax', 'Javascript');
    var $uses = array('User', 'Event', 'Country', 'City');
  var $paginate = array(
                        'limit' => 30,
                        'order' => array(
                        'User.created' => 'desc'
                        )
                  );    	

    function beforeFilter() {
      $this->checkSession();
      $this->Auth->authorize = 'controller';      
      $this->Auth->allow('login','logout', 'view', 'register','recover',
                         'code_login', 'admin_delete_validation_codes');
      if($this->Auth->user('id')) {
        $this->Auth->allow('edit', 'change_password', 'upload', 
          'delete_user', 'add_friend', 'delete_friend', 'delete_photo');
      }
    }
    
   /**
    * Admin can access all actions in this controller
    */
     
   function isAuthorized() {
      return $this->Auth->user('admin');
   }
    
    /**
     * User login
     **/
     
    function login() {
    }
    
    /**
     * User logout
     **/

    function logout() {
        $this->redirect($this->Auth->logout());
    }
    
    /**
     * User registration
     **/
     
    function register() {
      if($this->Auth->user()) {
        $this->redirect(array('controller'=>'events','action'=>'index'));
      }
      if ($this->data) {
        $this->data['User']['password_confirm'] = $this->Auth->password($this->data['User']['password_confirm']);
        if($this->User->save($this->data)) {
          $this->Auth->login($this->data);
          $this->redirect('/users/view');
        }
      }
    }
    
    /**
     * View user's profile
     *
     * @param $user_slug string
     */
     
    function view($user_slug=null) {
      $me = $this->Auth->user();
      if($user_slug==null) $user_slug = $me['User']['slug'];
      if($user_slug==null) $this->redirect('/');
      
      $this->User->contain(array('City'=>array('fields'=>array('name'),'Country.name'),
                                 'Attendee'=>array('fields'=>array('name','slug','id'),
                                 'City'),
                                 'Event'=>array('fields'=>array('name','slug','id'),
                                 'City'),
                                 'Friend',
                            ));
      
      $user = $this->User->find(array('User.slug'=>$user_slug));
      if(empty($user)) {
        $this->flash(__('User does not exist', true), array('controller'=>'events', 'action'=>'index'));
      }

      if($me['User']['id']==$user['User']['id']) {
        $this->set('homepage',true);
      }
      $this->set('user',$user);
      $this->set('is_friend',$this->User->is_friend($me['User']['id'],$user['User']['id']));
    }

    /**
     * Edit user's profile
     */
     
   function edit() {
      if(!empty($this->data)) {
        $this->data['User']['id'] = $this->Auth->user('id');
        $this->data['City']['id'] = $this->City->field('id',array(
                'City.name'=>ucfirst($this->data['City']['name'])));    
        
        if($this->User->saveAll($this->data)) {
        $this->flash(__('Profile saved',true),array('action'=>'view'));
        }
      }
      else {
     	  $this->set('countries',$this->Country->getCountriesList());
        $user = $this->User->find(array('User.id'=>$this->Auth->user('id')));
        $this->set('user',$user);       
        $this->data = $user;
      }
   }
   
   /**
    * Change user's password
    */
    
   function change_password() {
    if(!empty($this->data)) {
      $this->User->recursive = -1;
      $this->data['User']['password'] = $this->Auth->password($this->data['User']['password']);
      $this->data['User']['password_confirm'] = $this->Auth->password($this->data['User']['password_confirm']);
      $this->data['User']['id'] = $this->Auth->user('id');
      if($this->User->save($this->data)) {
        $this->flash(__('New Password Saved',true),'/users/edit');
      }
    }
   }
   
   /**
    * Upload user photo with the upload component
    */
    
  function upload() {
		$me['User']['photo'] = $this->Auth->user('photo');
		$me['User']['id'] = $this->Auth->user('id');

    if(!empty($this->data)) {
			if(($me['User']['photo']!='user_photo.jpg') and is_file(WWW_ROOT.'img/users/'.$me['User']['photo'])) {
				unlink(WWW_ROOT.'img/users/'.$me['User']['photo']);
			}
		
			// set the upload destination folder
			$destination = WWW_ROOT.'img/users/';
			$filename = $me['User']['id'].'-'.rand(100,999).'.jpg';

			// grab the file
			$file = $this->data['Image']['filedata'];

			// upload the image using the upload component
			$result = $this->Upload->upload($file, $destination, $filename, array('type' => 'resizecrop', 'size' => array('75', '75'), 'output' => 'jpg'));

			if (!$result){
				$this->data['Image']['images'] = $this->Upload->result;
				$me['User']['photo'] = $filename;
				$this->User->save($me);
			} else {
				// display error
				$errors = $this->Upload->errors;
				// piece together errors
				if(is_array($errors)){ $errors = implode("<br />",$errors); }
					$this->Session->setFlash($errors);
					$this->redirect('/users/upload');
					exit();
				}
				$this->data = null;
				$this->flash(__('Photo Saved',true),'/users/view');	
				}
		  }
		  
		  /**
		   * Delete user photo
		   */
		   
		  function delete_photo() {
		    $this->User->recursive = -1;
		    $me = $this->User->find(array('User.id'=>$this->Auth->user('id')),
		                            array('id','photo')
		                            );
	      	    
		    if(($me['User']['photo']!='user_photo.jpg') and is_file(WWW_ROOT.'img/users/'.$me['User']['photo'])) {
          unlink(WWW_ROOT.'img/users/'.$me['User']['photo']);
          $me['User']['photo'] = 'user_photo.jpg';
          $this->User->save($me);
          $this->flash(__('Photo Deleted',true),'/users/view');
			  }
        else {
          $this->redirect('/users/edit');
        }
		  }
		  
		  /**
		   * Add user to the friend list. Param $friend_id is the id of the
		   * user to be addded as friend.
		   *
		   * @param $friend_id int
		   */
		   
		   function add_friend($friend_id) {
		    $me_id = $this->Auth->user('id');
		    $this->User->recursive = -1;
        $friend = $this->User->find(array('id'=>$friend_id),array('slug'));
        if(empty($friend)) {
          $this->flash(__('User Does Not Exist',true),array('action'=>'view'));
        }
        
		    if($this->User->add_friend($me_id,$friend_id)) {
		      $this->flash(__('Friend Saved',true),'/users/view/'.$friend['User']['slug']);
		    }
		    else {
          $this->redirect('/users/view/'.$friend['User']['slug']);		    
		    }
		   }
		   
		   /**
		    * remove friend from friend list
		    *
		    * @param $friend_id int
		    */
		    
		   function delete_friend($friend_id) {
		    $me_id = $this->Auth->user('id');
		    $this->User->recursive = -1;
		    $user = $this->User->find(array('id'=>$friend_id),array('slug'));
		    if(!empty($user)) {
		      $this->User->delete_friend($me_id,$friend_id);
		      $this->flash(__('User Removed From Friend List',true),'/users/view/'.$user['User']['slug']);
		    }
		    else {
		      $this->redirect('/users/view');
		    }
		   }
		   
		   /**
		    * Delete user account after confirmation.
		    * 
		    * @param $confirmation string
		    */
		    
		    function delete_user($confirmation=null) {
		      if($confirmation!=null) {
		        $this->User->delete_user($this->Auth->user('id'));
  		      $this->redirect($this->Auth->logout());
          }
		    }
		    
		    /**
		     * If user forgot the password we create a new url for him
		     * to access his account.
		     */
		     
		     function recover() {
		      if(!empty($this->data)) {
		        $email = $this->data['User']['email'];
		        $this->User->recursive = -1;
		        $user = $this->User->find(array('email'=>$email),array('id','username','email')); 
		        if(!empty($user)) {
		          $validation_code = sha1(rand().'-'.time());
		          $user['User']['validation_code'] = $validation_code;
		          if($this->User->save($user)) {
                $this->set('recover',true);
                $this->set('code',$validation_code);
                $this->set('user',$user);
                $this->Email->from = Configure::read('eventoSettings.systemEmail');
                $this->Email->to = $user['User']['username'].'  <'.$user['User']['email'].'>';
                $this->Email->subject = __('Password Recovery for Evento',true);
                $this->Email->delivery = 'mail';
                $this->Email->template = 'password_recovery';
                $this->Email->sendAs = 'text';
                $this->Email->send();
  //           debug($this->Session->read('Message.email'));		            
		          }
		        }
		        else {
		           $this->set('recover',false);
		        }
		      }
		     }
		     
		     /**
		      * login a user without using password with the random code 
		      * created with the recover action.
		      *
		      * @param $code string
		      */
		      
		     function code_login($code) {
		      $user = $this->User->find(array('validation_code'=>$code),array('id','username','password'));
		      if(!empty($user)) {
		        $this->Auth->login($user);
		        $this->set('code_login',true);
		        $remove_code['User']['id'] = $user['User']['id'];
		        $remove_code['User']['validation_code'] = null;
		        $this->User->save($remove_code);
		      }
		      else{
		        $this->set('code_login',false);		      
		      } 
		     }
		     
		    ////////////////////////////////////////////////////////////////
		    /////////////////////////////////////////////////////////  ADMIN
		    ////////////////////////////////////////////////////////////////
		   
		   /**
		    * admin index paginates a list of users
		    *
		    */
		    
		   function admin_index() {
		    $this->set('users',$this->paginate('User'));
		   }
		   
		   /**
		    * Admin delete users
		    *
		    * @param $user_id int
		    *
		    */
		    
		   function admin_delete_user($user_id) {
		    $this->User->delete_user($user_id);
		    $this->redirect(array('action'=>'index'));
		   }
		   
		   /**
		    * Admin change user password
		    *
		    * @param $user_id int
		    *
		    */
		    
		    function admin_change_password($user_id) {
		      if(!empty($this->data)) {
            $this->data['User']['password'] = $this->Auth->password($this->data['User']['password']);
            $this->data['User']['password_confirm'] = $this->Auth->password($this->data['User']['password_confirm']);
            $this->data['User']['id'] = $user_id;
            if($this->User->save($this->data)) {
              $this->flash(__('Password Changed',true),'/admin/users/index');
            }
		      }
		      $this->set('user_id',$user_id);
		    }
		    
		     /**
		      * Remove validation codes. Add this action to cron to remove
		      * validation codes automatically.
		      */
		      
		      function admin_delete_validation_codes() {
		        $this->User->delete_validation_codes();
		      }		    
}
?>