<?php
/**
 * Copyright 2008 Ivan Ribas
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    Ivan Ribas
 * @copyright Copyright 2008 Ivan Ribas
 * @license		http://www.opensource.org/licenses/mit-license.php The MIT License
 */

uses('sanitize');

class MessagesController extends AppController{

    var $name = 'Messages';
    var $uses = array('Message', 'User');
    var $helpers = array('Time', 'Html', 'Form');
    var $components = array('RequestHandler', 'Email');
    
    var $paginate = array(
        'limit' => 25,
        'order' => array(
        'Message.created' => 'DESC'
        )
    );


    function beforeFilter() {
      $this->checkSession();
    }
    
    /**
     * Show incoming messages.
     */
     
    function inbox() {
      $this->__setMessages(true);
      $this->set('inbox',true);
      $this->render('mailbox');
    }
    
    /** 
     * Show sent messages.
     */
    
    function outbox() {
      $this->__setMessages(false);
      $this->render('mailbox');
    }
    
    /**
     * Private function used to set the user messages depending on the
     * requested mail box.
     *
     * @param $inbox bool 
     */
     
    function __setMessages($inbox=true) {    
      $mbox = ($inbox)? 'to_user_id' : 'from_user_id';
      $delm = ($inbox)? 'to_user_delete' : 'from_user_delete';
      $user_id = $this->Auth->user('id');
      $messages = $this->paginate('Message',array($mbox=>$user_id, $delm=>0));
      $this->set('messages',$messages);
    }
    
    /**
     *  Write and send a message.
     */
     
    function write($user_id) {
      $user = $this->User->recursive = -1;
      $user = $this->User->find(array('User.id'=>$user_id));
      $this->set('user',$user);
      
      if(!empty($this->data)) {
  			$clean = new Sanitize();
    		$clean->clean($this->data);
  			$this->data['Message']['message']  = $clean->html($this->data['Message']['message'], true);
        $this->data['Message']['subject'] = $clean->html($this->data['Message']['subject'],true);
          
        $this->data['Message']['from_user_id'] = $this->Auth->user('id');
        $this->data['Message']['to_user_id'] = $user_id;

        if($this->Message->save($this->data)) {
          if($user['User']['notification']) {
            $this->set('message_id',$this->Message->getInsertID());
            $this->Email->from    = Configure::read('eventoSettings.systemEmail');
            $this->Email->to      = $user['User']['username'].'  <'.$user['User']['email'].'>';
            $this->Email->subject = __('You have a new message in Evento',true);
            $this->Email->delivery = 'mail';
            $this->Email->template = 'new_message';
            $this->Email->sendAs = 'text';
            $this->Email->send();
//          debug($this->Session->read('Message.email'));
          }
          $this->flash(__('Message Saved',true),'/users/view/'.$user['User']['slug']);
        }      
      } 
    }
    
    /**
     *  show message.
     * 
     * @param $message_id int
     */

  function read($message_id) {
    $message = $this->Message->find(array('Message.id'=>$message_id));
    $me_id = $this->Auth->user('id');
    if(($message['userFrom']['id']!= $me_id) and ($message['userTo']['id']!= $me_id)) {
      $this->redirect('/');
      return false;
    }
    
    if($me_id!=$message['userFrom']['id']) {
      $user =  $message['userFrom'];
      if($message['Message']['new'] == 1) {
        $this->Message->id = $message['Message']['id'];
        $this->Message->saveField('new',0);
        $this->set('messages_number',$this->Message->countUserMessages($me_id));        
      }
    }
    else {
      $user = $message['userTo'];
    }

    $this->set('user',$user);
    $this->set('message',$message);
    $this->set('me',$me_id);
  }
  
  /**
   * Delete a message
   *
   * @param $message_id int
   */
   
  function delete_message($message_id) {
    $mbox = $this->Message->deleteMessage($message_id,$this->Auth->user('id'));
    if($mbox) {
      $this->flash(__('Message Deleted',true),'/messages/'.$mbox);    
    }
    else {
      $this->redirect('/messages/inbox');
    }
  }
}
?>