<?php
/**
 * Copyright 2008 Ivan Ribas
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    Ivan Ribas
 * @copyright Copyright 2008 Ivan Ribas
 * @license    http://www.opensource.org/licenses/mit-license.php The MIT License
 */

class FeedsController extends AppController{

    var $name = 'Feeds';
    var $uses = array('Event');
    var $helpers = array('Time');
    var $components = array('RequestHandler');

    function beforeFilter() {
      $this->Auth->allow('index');
    }
    
    function index($feed = 'events'){    
        $conditions['limit'] = 25;
        $conditions['order'] = 'created DESC';
        
        if($feed!='events') $conditions['conditions'] = array('City.slug'=>$feed);
        
        $this->set('events', $this->Event->find('all',$conditions));
    }
}
?>