<?php
/**
 * Copyright 2008 Ivan Ribas
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    Ivan Ribas
 * @copyright Copyright 2008 Ivan Ribas
 * @license		http://www.opensource.org/licenses/mit-license.php The MIT License
 */
class CommentsController extends AppController {

    var $name = 'Comments';    
    var $helpers = array('Html', 'Form', 'Time', 'Ajax', 'Javascript');
    var $uses = array('User', 'Event', 'Comment');
    var $paginate = array(
                        'limit' => 15,
                        'order' => array(
                        'Comment.created' => 'desc'
                        )
                  );
                      	

    function beforeFilter() {
      $this->checkSession();
      $this->Auth->authorize = 'controller';
      if(Configure::read('eventoSettings.allowAnonymousComments') or $this->Auth->user('id')) {
        $this->Auth->allow('write');
      }
    }

    /**
     * Admin can access all actions
     */
     
    function isAuthorized() {
      return $this->Auth->user('admin');
    }
    
    /** 
     * write a comment for an event.
     *
     * @param $event_id int
     */
         
    function write($event_id=null) {
      $this->Event->recursive =0;
      $event = $this->Event->find(array('Event.id'=>$event_id));
      
      if(empty($event)) {
        $this->redirect('/');
        return false;
      }
      
      if(!empty($this->data)) {
        $this->data['Comment']['user_id'] =  $this->Auth->user('id');
        $this->data['Comment']['event_id'] = $event_id;
        
        if($this->Comment->save($this->data)) {
          $this->flash(__('Comment Saved',true),'/events/view/'.$event['City']['slug'].'/'.$event['Event']['slug']);
        }
      }
      
      $this->set('event',$event);
    }
    
    ////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////  ADMIN
    ////////////////////////////////////////////////////////////////////

    /**
     * Show all comments
     */
     
    function admin_index() {
      $this->set('comments',$this->paginate('Comment'));
    }
    
    /**
     * Delete one comment.
     *
     * @param $comment_id int
     */
     
    function admin_delete($comment_id) {
      $this->Comment->delete($comment_id);
      $this->flash(__('Comment Deleted',true),array('action'=>'index'));
    }
}
?>