<?php

require_once( "objs/dateclass.php" );
require_once( "objs/ini_fn.php" );

# calendar class
# coded by Alessandro Rosa
# e-mail : zandor_zz@yahoo.it
# site : http://malilla.supereva.it

# LAST UPDATE : Dec 14th 2006

# Copyright (C) 2006  Alessandro Rosa

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

# Compiled with PHP 4.4.0

$seasons_colors = array( 1 => "#F0F8FF", 
                         2 => "#ECF1EF",
                         3 => "#CD3278",
                         4 => "#B4EEB4",
                         5 => "#B22222",
                         6 => "#FF6347",
                         7 => "#00C5CD",
                         8 => "#7AA5CD",
                         9 => "#B3EE3A",
                         10 => "#CD9B1D",
                         11 => "#8B0000",
                         12 => "#8B8B00" ) ;

$seasons_text_colors = array( 1 => "black", 
                              2 => "#b3b3b3",
                              3 => "white",
                              4 => "green",
                              5 => "white",
                              6 => "purple",
                              7 => "cyan",
                              8 => "white",
                              9 => "yellow",
                              10 => "orange",
                              11 => "white",
                              12 => "#f3f3f3" ) ;



# REMARK : refer to the global arrays in dateclass.php for months and days names

      function invert_HEXcolor( $clrCODE )
      {
          if ( substr( $clrCODE, 0, 1 ) == "#" ) $clrCODE = str_replace( "#", "", $clrCODE );  // strip it out !
          
          $r = substr( $clrCODE, 0, 2 );
          $g = substr( $clrCODE, 2, 2 );
          $b = substr( $clrCODE, 4, 2 );
      
          $r = dechex( 255 - hexdec( $r ) );    $r = ( hexdec( $r ) <= 15 ) ? "0$r" : $r ;
          $g = dechex( 255 - hexdec( $g ) );    $g = ( hexdec( $g ) <= 15 ) ? "0$g" : $g ;
          $b = dechex( 255 - hexdec( $b ) );    $b = ( hexdec( $b ) <= 15 ) ? "0$b" : $b ;

          return "#$r$g$b";
      }

class calendar
{
      function calendar()
      {
          $this->path_to_calendar = "" ;
      }
      
      function build_it()     
      {
             $p = $_SERVER['PHP_SELF'] ;
             $dclass = new date();

             echo "<table align=\"center\" class=\"calendar\">\r\n";
             
             $a = getdate();
             $this->today_d = $day = $a['mday'] ;
             $week_day = $a['wday'] ;
             $this->today_m = $month = $a['mon'] ;
             $this->today_y = $year = $a['year'] ;

             if ( strlen( $_GET['d'] ) > 0 )
             {
                    $a = explode( "/", $_GET['d'] );
                    $month = $a[0] ; $day = $a[1] ; $year = $a[2] ;
                    
                    $dclass->set_start_date( $day, $month, $year ) ;
                    $week_day = $dclass->get_start_day_index();
             }

             $this->today_full_name = $GLOBALS['name_days'][$week_day];
             
             $strMONTH = ( intval( $month ) < 10 ) ? "0$month" : $month ;
             $strDAY = ( intval( $day ) < 10 ) ? "0$day" : $day ;
             $appSTR = get_params_ini( "APPOINTMENTS",
                                       "$strMONTH/$strDAY/$year",
                                       $this->path_to_calendar."ini/appointments.ini" ) ;
             
             $season_clr = $GLOBALS['seasons_colors'][$month] ;
             $season_text_clr = $GLOBALS['seasons_text_colors'][$month] ;
             
             $dclass->set_start_date( 1, $month, $year ) ;
             
             $month_name = $dclass->get_start_month_name();
             $first_day_index = $dclass->get_start_day_index() ;
             
             echo "<tr>\r\n";
             echo "<td align=\"center\" style=\"width:100%;background-color:$season_clr;\">\r\n";
                  echo "\t\t<table class=\"monthname\" align=\"center\">\r\n";
                  echo "\t\t<tr>\r\n";

                  echo "\t\t<td style=\"color:$season_text_clr;\" class=\"month\">$month_name</td>\r\n";

                  if ( $this->bDisplayAGENDA )
                  {
                      echo "\t\t<td style=\"width:30px;\"></td>\r\n";
                      echo "\t\t<td align=\"right\" width=\"20\"><a href=\"mng.php?y=$year\"><img border=\"0\" src=\"img/agenda.gif\" /><a></td>\r\n";
                      echo "\t\t<td style=\"width:3px;\"></td>\r\n";
                  }
                  echo "\t\t</tr>\r\n";
                  echo "\t\t</table>\r\n";
             echo "</td>\r\n";
             echo "</tr>\r\n";
             echo "<tr>\r\n";
             
             echo "<td style=\"width:100%;\">\r\n" ;
             
             echo "\t\t\t\t<table class=\"scheme\">\r\n" ;
             echo "\t\t\t\t<tr class=\"wdays\">\r\n" ;
             if ( $this->bSundayStart === true ) echo "\t\t\t\t<td class=\"weekdays\">".(( $week_day == 0 ) ? "<b>".$GLOBALS['short_name_days']['0']."</b>" : $GLOBALS['short_name_days']['0'])."</td>\r\n";
             echo "\t\t\t\t<td class=\"weekdays\">".(( $week_day == 1 ) ? "<b>".$GLOBALS['short_name_days']['1']."</b>" : $GLOBALS['short_name_days']['1'])."</td>\r\n";
             echo "\t\t\t\t<td class=\"weekdays\">".(( $week_day == 2 ) ? "<b>".$GLOBALS['short_name_days']['2']."</b>" : $GLOBALS['short_name_days']['2'])."</td>\r\n";
             echo "\t\t\t\t<td class=\"weekdays\">".(( $week_day == 3 ) ? "<b>".$GLOBALS['short_name_days']['3']."</b>" : $GLOBALS['short_name_days']['3'])."</td>\r\n";
             echo "\t\t\t\t<td class=\"weekdays\">".(( $week_day == 4 ) ? "<b>".$GLOBALS['short_name_days']['4']."</b>" : $GLOBALS['short_name_days']['4'])."</td>\r\n";
             echo "\t\t\t\t<td class=\"weekdays\">".(( $week_day == 5 ) ? "<b>".$GLOBALS['short_name_days']['5']."</b>" : $GLOBALS['short_name_days']['5'])."</td>\r\n";
             echo "\t\t\t\t<td class=\"weekdays\">".(( $week_day == 6 ) ? "<b>".$GLOBALS['short_name_days']['6']."</b>" : $GLOBALS['short_name_days']['6'])."</td>\r\n";
             if ( $this->bSundayStart === false ) echo "\t\t\t\t<td class=\"weekdays\">".(( $week_day == 0 ) ? "<b>".$GLOBALS['short_name_days']['0']."</b>" : $GLOBALS['short_name_days']['0'])."</td>\r\n";
             echo "\t\t\t\t</tr>\r\n" ;

             echo "<tr><td style=\"height:5px;\"></td></tr>\r\n";

             $cell_current_index = ( $this->bSundayStart ) ? $first_day_index : $first_day_index - 1 ;
             $cell_current_index = ( $cell_current_index == 7 ) ? 0 : $cell_current_index ;
             
             echo "<tr>\r\n" ;
             
             for ( $i = 0; $i < $cell_current_index; $i++ )
             {
                 echo "\t\t\t\t<td class=\"calendar\"></td>\r\n" ;
             }
             
             $cell_current_index = $i ;
             
             $month_days = $dclass->get_month_days( $month, $year ) ;
             $bAppointments = false ;

             for( $i = 1 ; $i <= $month_days; $i++ )
             {
                 $strMONTH = ( intval( $month ) < 10 ) ? "0$month" : $month ;
                 $strDAY = ( intval( $i ) < 10 ) ? "0$i" : $i ;

                 $aSTR = get_params_ini( "APPOINTMENTS", "$strMONTH/$strDAY/$year", $this->path_to_calendar."ini/appointments.ini" ) ;
                 $aIN = $aOUT = "" ;
                 
                 if ( strlen( $aSTR ) > 0 )
                 {
                      $aIN = "<a class=\"days\" href=\"$p?d=$month/$i/$year\">" ;
                      $aOUT = "</a>" ;
                      $bAppointments = true ;
                 }
                 
                 $bkImage = ( $i < $day ) ? "background-color:#e9e9e9;" : "" ;
                 
                 if ( $i == $day ) echo "\t\t\t\t<td style=\"$bkImage\" class=\"calendar\"><b $code>$aIN$i$aOUT</b></td>\r\n" ;
                 else echo "\t\t\t\t<td style=\"$bkImage\" class=\"calendar\">$aIN$i$aOUT</td>\r\n" ;

                 $cell_current_index++ ;
             
                 $cell_current_index %= 7 ;
                 
                 if ( $cell_current_index == 0 ) echo "</tr>\r\n";
                 if ( $cell_current_index == 0 && $i < $month_days ) echo "<tr>\r\n" ;
             }
             
             if ( $cell_current_index > 0 )
             {
                 for ( $i = $cell_current_index ; $i < 7; $i++ )
                 {
                      $bkImage .= "border:0px solid;" ;
                      echo "\t\t\t\t<td style=\"$bkImage\" class=\"calendar\"></td>\r\n";
                 }
                 
                 echo "</tr>\r\n";
             }
             
             echo "\t\t\t\t<tr><td colspan=\"7\" style=\"height:5px;\"></td></tr>\r\n";
             
             if ( $this->get_display_today() )
             {
                  $aIN = "<a class=\"today\" href=\"$p\">" ;
                  $aOUT = "</a>" ;
                  echo "\t\t\t\t<tr><td class=\"today\" colspan=\"7\">$aIN"."Today$aOUT is : ".$this->get_today_full_name()." ".$this->get_today_date()."";
                  
                  if ( strlen( $appSTR ) > 0 )
                  echo "&nbsp;&nbsp;&nbsp;<a href=\"javascript:showAPPStab();\"><img id=\"dropdownBTN\" border=\"0\" src=\"$this->path_to_calendar"."img/btndown.png\"></a></td></tr>\r\n" ;
             }
             
             /////// CHECK IF APPOINTMENTS HAVE BEEN SET ////////////////
             if ( strlen( $appSTR ) > 0 )
             {
                 echo "\t\t\t\t<tr><td colspan=\"7\">\r\n";
                 echo "\t\t\t\t\t<table id=\"appsTABLE\" class=\"appointments\">\r\n";
                 
                 $appARRAY = explode( ",", $appSTR );
                 $appNUMS = count( $appARRAY );
                 for ( $i = 0 ; $i < $appNUMS ; $i++ )
                 {
                     echo "\t\t\t\t\t<tr><td class=\"appointments\">".$appARRAY[$i]."</td></tr>\r\n" ;
                 }
                 
                 echo "\t\t\t\t\t</table>\r\n";
                 
                 echo "</td></tr>\r\n" ;
             }
             
             echo "</td>\r\n" ;
             echo "</tr>\r\n";
             echo "</table>\r\n";

if ( $bAppointments )
{
             echo "<script language=\"javascript\">\r\n" ;
             echo "\t\tobj1 = document.getElementById(\"appsTABLE\");\r\n";
             echo "\t\tobj1.style.display = \"block\" ;\r\n";
             echo "\t\tfunction showAPPStab()\r\n";
             echo "\t\t{\r\n" ;
             echo "\t\tobj1 = document.getElementById(\"appsTABLE\");\r\n";
             echo "\t\tobj1.style.display = ( obj1.style.display == \"block\" ) ? \"none\" : \"block\" ;\r\n";
             echo "\t\tobj = document.getElementById(\"dropdownBTN\");\r\n";
             echo "\t\tobj.src = ( obj1.style.display == \"block\" ) ? \"$this->path_to_calendar"."img/btnup.png\" : \"$this->path_to_calendar"."img/btndown.png\" ;\r\n";
             echo "\t\t}\r\n";
             echo "\t\t\t</script>\r\n";
}

      }
      
      function display_english_date( $bED )           { $this->bEngDate = $bED ; }
      function get_display_english_date_opt( $bED )   { return $this->bEngDate ; }

      function get_display_agenda()           { return $this->bDisplayAGENDA ; }
      function set_display_agenda( $bDA )     { $this->bDisplayAGENDA = $bDA ; }

      function get_sunday_start()           { return $this->bSundayStart ; }
      function set_sunday_start( $bS )      { $this->bSundayStart = $bS ;  }

      function get_display_today()          { return $this->bDisplayToday ; }
      function set_display_today( $bDt )    { $this->bDisplayToday = $bDt ; }

      function get_path_to_calendar()                { return $this->path_to_calendar ;       }
      function set_path_to_calendar( $pathToCal )    { $this->path_to_calendar = $pathToCal ; }

      function get_today_date()             { return ( ( $this->bEngDate ) ? $this->today_m."-".$this->today_d : $this->today_d."-".$this->today_m ) . "-".$this->today_y ; }
      function get_today_full_name()        { return $this->today_full_name ; }

      var $bSundayStart = TRUE ;
      var $bDisplayToday = TRUE ;
      var $bEngDate = TRUE ;
      var $bDisplayAGENDA = FALSE ;

      var $today_d ;
      var $today_m ;
      var $today_y ;
      var $today_full_name ;

      var $path_to_calendar ;
}
